/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.tests.BaseModelApiTest;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Aspect;
import org.junit.Assert;
import org.junit.Test;

public class TestAspects
extends BaseModelApiTest {
    @Test
    public void testAllAspects() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertTrue((this.aspects.getPaging().getTotalItems() > 135 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.aspects.getPaging().getHasMoreItems());
        this.paging.setSkipCount(130);
        this.paging.setMaxItems(50);
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertFalse((boolean)this.aspects.getPaging().getHasMoreItems());
    }

    @Test
    public void filterAspectsByNamespace() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)4);
        Assert.assertFalse((boolean)this.aspects.getPaging().getHasMoreItems());
        this.otherParams.put("where", "(not namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertTrue((this.aspects.getPaging().getTotalItems() > 130 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.aspects.getPaging().getHasMoreItems());
    }

    @Test
    public void filterAspectsByParentId() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(parentId in ('smf:smartFolder','mycompany:testAspect'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.childAspect);
        ((Aspect)this.aspects.getList().get(1)).expected(this.testAspect);
        ((Aspect)this.aspects.getList().get(3)).expected(this.smartFilterAspect);
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)4);
        Assert.assertFalse((boolean)this.aspects.getPaging().getHasMoreItems());
        this.otherParams.put("where", "(parentId in ('smf:smartFolder','mycompany:testAspect') AND namespaceUri matches('http://www.test.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.smartFilterAspect);
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)1);
        this.otherParams.put("where", "(parentId in ('smf:smartFolder', 'mycompany:testAspect') AND not namespaceUri matches('http://www.test.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.childAspect);
        ((Aspect)this.aspects.getList().get(1)).expected(this.testAspect);
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)3);
        this.otherParams.put("where", "(parentId in ('smf:smartFolder','mycompany:testAspect') AND namespaceUri matches('.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)4);
        this.otherParams.put("where", "(parentId in ('smf:smartFolder', 'mycompany:testAspect') AND not namespaceUri matches('.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)0);
    }

    @Test
    public void filterAspectsByModelId() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)6);
        Assert.assertFalse((boolean)this.aspects.getPaging().getHasMoreItems());
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('http://www.test.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.rescanAspect);
        ((Aspect)this.aspects.getList().get(1)).expected(this.smartFilterAspect);
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)2);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND not namespaceUri matches('http://www.test.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)4);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)6);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND not namespaceUri matches('.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)0);
    }

    @Test
    public void testIncludeProperty() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('http://www.test.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.rescanAspect);
        Assert.assertNull((Object)((Aspect)this.aspects.getList().get(0)).getProperties());
        ((Aspect)this.aspects.getList().get(1)).expected(this.smartFilterAspect);
        Assert.assertNull((Object)((Aspect)this.aspects.getList().get(1)).getProperties());
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('http://www.test.*'))");
        this.otherParams.put("include", "properties");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.rescanAspect);
        Assert.assertNotNull((Object)((Aspect)this.aspects.getList().get(0)).getProperties());
        ((Aspect)this.aspects.getList().get(1)).expected(this.smartFilterAspect);
        Assert.assertNotNull((Object)((Aspect)this.aspects.getList().get(0)).getProperties());
    }

    @Test
    public void testIncludeAssociation() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('api:apiModel'))");
        this.otherParams.put("include", "associations");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)6);
        for (Aspect aspect : this.aspects.getList()) {
            Assert.assertNotNull((Object)aspect.getAssociations());
            Assert.assertNull((Object)aspect.getProperties());
            Assert.assertNull((Object)aspect.getMandatoryAspects());
        }
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(0)).getAssociations().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(1)).getAssociations().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(2)).getAssociations().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(3)).getAssociations().isEmpty());
        Assert.assertEquals((Object)((Aspect)this.aspects.getList().get(4)).getAssociations(), (Object)this.testAllAspect.getAssociations());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(5)).getAssociations().isEmpty());
    }

    @Test
    public void testIncludeMandatoryAspect() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('api:apiModel'))");
        this.otherParams.put("include", "mandatoryAspects");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)6);
        for (Aspect aspect : this.aspects.getList()) {
            Assert.assertNotNull((Object)aspect.getMandatoryAspects());
            Assert.assertNull((Object)aspect.getProperties());
            Assert.assertNull((Object)aspect.getAssociations());
        }
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(0)).getMandatoryAspects().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(1)).getMandatoryAspects().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(2)).getMandatoryAspects().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(3)).getMandatoryAspects().isEmpty());
        Assert.assertEquals((Object)((Aspect)this.aspects.getList().get(4)).getMandatoryAspects(), (Object)this.testAllAspect.getMandatoryAspects());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(5)).getMandatoryAspects().isEmpty());
    }

    @Test
    public void testIncludes() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('api:apiModel'))");
        this.otherParams.put("include", "associations,mandatoryAspects");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)6);
        for (Aspect aspect : this.aspects.getList()) {
            Assert.assertNotNull((Object)aspect.getAssociations());
            Assert.assertNotNull((Object)aspect.getMandatoryAspects());
            Assert.assertNull((Object)aspect.getProperties());
        }
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(0)).getAssociations().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(1)).getAssociations().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(2)).getAssociations().isEmpty());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(3)).getAssociations().isEmpty());
        Assert.assertEquals((Object)((Aspect)this.aspects.getList().get(4)).getAssociations(), (Object)this.testAllAspect.getAssociations());
        Assert.assertEquals((Object)((Aspect)this.aspects.getList().get(4)).getMandatoryAspects(), (Object)this.testAllAspect.getMandatoryAspects());
        Assert.assertTrue((boolean)((Aspect)this.aspects.getList().get(5)).getAssociations().isEmpty());
    }

    @Test
    public void testSubAspects() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('mycompany:model'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)4);
        this.otherParams.put("where", "(modelId in ('mycompany:model INCLUDESUBASPECTS'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)5);
        this.otherParams.put("where", "(modelId in ('mycompany:model INCLUDESUBASPECTS') AND namespaceUri matches('http://www.test.*'))");
        this.aspects = this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
        ((Aspect)this.aspects.getList().get(0)).expected(this.smartFilterAspect);
        Assert.assertEquals((Object)this.aspects.getPaging().getTotalItems(), (Object)1);
    }

    @Test
    public void testAspectsById() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.aspect = this.publicApiClient.aspects().getAspect("mycompany:childAspect");
        this.aspect.expected(this.childAspect);
        this.aspect = this.publicApiClient.aspects().getAspect("test2:aspect-all");
        Assert.assertEquals((String)"mandatoryAspects not matched", (Object)this.aspect.getMandatoryAspects(), (Object)this.testAllAspect.getMandatoryAspects());
        Assert.assertEquals((String)"association not matched", (Object)this.aspect.getAssociations(), (Object)this.testAllAspect.getAssociations());
        this.aspect.expected(this.testAllAspect);
    }

    @Test
    public void testListAspectByInvalidValue() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.testListAspectException("(modelId in ('mycompany:model','unknown:model','known:model'))");
        this.testListAspectException("(modelId in ('unknown:model','mycompany:model'))");
        this.testListAspectException("(modelId in (' ',' ',' ')");
        this.testListAspectException("(parentId in ('smf:smartFolder','unknown:aspect'))");
        this.testListAspectException("(parentId in ('unknown:aspect','smf:smartFolder'))");
        this.testListAspectException("(parentId in (' ',' ',' ')");
        this.testListAspectException("(namespaceUri matches('*'))");
    }

    @Test
    public void testGetAspectByInvalidValue() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.testGetAspectExceptions("unknown:childAspect");
        this.testGetAspectExceptions("aspect:");
        this.testGetAspectExceptions("aspect");
    }

    private void testGetAspectExceptions(String aspectId) {
        try {
            this.publicApiClient.aspects().getAspect(aspectId);
            Assert.fail((String)"Aspect not found expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    private void testListAspectException(String query) {
        try {
            this.otherParams.put("where", query);
            this.publicApiClient.aspects().getAspects(this.createParams(this.paging, this.otherParams));
            Assert.fail((String)"Bad request expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }
}

