/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.download;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.download.AbstractDownloadWebscript;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DownloadStatusGet
extends AbstractDownloadWebscript {
    protected NodeService nodeService;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            throw new WebScriptException(400, error);
        }
        if (!(templateVars.containsKey("store_type") && templateVars.containsKey("store_id") && templateVars.containsKey("node_id"))) {
            String error = "Missing template variables (store_type, store_id or node_id).";
            throw new WebScriptException(400, error);
        }
        StoreRef store = new StoreRef((String)templateVars.get("store_type"), (String)templateVars.get("store_id"));
        NodeRef nodeRef = new NodeRef(store, (String)templateVars.get("node_id"));
        if (!this.nodeService.exists(nodeRef)) {
            String error = "Could not find node: " + String.valueOf(nodeRef);
            throw new WebScriptException(404, error);
        }
        DownloadStatus downloadStatus = this.downloadService.getDownloadStatus(nodeRef);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("downloadStatus", downloadStatus);
        return result;
    }

    public void setNodeService(NodeService nodeSerivce) {
        this.nodeService = nodeSerivce;
    }
}

