/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;

class BlockingRemoteUserMapper
implements RemoteUserMapper,
ActivateableBean {
    public static final int BLOCKING_FOR_MILLIS = 1000;
    private volatile boolean wasInterrupted;
    private volatile int timePassed;
    private boolean isEnabled = true;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    BlockingRemoteUserMapper() {
    }

    public String getRemoteUser(HttpServletRequest request) {
        BlockingRemoteUserMapper.doWithLock(this.lock.writeLock(), () -> {
            long t1 = System.currentTimeMillis();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                this.wasInterrupted = true;
            }
            finally {
                this.timePassed = (int)(System.currentTimeMillis() - t1);
            }
        });
        return null;
    }

    private static void doWithLock(Lock lock, Runnable action) {
        BlockingRemoteUserMapper.getWithLock(lock, () -> {
            action.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getWithLock(Lock lock, Supplier<T> supplier) {
        boolean locked;
        try {
            locked = lock.tryLock(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unexpected InterruptedException while acquiring " + String.valueOf(lock));
        }
        if (!locked) {
            throw new IllegalStateException("Unexpected failure while acquiring " + String.valueOf(lock));
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isWasInterrupted() {
        return BlockingRemoteUserMapper.getWithLock(this.lock.readLock(), () -> this.wasInterrupted);
    }

    public int getTimePassed() {
        return BlockingRemoteUserMapper.getWithLock(this.lock.readLock(), () -> this.timePassed);
    }

    public void reset() {
        BlockingRemoteUserMapper.doWithLock(this.lock.writeLock(), () -> {
            this.wasInterrupted = false;
            this.timePassed = 0;
        });
    }

    public boolean isActive() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

