/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bulkimport;

import java.util.Map;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.web.scripts.bulkimport.AbstractBulkFileSystemImportWebScript;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.extensions.webscripts.WebScriptException;

public class BulkImportParametersExtractorTest {
    private static final String TEST_NODE_REF = "workspace://SpacesStore/this-is-just-a-test-ref";
    private static final String TEST_MISSING_NODE_REF = "workspace://SpacesStore/this-is-just-a-not-existing-test-ref";
    private static final Integer DEFAULT_BATCH_SIZE = 1234;
    private static final Integer DEFAULT_NUMBER_OF_THREADS = 4321;

    @Test
    public void shouldExtractTargetRef() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF));
        BulkImportParameters params = extractor.extract();
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getTarget());
        Assert.assertEquals((Object)TEST_NODE_REF, (Object)params.getTarget().toString());
    }

    @Test
    public void shouldFallbackToDefaultValues() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF));
        BulkImportParameters params = extractor.extract();
        Assert.assertEquals((Object)DEFAULT_BATCH_SIZE, (Object)params.getBatchSize());
        Assert.assertEquals((Object)DEFAULT_NUMBER_OF_THREADS, (Object)params.getNumThreads());
        Assert.assertFalse((boolean)params.isDisableRulesService());
        Assert.assertEquals((Object)BulkImportParameters.ExistingFileMode.SKIP, (Object)params.getExistingFileMode());
        Assert.assertNull((Object)params.getLoggingInterval());
    }

    @Test
    public void shouldExtractDisableFolderRulesFlagWhenSetToTrue() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "disableRules", "true"));
        BulkImportParameters params = extractor.extract();
        Assert.assertTrue((boolean)params.isDisableRulesService());
    }

    @Test
    public void shouldExtractDisableFolderRulesFlagWhenSetToFalse() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "disableRules", "false"));
        BulkImportParameters params = extractor.extract();
        Assert.assertFalse((boolean)params.isDisableRulesService());
    }

    @Test
    public void shouldExtractDisableFolderRulesFlagWhenSetToNotBooleanValue() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "disableRules", "unknown"));
        BulkImportParameters params = extractor.extract();
        Assert.assertFalse((boolean)params.isDisableRulesService());
    }

    @Test
    public void shouldPropagateFileNotFoundExceptionWhenTargetIsNotFound() {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_MISSING_NODE_REF));
        Assert.assertThrows(FileNotFoundException.class, () -> ((AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor)extractor).extract());
    }

    @Test
    public void shouldExtractValidBatchSize() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "batchSize", "1"));
        BulkImportParameters params = extractor.extract();
        Assert.assertEquals((Object)1, (Object)params.getBatchSize());
    }

    @Test
    public void shouldFailWithWebScriptExceptionWhenInvalidBatchSizeIsRequested() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "batchSize", "not-a-number"));
        try {
            extractor.extract();
        }
        catch (WebScriptException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("batchSize"));
            return;
        }
        Assert.fail((String)"Expected exception to be thrown.");
    }

    @Test
    public void shouldFailWithWebScriptExceptionWhenNegativeBatchSizeIsRequested() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "batchSize", "-1"));
        try {
            extractor.extract();
        }
        catch (WebScriptException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("batchSize"));
            return;
        }
        Assert.fail((String)"Expected exception to be thrown.");
    }

    @Test
    public void shouldExtractValidNumberOfThreads() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "numThreads", "1"));
        BulkImportParameters params = extractor.extract();
        Assert.assertEquals((Object)1, (Object)params.getNumThreads());
    }

    @Test
    public void shouldFailWithWebScriptExceptionWhenInvalidNumberOfThreadsIsRequested() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "numThreads", "not-a-number"));
        try {
            extractor.extract();
        }
        catch (WebScriptException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("numThreads"));
            return;
        }
        Assert.fail((String)"Expected exception to be thrown.");
    }

    @Test
    public void shouldFailWithWebScriptExceptionWhenNegativeNumberOfThreadsIsRequested() throws FileNotFoundException {
        AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor extractor = this.givenExtractor(Map.of("targetNodeRef", TEST_NODE_REF, "numThreads", "-1"));
        try {
            extractor.extract();
        }
        catch (WebScriptException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("numThreads"));
            return;
        }
        Assert.fail((String)"Expected exception to be thrown.");
    }

    private AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor givenExtractor(Map<String, String> params) {
        return new AbstractBulkFileSystemImportWebScript.BulkImportParametersExtractor(params::get, this::testRefCreator, DEFAULT_BATCH_SIZE.intValue(), DEFAULT_NUMBER_OF_THREADS.intValue());
    }

    private NodeRef testRefCreator(String nodeRef, String path) throws FileNotFoundException {
        if (TEST_MISSING_NODE_REF.equals(nodeRef)) {
            throw new FileNotFoundException(new NodeRef(nodeRef));
        }
        return new NodeRef(nodeRef);
    }
}

