/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.TestFixture;
import org.alfresco.rest.api.tests.client.AuthenticatedHttp;
import org.alfresco.rest.api.tests.client.HttpClientProvider;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.UserAuthenticationDetailsProviderImpl;
import org.alfresco.rest.api.tests.client.UserData;
import org.alfresco.rest.api.tests.client.UserDataService;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.springframework.context.ApplicationContext;

public abstract class AbstractTestApi {
    private static final Log logger = LogFactory.getLog(AbstractTestApi.class);
    protected RepoService repoService;
    protected ApplicationContext applicationContext;
    protected PublicApiHttpClient httpClient;
    protected PublicApiClient publicApiClient;
    protected RetryingTransactionHelper transactionHelper;
    protected Collator collator = Collator.getInstance();

    public RepoService getRepoService() {
        return this.repoService;
    }

    @Before
    public void setupTests() throws Exception {
        TestFixture testFixture = this.getTestFixture(false);
        this.applicationContext = testFixture.getApplicationContext();
        this.repoService = testFixture.getRepoService();
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        HttpClientProvider httpClientProvider = (HttpClientProvider)this.applicationContext.getBean("httpClientProvider");
        UserDataService userDataService = new UserDataService(){

            @Override
            public UserData findUserByUserName(String userName) {
                UserData userData = new UserData();
                RepoService.TestPerson person = AbstractTestApi.this.getRepoService().getPerson(userName.toLowerCase());
                userData.setUserName(person.getId());
                userData.setPassword(person.getPassword());
                userData.setId(person.getId());
                return userData;
            }
        };
        UserAuthenticationDetailsProviderImpl authenticationDetailsProvider = new UserAuthenticationDetailsProviderImpl(userDataService, "admin", "admin");
        AuthenticatedHttp authenticatedHttp = new AuthenticatedHttp(httpClientProvider, authenticationDetailsProvider);
        this.httpClient = new PublicApiHttpClient("localhost", 8765, "/alfresco", "api", authenticatedHttp);
        this.publicApiClient = new PublicApiClient(this.httpClient, userDataService);
    }

    protected void log(String msg) {
        this.log(msg, null);
    }

    protected void log(String msg, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg, t);
        }
    }

    protected PublicApiClient.Paging getPaging(Integer skipCount, Integer maxItems) {
        return new PublicApiClient.Paging(skipCount, maxItems, null);
    }

    protected PublicApiClient.Paging getPaging(Integer skipCount, Integer maxItems, int total, Integer expectedTotal) {
        PublicApiClient.ExpectedPaging expectedPaging = PublicApiClient.ExpectedPaging.getExpectedPaging(skipCount, maxItems, total, expectedTotal);
        return new PublicApiClient.Paging(skipCount, maxItems, expectedPaging);
    }

    protected <T extends ExpectedComparison> void check(ExpectedComparison expected, T actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull(actual);
        expected.expected(actual);
    }

    protected String stripCMISSuffix(String nodeId) {
        String ret = null;
        int idx = nodeId.indexOf(";");
        ret = idx != -1 ? nodeId.substring(0, idx) : nodeId;
        return ret;
    }

    protected Map<String, String> createParams(PublicApiClient.Paging paging, Map<String, String> otherParams) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        if (paging != null) {
            if (paging.getSkipCount() != null) {
                params.put("skipCount", String.valueOf(paging.getSkipCount()));
            }
            if (paging.getMaxItems() != null) {
                params.put("maxItems", String.valueOf(paging.getMaxItems()));
            }
        }
        if (otherParams != null) {
            params.putAll(otherParams);
        }
        return params;
    }

    protected <T1 extends ExpectedComparison, T> void checkList(List<T1> expected, PublicApiClient.ExpectedPaging expectedPaging, PublicApiClient.ListResponse<T> actual) {
        Assert.assertNotNull((Object)expectedPaging);
        Assert.assertNotNull(actual);
        this.log("Expected paging " + expectedPaging.toString());
        for (ExpectedComparison expectedEntry : expected) {
            this.log("Expected entry " + expectedEntry.toString());
        }
        this.log("Actual paging " + actual.getPaging().toString());
        for (Object actualEntry : actual.getList()) {
            this.log("Actual entry " + actualEntry.toString());
        }
        Assert.assertEquals((Object)expectedPaging, (Object)actual.getPaging());
        Assert.assertEquals((long)expected.size(), (long)actual.getList().size());
        for (int i = 0; i < expected.size(); ++i) {
            ExpectedComparison expectedEntry;
            expectedEntry = (ExpectedComparison)expected.get(i);
            T actualEntry = actual.getList().get(i);
            Assert.assertNotNull(actualEntry);
            Assert.assertNotNull((Object)expectedEntry);
            expectedEntry.expected(actualEntry);
        }
    }

    protected <T> List<T> sublist(List<T> list, int skipCount, int maxItems) {
        List ret = null;
        int size2 = list.size();
        int start = skipCount;
        int end = Math.min(skipCount + maxItems, size2);
        ret = start > size2 ? Collections.emptyList() : list.subList(start, end);
        return ret;
    }

    protected abstract TestFixture getTestFixture() throws Exception;

    protected abstract TestFixture getTestFixture(boolean var1) throws Exception;
}

