/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.ActivitiesParameters;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Activities
implements Serializable {
    private static final long serialVersionUID = -6280142299994200394L;
    private String userId;
    private ActivitiesParameters activitiesParams;

    public Activities() {
    }

    public Activities(String userId, ActivitiesParameters activitiesParams) {
        if (userId == null) {
            throw new IllegalArgumentException();
        }
        this.userId = userId;
        this.activitiesParams = activitiesParams;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public ActivitiesParameters getActivitiesParams() {
        return this.activitiesParams;
    }

    public void setActivitiesParams(ActivitiesParameters activitiesParams) {
        this.activitiesParams = activitiesParams;
    }

    public String toString() {
        return "Activities [userId=" + this.userId + ", activitiesParams=" + String.valueOf(this.activitiesParams) + "]";
    }

    public static PublicApiClient.ListResponse<Activity> parseActivities(JSONObject jsonObject) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            activities.add(Activity.parseActivity(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<Activity>(paging, activities);
    }
}

