/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.action.AbstractActionWebscript;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.ISO8601DateFormat;

public class ReplicationModelBuilder {
    protected static final String MODEL_DATA_ITEM = "replicationDefinition";
    protected static final String MODEL_DATA_LIST = "replicationDefinitions";
    protected static final String DEFINITION_NAME = "name";
    protected static final String DEFINITION_DESCRIPTION = "description";
    protected static final String DEFINITION_STATUS = "status";
    protected static final String DEFINITION_STARTED_AT = "startedAt";
    protected static final String DEFINITION_ENDED_AT = "endedAt";
    protected static final String DEFINITION_FAILURE_MESSAGE = "failureMessage";
    protected static final String DEFINITION_RUNNING_ACTION_ID = "runningActionId";
    protected static final String DEFINITION_PAYLOAD = "payload";
    protected static final String DEFINITION_TRANSFER_LOCAL_REPORT = "transferLocalReport";
    protected static final String DEFINITION_TRANSFER_REMOTE_REPORT = "transferRemoteReport";
    protected static final String DEFINITION_ENABLED = "enabled";
    protected static final String DEFINITION_TARGET_NAME = "targetName";
    protected static final String DEFINITION_SCHEDULE_ENABLED = "scheduleEnabled";
    protected static final String DEFINITION_SCHEDULE_START = "scheduleStart";
    protected static final String DEFINITION_SCHEDULE_PERIOD = "scheduleIntervalPeriod";
    protected static final String DEFINITION_SCHEDULE_COUNT = "scheduleIntervalCount";
    protected NodeService nodeService;
    protected ReplicationService replicationService;
    protected ActionTrackingService actionTrackingService;

    public ReplicationModelBuilder(NodeService nodeService, ReplicationService replicationService, ActionTrackingService actionTrackingService) {
        this.nodeService = nodeService;
        this.replicationService = replicationService;
        this.actionTrackingService = actionTrackingService;
    }

    protected Map<String, Object> buildSimpleList(List<ReplicationDefinition> replicationDefinitions, Comparator<Map<String, Object>> sorter) {
        ArrayList<HashMap<String, Object>> models = new ArrayList<HashMap<String, Object>>();
        if (replicationDefinitions.size() > 0) {
            List executing = this.actionTrackingService.getExecutingActions(replicationDefinitions.get(0).getActionDefinitionName());
            for (ReplicationDefinition rd : replicationDefinitions) {
                ExecutionDetails details = this.getExecutionDetails(rd, executing);
                HashMap<String, Object> rdm = new HashMap<String, Object>();
                rdm.put(DEFINITION_NAME, rd.getReplicationName());
                rdm.put(DEFINITION_ENABLED, rd.isEnabled());
                this.setStatus(rd, details, rdm);
                rdm.remove(DEFINITION_ENDED_AT);
                rdm.remove(DEFINITION_RUNNING_ACTION_ID);
                models.add(rdm);
            }
        }
        if (sorter != null) {
            Collections.sort(models, sorter);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_DATA_LIST, models);
        return model;
    }

    protected Map<String, Object> buildDetails(ReplicationDefinition rd) {
        HashMap<String, Object> rdm = new HashMap<String, Object>();
        rdm.put(DEFINITION_NAME, rd.getReplicationName());
        rdm.put(DEFINITION_DESCRIPTION, rd.getDescription());
        rdm.put(DEFINITION_ENABLED, rd.isEnabled());
        rdm.put(DEFINITION_TARGET_NAME, rd.getTargetName());
        rdm.put(DEFINITION_SCHEDULE_ENABLED, rd.isSchedulingEnabled());
        if (rd.isSchedulingEnabled()) {
            rdm.put(DEFINITION_SCHEDULE_START, ISO8601DateFormat.format((Date)rd.getScheduleStart()));
            rdm.put(DEFINITION_SCHEDULE_COUNT, rd.getScheduleIntervalCount());
            if (rd.getScheduleIntervalPeriod() != null) {
                rdm.put(DEFINITION_SCHEDULE_PERIOD, rd.getScheduleIntervalPeriod().toString());
            } else {
                rdm.put(DEFINITION_SCHEDULE_PERIOD, null);
            }
        }
        rdm.put(DEFINITION_FAILURE_MESSAGE, rd.getExecutionFailureMessage());
        rdm.put(DEFINITION_TRANSFER_LOCAL_REPORT, rd.getLocalTransferReport());
        rdm.put(DEFINITION_TRANSFER_REMOTE_REPORT, rd.getRemoteTransferReport());
        this.setStatus(rd, rdm);
        ArrayList<NodeRef> payload = new ArrayList<NodeRef>();
        for (NodeRef node : rd.getPayload()) {
            if (!this.nodeService.exists(node)) continue;
            payload.add(node);
        }
        rdm.put(DEFINITION_PAYLOAD, payload);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_DATA_ITEM, rdm);
        return model;
    }

    protected void setStatus(ReplicationDefinition replicationDefinition, Map<String, Object> model) {
        List executing = this.actionTrackingService.getExecutingActions((Action)replicationDefinition);
        ExecutionDetails details = this.getExecutionDetails(replicationDefinition, executing);
        this.setStatus(replicationDefinition, details, model);
    }

    protected void setStatus(ReplicationDefinition replicationDefinition, ExecutionDetails details, Map<String, Object> model) {
        if (details == null) {
            model.put(DEFINITION_STATUS, replicationDefinition.getExecutionStatus().toString());
            Date startDate = replicationDefinition.getExecutionStartDate();
            if (startDate != null) {
                model.put(DEFINITION_STARTED_AT, ISO8601DateFormat.format((Date)startDate));
            } else {
                model.put(DEFINITION_STARTED_AT, null);
            }
            Date endDate = replicationDefinition.getExecutionEndDate();
            if (endDate != null) {
                model.put(DEFINITION_ENDED_AT, ISO8601DateFormat.format((Date)endDate));
            } else {
                model.put(DEFINITION_ENDED_AT, null);
            }
            model.put(DEFINITION_RUNNING_ACTION_ID, null);
            return;
        }
        if (details.isCancelRequested()) {
            model.put(DEFINITION_STATUS, "CancelRequested");
        } else if (details.getStartedAt() == null) {
            model.put(DEFINITION_STATUS, "Pending");
        } else {
            model.put(DEFINITION_STATUS, "Running");
        }
        if (details.getStartedAt() != null) {
            model.put(DEFINITION_STARTED_AT, ISO8601DateFormat.format((Date)details.getStartedAt()));
        } else {
            model.put(DEFINITION_STARTED_AT, null);
        }
        model.put(DEFINITION_ENDED_AT, null);
        model.put(DEFINITION_RUNNING_ACTION_ID, AbstractActionWebscript.getRunningId(details.getExecutionSummary()));
        if (model.containsKey(DEFINITION_FAILURE_MESSAGE)) {
            model.put(DEFINITION_FAILURE_MESSAGE, null);
        }
        if (model.containsKey(DEFINITION_TRANSFER_LOCAL_REPORT)) {
            model.put(DEFINITION_TRANSFER_LOCAL_REPORT, null);
        }
        if (model.containsKey(DEFINITION_TRANSFER_REMOTE_REPORT)) {
            model.put(DEFINITION_TRANSFER_REMOTE_REPORT, null);
        }
    }

    private ExecutionDetails getExecutionDetails(ReplicationDefinition replicationDefinition, List<ExecutionSummary> executing) {
        ExecutionSummary es;
        ArrayList<ExecutionSummary> ours = new ArrayList<ExecutionSummary>();
        for (ExecutionSummary es2 : executing) {
            if (!es2.getActionType().equals(replicationDefinition.getActionDefinitionName()) || !es2.getActionId().equals(replicationDefinition.getId())) continue;
            ours.add(es2);
        }
        if (ours.size() == 0) {
            return null;
        }
        if (executing.size() == 1) {
            es = (ExecutionSummary)ours.get(0);
        } else {
            es = (ExecutionSummary)ours.get(0);
            for (ExecutionSummary e : ours) {
                if (e.getExecutionInstance() >= es.getExecutionInstance()) continue;
                es = e;
            }
        }
        return this.actionTrackingService.getExecutionDetails(es);
    }

    public static class SimpleSorterByLastRun
    implements Comparator<Map<String, Object>> {
        @Override
        public int compare(Map<String, Object> simpleA, Map<String, Object> simpleB) {
            String dateA = (String)simpleA.get(ReplicationModelBuilder.DEFINITION_STARTED_AT);
            String dateB = (String)simpleB.get(ReplicationModelBuilder.DEFINITION_STARTED_AT);
            if (dateA == null && dateB == null) {
                return 0;
            }
            if (dateA != null && dateB == null) {
                return -1;
            }
            if (dateA == null && dateB != null) {
                return 1;
            }
            return 0 - dateA.compareTo(dateB);
        }
    }

    public static class SimpleSorterByName
    implements Comparator<Map<String, Object>> {
        @Override
        public int compare(Map<String, Object> simpleA, Map<String, Object> simpleB) {
            String nameA = (String)simpleA.get(ReplicationModelBuilder.DEFINITION_NAME);
            String nameB = (String)simpleB.get(ReplicationModelBuilder.DEFINITION_NAME);
            if (nameA == null || nameB == null) {
                throw new IllegalArgumentException("Name missing during sort");
            }
            return nameA.compareTo(nameB);
        }
    }

    public static class SimpleSorterByStatus
    implements Comparator<Map<String, Object>> {
        private SimpleSorterByName nameSorter = new SimpleSorterByName();

        @Override
        public int compare(Map<String, Object> simpleA, Map<String, Object> simpleB) {
            String statusA = (String)simpleA.get(ReplicationModelBuilder.DEFINITION_STATUS);
            String statusB = (String)simpleB.get(ReplicationModelBuilder.DEFINITION_STATUS);
            if (statusA == null || statusB == null) {
                throw new IllegalArgumentException("Status missing during sort");
            }
            int compare = statusA.compareTo(statusB);
            if (compare == 0) {
                return this.nameSorter.compare(simpleA, simpleB);
            }
            return compare;
        }
    }
}

