/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.auth.AuthenticationListener;
import org.alfresco.repo.web.auth.TenantAuthentication;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.repo.web.scripts.TenantWebScriptServletRequest;
import org.alfresco.repo.web.scripts.servlet.RemoteUserAuthenticatorFactory;
import org.alfresco.rest.api.PublicApiCredentials;
import org.alfresco.rest.api.TenantCredentials;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class PublicApiAuthenticatorFactory
extends RemoteUserAuthenticatorFactory {
    private static Log logger = LogFactory.getLog(PublicApiAuthenticatorFactory.class);
    public static final String DEFAULT_AUTHENTICATOR_KEY_HEADER = "X-Alfresco-Authenticator-Key";
    private String authenticatorKeyHeader = "X-Alfresco-Authenticator-Key";
    private RetryingTransactionHelper retryingTransactionHelper;
    private TenantAuthentication tenantAuthentication;
    private Set<String> validAuthenticatorKeys = Collections.emptySet();
    private Set<String> outboundHeaderNames;
    private boolean useBasicAuth = true;

    public void setAuthenticatorKeyHeader(String authenticatorKeyHeader) {
        this.authenticatorKeyHeader = authenticatorKeyHeader;
    }

    public void setOutboundHeaders(Set<String> outboundHeaders) {
        if (outboundHeaders != null) {
            HashSet<String> trimmed = new HashSet<String>();
            for (String value : outboundHeaders) {
                trimmed.add(value.toLowerCase(Locale.ENGLISH).trim());
            }
            outboundHeaders = trimmed;
        }
        this.outboundHeaderNames = outboundHeaders;
    }

    public void setUseBasicAuth(boolean useBasicAuth) {
        this.useBasicAuth = useBasicAuth;
    }

    public void setTenantAuthentication(TenantAuthentication service) {
        this.tenantAuthentication = service;
    }

    public void setTransactionHelper(RetryingTransactionHelper service) {
        this.retryingTransactionHelper = service;
    }

    public void setValidAuthentictorKeys(Set<String> validKeys) {
        if (validKeys != null) {
            HashSet<String> trimmedKeys = new HashSet<String>();
            for (String key : validKeys) {
                trimmedKeys.add(key.trim());
            }
            validKeys = trimmedKeys;
        }
        this.validAuthenticatorKeys = validKeys;
    }

    @Override
    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new PublicApiAuthenticator(req, res, new ProxyListener());
    }

    private Map<String, String[]> getOutboundHeaders(TenantWebScriptServletRequest req) {
        HashMap<String, String[]> outboundHeaders = new HashMap<String, String[]>();
        for (String headerName : this.outboundHeaderNames) {
            String[] headerValues = req.getHeaderValues(headerName);
            if (headerValues == null || headerValues.length <= 0) continue;
            outboundHeaders.put(headerName, headerValues);
        }
        return outboundHeaders;
    }

    public class PublicApiAuthenticator
    extends RemoteUserAuthenticatorFactory.RemoteUserAuthenticator {
        private TenantWebScriptServletRequest servletReq;
        private ProxyListener proxyListener;

        public PublicApiAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res, ProxyListener proxyListener) {
            super(req, res, (AuthenticationListener)proxyListener);
            if (!(req instanceof TenantWebScriptServletRequest)) {
                throw new WebScriptException("Request is not a tenant aware request");
            }
            this.servletReq = (TenantWebScriptServletRequest)req;
            this.proxyListener = proxyListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean bl;
            block15: {
                boolean authorized = false;
                try {
                    block13: {
                        String authenticatorKey = this.servletReq.getHeader(PublicApiAuthenticatorFactory.this.authenticatorKeyHeader);
                        String remoteUser = this.getRemoteUser();
                        if (authenticatorKey != null && remoteUser != null) {
                            authorized = this.authenticateViaGateway(required, isGuest, authenticatorKey, remoteUser);
                        } else {
                            try {
                                authorized = super.authenticate(required, isGuest);
                            }
                            catch (AuthenticationException ae) {
                                if (!logger.isDebugEnabled()) break block13;
                                logger.debug((Object)("TenantBasicHttpAuthenticator: required=" + String.valueOf(required) + ", isGuest=" + isGuest + " - " + ae.getMessage()));
                            }
                        }
                    }
                    if (authorized) {
                        final String tenant = this.servletReq.getTenant();
                        final String email = AuthenticationUtil.getFullyAuthenticatedUser();
                        try {
                            authorized = (Boolean)PublicApiAuthenticatorFactory.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                                public Boolean execute() throws Exception {
                                    return PublicApiAuthenticatorFactory.this.tenantAuthentication.authenticateTenant(email, tenant);
                                }
                            }, true, false);
                        }
                        finally {
                            if (!authorized) {
                                this.listener.authenticationFailed(new TenantCredentials(tenant, email, this.proxyListener.getOrignalCredentials()));
                                AuthenticationUtil.clearCurrentSecurityContext();
                            } else {
                                this.listener.userAuthenticated(new TenantCredentials(tenant, email, this.proxyListener.getOrignalCredentials()));
                            }
                        }
                    }
                    bl = authorized;
                    if (authorized) break block15;
                }
                catch (Throwable throwable) {
                    if (!authorized) {
                        this.servletRes.setStatus(401);
                        String scheme = PublicApiAuthenticatorFactory.this.useBasicAuth ? "Basic" : "AlfTicket";
                        String challenge = scheme + " realm=\"Alfresco " + this.servletReq.getTenant() + " tenant\"";
                        this.servletRes.setHeader("WWW-Authenticate", challenge);
                    }
                    throw throwable;
                }
                this.servletRes.setStatus(401);
                String scheme = PublicApiAuthenticatorFactory.this.useBasicAuth ? "Basic" : "AlfTicket";
                String challenge = scheme + " realm=\"Alfresco " + this.servletReq.getTenant() + " tenant\"";
                this.servletRes.setHeader("WWW-Authenticate", challenge);
            }
            return bl;
        }

        private boolean authenticateViaGateway(Description.RequiredAuthentication required, boolean isGuest, String authenticatorKey, String remoteUser) {
            if (PublicApiAuthenticatorFactory.this.validAuthenticatorKeys.contains(authenticatorKey)) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)remoteUser);
                this.proxyListener.userAuthenticated(new PublicApiCredentials(authenticatorKey, remoteUser, PublicApiAuthenticatorFactory.this.getOutboundHeaders(this.servletReq)));
                return true;
            }
            logger.error((Object)("Invalid authenticator key:- " + authenticatorKey));
            this.proxyListener.authenticationFailed(new PublicApiCredentials(authenticatorKey, remoteUser, PublicApiAuthenticatorFactory.this.getOutboundHeaders(this.servletReq)));
            return false;
        }
    }

    private class ProxyListener
    implements AuthenticationListener {
        private WebCredentials originalCredentials;

        private ProxyListener() {
        }

        @Override
        public void userAuthenticated(WebCredentials credentials) {
            this.originalCredentials = credentials;
        }

        @Override
        public void authenticationFailed(WebCredentials credentials) {
            PublicApiAuthenticatorFactory.this.listener.authenticationFailed(credentials);
        }

        @Override
        public void authenticationFailed(WebCredentials credentials, Exception ex) {
            PublicApiAuthenticatorFactory.this.listener.authenticationFailed(credentials, ex);
        }

        public WebCredentials getOrignalCredentials() {
            return this.originalCredentials;
        }
    }
}

