/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.categories;

import java.util.List;
import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.ListPage;
import org.alfresco.rest.framework.resource.parameters.Parameters;

@RelationshipResource(name="category-links", entityResource=NodesEntityResource.class, title="Category links")
public class NodesCategoryLinksRelation
implements RelationshipResourceAction.Create<Category>,
RelationshipResourceAction.Read<Category>,
RelationshipResourceAction.Delete {
    private final Categories categories;

    public NodesCategoryLinksRelation(Categories categories) {
        this.categories = categories;
    }

    @Override
    @WebApiDescription(title="Get categories linked to by node", description="Get categories linked to by node", successStatus=200)
    public CollectionWithPagingInfo<Category> readAll(String nodeId, Parameters parameters) {
        return ListPage.of(this.categories.listCategoriesForNode(nodeId, parameters), parameters.getPaging());
    }

    @Override
    @WebApiDescription(title="Link node to categories", description="Creates a link between a node and categories", successStatus=201)
    public List<Category> create(String nodeId, List<Category> categoryLinks, Parameters parameters) {
        return this.categories.linkNodeToCategories(nodeId, categoryLinks, parameters);
    }

    @Override
    @WebApiDescription(title="Unlink content node from category", description="Removes the link between a content node and a category", successStatus=204)
    public void delete(String nodeId, String categoryId, Parameters parameters) {
        this.categories.unlinkNodeFromCategory(nodeId, categoryId, parameters);
    }
}

