/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.query.PageDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.util.Pair;

public class Util {
    public static PagingRequest getPagingRequest(Paging paging) {
        PagingRequest pagingRequest = new PagingRequest(paging.getSkipCount(), paging.getMaxItems());
        pagingRequest.setRequestTotalCountMax(Integer.MAX_VALUE);
        return pagingRequest;
    }

    public static <T> PagingResults<T> wrapPagingResults(Paging paging, Collection<T> result) {
        if (paging == null) {
            throw new InvalidArgumentException("paging object can't be null.");
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        final int totalSize = result.size();
        final PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
        final ArrayList<T> page = new ArrayList<T>(pageDetails.getPageSize());
        Iterator<T> it = result.iterator();
        int end = pageDetails.getEnd();
        for (int counter = 0; counter < end && it.hasNext(); ++counter) {
            T element = it.next();
            if (counter < pageDetails.getSkipCount()) continue;
            if (counter > end - 1) break;
            page.add(element);
        }
        return new PagingResults<T>(){

            public List<T> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return pageDetails.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                Integer total = totalSize;
                return new Pair((Object)total, (Object)total);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }
}

