/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.Objects;

public class Category {
    private String id;
    private String name;
    private String parentId;
    private boolean hasChildren;
    private Integer count;
    private String path;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCategoryId(String categoryId) {
        this.id = categoryId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        return this.hasChildren == category.hasChildren && Objects.equals(this.id, category.id) && Objects.equals(this.name, category.name) && Objects.equals(this.parentId, category.parentId) && Objects.equals(this.count, category.count) && Objects.equals(this.path, category.path);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.parentId, this.hasChildren, this.count, this.path);
    }

    public String toString() {
        return "Category{id='" + this.id + "', name='" + this.name + "', parentId='" + this.parentId + "', hasChildren=" + this.hasChildren + ", count=" + this.count + ", path=" + this.path + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String name;
        private String parentId;
        private boolean hasChildren;
        private Integer count;
        private String path;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder hasChildren(boolean hasChildren) {
            this.hasChildren = hasChildren;
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Category create() {
            Category category = new Category();
            category.setId(this.id);
            category.setName(this.name);
            category.setParentId(this.parentId);
            category.setHasChildren(this.hasChildren);
            category.setCount(this.count);
            category.setPath(this.path);
            return category;
        }
    }
}

