/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.rest.api.model.ModulePackage;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.license.LicenseDescriptor;
import org.apache.commons.lang3.StringUtils;

public class RepositoryInfo {
    private String id;
    private String edition;
    private VersionInfo version;
    private LicenseInfo license;
    private StatusInfo status;
    private List<ModulePackage> modules;

    public String getId() {
        return this.id;
    }

    public RepositoryInfo setId(String id) {
        this.id = id;
        return this;
    }

    public String getEdition() {
        return this.edition;
    }

    public RepositoryInfo setEdition(String edition) {
        this.edition = edition;
        return this;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public RepositoryInfo setVersion(VersionInfo version) {
        this.version = version;
        return this;
    }

    public LicenseInfo getLicense() {
        return this.license;
    }

    public RepositoryInfo setLicense(LicenseInfo license) {
        this.license = license;
        return this;
    }

    public StatusInfo getStatus() {
        return this.status;
    }

    public RepositoryInfo setStatus(StatusInfo status) {
        this.status = status;
        return this;
    }

    public List<ModulePackage> getModules() {
        return this.modules;
    }

    public RepositoryInfo setModules(List<ModulePackage> modules) {
        this.modules = modules;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(450);
        sb.append("RepositoryInfo [edition=").append(this.edition).append(", version=").append(this.version).append(", license=").append(this.license).append(", status=").append(this.status).append(", modules=").append(this.modules).append(']');
        return sb.toString();
    }

    public static class VersionInfo {
        private static final Pattern HOTFIX_PATTERN = Pattern.compile("^[0-9]+$");
        private String major;
        private String minor;
        private String patch;
        private String hotfix;
        private int schema;
        private String label;
        private String display;

        public VersionInfo() {
        }

        public VersionInfo(Descriptor descriptor) {
            this.major = descriptor.getVersionMajor();
            this.minor = descriptor.getVersionMinor();
            this.patch = descriptor.getVersionRevision();
            this.hotfix = this.getHotfix(descriptor.getVersionLabel());
            this.schema = descriptor.getSchema();
            this.label = descriptor.getVersionBuild();
            this.display = this.getVersionDisplay();
        }

        public String getMajor() {
            return this.major;
        }

        public String getMinor() {
            return this.minor;
        }

        public String getPatch() {
            return this.patch;
        }

        public String getHotfix() {
            return this.hotfix;
        }

        public int getSchema() {
            return this.schema;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDisplay() {
            return this.display;
        }

        private String getHotfix(String versionLabel) {
            if (StringUtils.isNotEmpty((CharSequence)versionLabel)) {
                Matcher matcher;
                if (versionLabel.startsWith(".")) {
                    versionLabel = versionLabel.substring(1);
                }
                if ((matcher = HOTFIX_PATTERN.matcher(versionLabel)).find()) {
                    return versionLabel;
                }
            }
            return Integer.toString(0);
        }

        private String getVersionDisplay() {
            StringBuilder version = new StringBuilder(this.major);
            version.append('.').append(this.minor).append('.').append(this.patch).append('.').append(this.getHotfix());
            if (StringUtils.isNotEmpty((CharSequence)this.label)) {
                version.append(" (").append(this.label).append(") ");
            }
            version.append("schema ").append(this.schema);
            return version.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("VersionInfo [major=").append(this.major).append(", minor=").append(this.minor).append(", patch=").append(this.patch).append(", hotfix=").append(this.hotfix).append(", schema=").append(this.schema).append(", label=").append(this.label).append(", display=").append(this.display).append(']');
            return sb.toString();
        }
    }

    public static class LicenseInfo {
        private Date issuedAt;
        private Date expiresAt;
        private Integer remainingDays;
        private String holder;
        private String mode;
        private LicenseEntitlement entitlements;

        public LicenseInfo() {
        }

        public LicenseInfo(LicenseDescriptor licenseDescriptor) {
            this.issuedAt = licenseDescriptor.getIssued();
            this.expiresAt = licenseDescriptor.getValidUntil();
            this.remainingDays = licenseDescriptor.getRemainingDays();
            this.holder = licenseDescriptor.getHolderOrganisation();
            this.mode = licenseDescriptor.getLicenseMode().name();
            this.entitlements = new LicenseEntitlement().setMaxDocs(licenseDescriptor.getMaxDocs()).setMaxUsers(licenseDescriptor.getMaxUsers()).setClusterEnabled(licenseDescriptor.isClusterEnabled()).setCryptodocEnabled(licenseDescriptor.isCryptodocEnabled()).setCustomEmbeddedWorkflowEnabled(licenseDescriptor.isCustomEmbeddedWorkflowEnabled());
        }

        public Date getIssuedAt() {
            return this.issuedAt;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public Integer getRemainingDays() {
            return this.remainingDays;
        }

        public String getHolder() {
            return this.holder;
        }

        public String getMode() {
            return this.mode;
        }

        public LicenseEntitlement getEntitlements() {
            return this.entitlements;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("LicenseInfo [issuedAt=").append(this.issuedAt).append(", expiresAt=").append(this.expiresAt).append(", remainingDays=").append(this.remainingDays).append(", holder=").append(this.holder).append(", mode=").append(this.mode).append(", entitlements=").append(this.entitlements).append(']');
            return sb.toString();
        }
    }

    public static class StatusInfo {
        private boolean isReadOnly;
        private boolean isAuditEnabled;
        private boolean isQuickShareEnabled;
        private boolean isThumbnailGenerationEnabled;
        private boolean isDirectAccessUrlEnabled;

        public boolean getIsReadOnly() {
            return this.isReadOnly;
        }

        public StatusInfo setReadOnly(boolean readOnly) {
            this.isReadOnly = readOnly;
            return this;
        }

        public boolean getIsAuditEnabled() {
            return this.isAuditEnabled;
        }

        public StatusInfo setAuditEnabled(boolean auditEnabled) {
            this.isAuditEnabled = auditEnabled;
            return this;
        }

        public boolean getIsQuickShareEnabled() {
            return this.isQuickShareEnabled;
        }

        public StatusInfo setQuickShareEnabled(boolean quickShareEnabled) {
            this.isQuickShareEnabled = quickShareEnabled;
            return this;
        }

        public boolean getIsThumbnailGenerationEnabled() {
            return this.isThumbnailGenerationEnabled;
        }

        public StatusInfo setThumbnailGenerationEnabled(boolean isThumbnailGenerationEnabled) {
            this.isThumbnailGenerationEnabled = isThumbnailGenerationEnabled;
            return this;
        }

        public boolean getIsDirectAccessUrlEnabled() {
            return this.isDirectAccessUrlEnabled;
        }

        public StatusInfo setDirectAccessUrlEnabled(boolean isDirectAccessUrlEnabled) {
            this.isDirectAccessUrlEnabled = isDirectAccessUrlEnabled;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("StatusInfo [isReadOnly=").append(this.isReadOnly).append(", isAuditEnabled=").append(this.isAuditEnabled).append(", isQuickShareEnabled=").append(this.isQuickShareEnabled).append(", isThumbnailGenerationEnabled=").append(this.isThumbnailGenerationEnabled).append(", isDirectAccessUrlEnabled=").append(this.isDirectAccessUrlEnabled).append(']');
            return sb.toString();
        }
    }

    public static class LicenseEntitlement {
        private Long maxUsers;
        private Long maxDocs;
        private boolean isClusterEnabled;
        private boolean isCryptodocEnabled;
        private boolean isCustomEmbeddedWorkflowEnabled;

        public Long getMaxUsers() {
            return this.maxUsers;
        }

        public LicenseEntitlement setMaxUsers(Long maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        public Long getMaxDocs() {
            return this.maxDocs;
        }

        public LicenseEntitlement setMaxDocs(Long maxDocs) {
            this.maxDocs = maxDocs;
            return this;
        }

        public boolean getIsClusterEnabled() {
            return this.isClusterEnabled;
        }

        public LicenseEntitlement setClusterEnabled(boolean clusterEnabled) {
            this.isClusterEnabled = clusterEnabled;
            return this;
        }

        public boolean getIsCryptodocEnabled() {
            return this.isCryptodocEnabled;
        }

        public LicenseEntitlement setCryptodocEnabled(boolean cryptodocEnabled) {
            this.isCryptodocEnabled = cryptodocEnabled;
            return this;
        }

        public boolean getIsCustomEmbeddedWorkflowEnabled() {
            return this.isCustomEmbeddedWorkflowEnabled;
        }

        public LicenseEntitlement setCustomEmbeddedWorkflowEnabled(boolean customEmbeddedWorkflowEnabled) {
            this.isCustomEmbeddedWorkflowEnabled = customEmbeddedWorkflowEnabled;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("LicenseEntitlement [maxUsers=").append(this.maxUsers).append(", maxDocs=").append(this.maxDocs).append(", isClusterEnabled=").append(this.isClusterEnabled).append(", isCryptodocEnabled=").append(this.isCryptodocEnabled).append(", isCustomEmbeddedWorkflowEnabled=").append(this.isCustomEmbeddedWorkflowEnabled).append(']');
            return sb.toString();
        }
    }
}

