/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.rest.api.actions.ActionValidator;
import org.alfresco.rest.api.impl.mapper.rules.RestRuleActionModelMapper;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RestRuleActionModelMapperTest {
    private static final String ACTION_DEFINITION_NAME = "actionDefName";
    private static final Map<String, Serializable> parameters = Map.of("property", "propertyName", "value", "propertyValue", "actionContext", "rule");
    @Mock
    private ActionParameterConverter parameterConverter;
    @Mock
    private ActionValidator sampleValidatorMock;
    private RestRuleActionModelMapper objectUnderTest;

    @Before
    public void setUp() {
        this.objectUnderTest = new RestRuleActionModelMapper(this.parameterConverter, List.of(this.sampleValidatorMock));
    }

    @Test
    public void testToRestModel() {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "ruleId");
        ActionImpl actionServiceModel = new ActionImpl(nodeRef, "actionId", ACTION_DEFINITION_NAME, parameters);
        BDDMockito.given((Object)this.parameterConverter.convertParamFromServiceModel((Serializable)ArgumentMatchers.any())).willAnswer(a -> a.getArgument(0));
        Action actualAction = this.objectUnderTest.toRestModel((org.alfresco.service.cmr.action.Action)actionServiceModel);
        ((ActionParameterConverter)BDDMockito.then((Object)this.parameterConverter).should(Mockito.times((int)3))).convertParamFromServiceModel((Serializable)ArgumentMatchers.any());
        BDDMockito.then((Object)this.parameterConverter).shouldHaveNoMoreInteractions();
        Map<String, String> expectedParameters = Map.of("property", "propertyName", "value", "propertyValue");
        Action expectedAction = Action.builder().actionDefinitionId(ACTION_DEFINITION_NAME).params(expectedParameters).create();
        ((ObjectAssert)Assertions.assertThat((Object)actualAction).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedAction);
    }

    @Test
    public void testToRestModelWithNullValues() {
        ActionImpl actionServiceModel = new ActionImpl(null, null, null);
        Action expectedAction = Action.builder().params(Collections.emptyMap()).create();
        Action actualAction = this.objectUnderTest.toRestModel((org.alfresco.service.cmr.action.Action)actionServiceModel);
        BDDMockito.then((Object)this.parameterConverter).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)actualAction).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedAction);
    }

    @Test
    public void testToServiceModel() {
        Action action = Action.builder().actionDefinitionId(ACTION_DEFINITION_NAME).params(parameters).create();
        List<Action> actions = List.of(action);
        BDDMockito.given((Object)this.parameterConverter.getConvertedParams(parameters, ACTION_DEFINITION_NAME)).willAnswer(a -> a.getArgument(0));
        org.alfresco.service.cmr.action.Action serviceModelAction = this.objectUnderTest.toServiceModel(actions);
        ((ActionParameterConverter)BDDMockito.then((Object)this.parameterConverter).should()).getConvertedParams(parameters, ACTION_DEFINITION_NAME);
        BDDMockito.then((Object)this.parameterConverter).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)serviceModelAction).isNotNull();
    }

    @Test
    public void testToServiceModelFromEmptyActions() {
        List actions = Collections.emptyList();
        org.alfresco.service.cmr.action.Action serviceModelAction = this.objectUnderTest.toServiceModel(actions);
        BDDMockito.then((Object)this.parameterConverter).shouldHaveNoInteractions();
        Assertions.assertThat((Object)serviceModelAction).isNull();
    }

    @Test
    public void testToServiceModelWithNullParams() {
        Action action = Action.builder().actionDefinitionId(ACTION_DEFINITION_NAME).params(null).create();
        List<Action> actions = List.of(action);
        org.alfresco.service.cmr.action.Action serviceModelAction = this.objectUnderTest.toServiceModel(actions);
        ((ActionParameterConverter)BDDMockito.then((Object)this.parameterConverter).should()).getConvertedParams(Collections.emptyMap(), ACTION_DEFINITION_NAME);
        BDDMockito.then((Object)this.parameterConverter).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)serviceModelAction).isNotNull();
    }
}

