/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class ReportCommandProcessor
implements CommandProcessor {
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";
    private TransferReceiver receiver;
    private static final Log logger = LogFactory.getLog(ReportCommandProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int process(WebScriptRequest req, WebScriptResponse resp) {
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        HttpServletRequest servletRequest = webScriptServletRequest.getHttpServletRequest();
        String transferId = servletRequest.getParameter("transferId");
        if (transferId == null) {
            logger.debug((Object)"transferId is missing");
            resp.setStatus(400);
            return 400;
        }
        try {
            OutputStream out = resp.getOutputStream();
            try {
                resp.setContentType("text/xml");
                resp.setContentEncoding("utf-8");
                try (BufferedInputStream br = new BufferedInputStream(this.receiver.getProgressMonitor().getLogInputStream(transferId));){
                    byte[] buffer = new byte[1000];
                    int i = br.read(buffer);
                    while (i > 0) {
                        out.write(buffer, 0, i);
                        i = br.read(buffer);
                    }
                }
            }
            finally {
                out.flush();
                out.close();
            }
            return 200;
        }
        catch (TransferException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }
}

