/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WorkflowInstanceGet
extends AbstractWorkflowWebscript {
    public static final String PARAM_INCLUDE_TASKS = "includeTasks";

    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        String workflowInstanceId = (String)params.get("workflow_instance_id");
        boolean includeTasks = this.getIncludeTasks(req);
        WorkflowInstance workflowInstance = this.workflowService.getWorkflowById(workflowInstanceId);
        if (workflowInstance == null) {
            throw new WebScriptException(404, "Unable to find workflow instance with id: " + workflowInstanceId);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("workflowInstance", modelBuilder.buildDetailed(workflowInstance, includeTasks));
        return model;
    }

    private boolean getIncludeTasks(WebScriptRequest req) {
        String includeTasks = req.getParameter(PARAM_INCLUDE_TASKS);
        if (includeTasks != null) {
            try {
                return Boolean.valueOf(includeTasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

