/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import com.google.common.collect.AbstractIterator;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.CMISNodeInfoImpl;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.query.PageDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.cleanup.FeedCleaner;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.content.cleanup.ContentStoreCleaner;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteDoesNotExistException;
import org.alfresco.repo.tenant.Network;
import org.alfresco.repo.tenant.NetworksService;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.invitation.InvitationWebScriptTest;
import org.alfresco.rest.api.Activities;
import org.alfresco.rest.api.impl.node.ratings.RatingScheme;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.PublicApiTestContext;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.Company;
import org.alfresco.rest.api.tests.client.data.FavouriteDocument;
import org.alfresco.rest.api.tests.client.data.FavouriteFolder;
import org.alfresco.rest.api.tests.client.data.FavouriteSite;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.api.tests.client.data.NetworkImpl;
import org.alfresco.rest.api.tests.client.data.NodeRating;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.rest.api.tests.client.data.PersonNetwork;
import org.alfresco.rest.api.tests.client.data.SiteContainer;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteMember;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;

public class RepoService {
    private static final Log logger = LogFactory.getLog(RepoService.class);
    protected static final String TEST_SITE_PRESET = "testSitePreset";
    private static final String FAVOURITE_SITES_PREFIX = "org.alfresco.share.sites.favourites.";
    private static final int FAVOURITE_SITES_PREFIX_LENGTH = "org.alfresco.share.sites.favourites.".length();
    protected ApplicationContext applicationContext;
    protected MutableAuthenticationService authenticationService;
    protected DictionaryService dictionaryService;
    protected SiteService siteService;
    protected ActivityService activityService;
    protected PostLookup postLookup;
    protected FeedGenerator feedGenerator;
    protected FileFolderService fileFolderService;
    protected ContentService contentService;
    protected CommentService commentService;
    protected NodeService nodeService;
    protected PreferenceService preferenceService;
    protected TaggingService taggingService;
    protected RatingService ratingService;
    protected TenantService tenantService;
    protected TenantAdminService tenantAdminService;
    protected ActivityPostDAO postDAO;
    protected JobDetail feedGeneratorJobDetail;
    protected JobDetail postLookupJobDetail;
    protected JobDetail feedCleanerJobDetail;
    protected JobDetail postCleanerJobDetail;
    protected JobDetail feedNotifierJobDetail;
    protected ContentStoreCleaner contentStoreCleaner;
    protected FeedCleaner feedCleaner;
    protected PersonService personService;
    protected NamedObjectRegistry<RatingScheme> nodeRatingSchemeRegistry;
    protected VersionService versionService;
    protected CheckOutCheckInService cociService;
    protected FavouritesService favouritesService;
    protected InvitationService invitationService;
    protected LockService lockService;
    protected CMISConnector cmisConnector;
    protected HiddenAspect hiddenAspect;
    protected NetworksService networksService;
    protected NamespaceService namespaceService;
    protected RetryingTransactionHelper transactionHelper;
    protected Activities activities;
    protected PublicApiTestContext publicApiContext;
    protected Random random = new Random(System.currentTimeMillis());
    protected static int numNetworks = 0;
    protected TestNetwork systemNetwork;
    protected Map<String, TestPerson> allPeople = new HashMap<String, TestPerson>();
    public static final String DEFAULT_ADMIN = "admin";
    public static final String DEFAULT_ADMIN_PWD = "admin";

    public RepoService() {
    }

    public RepoService(ApplicationContext applicationContext) throws Exception {
        this.applicationContext = applicationContext;
        this.publicApiContext = new PublicApiTestContext(applicationContext);
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("AuthenticationService");
        this.siteService = (SiteService)applicationContext.getBean("SiteService");
        this.activityService = (ActivityService)applicationContext.getBean("activityService");
        this.fileFolderService = (FileFolderService)applicationContext.getBean("FileFolderService");
        this.contentService = (ContentService)applicationContext.getBean("ContentService");
        this.commentService = (CommentService)applicationContext.getBean("CommentService");
        this.nodeService = (NodeService)applicationContext.getBean("NodeService");
        this.preferenceService = (PreferenceService)applicationContext.getBean("PreferenceService");
        this.taggingService = (TaggingService)applicationContext.getBean("TaggingService");
        this.ratingService = (RatingService)applicationContext.getBean("RatingService");
        this.tenantService = (TenantService)applicationContext.getBean("tenantService");
        this.tenantAdminService = (TenantAdminService)applicationContext.getBean("tenantAdminService");
        this.personService = (PersonService)applicationContext.getBean("PersonService");
        this.contentStoreCleaner = (ContentStoreCleaner)applicationContext.getBean("contentStoreCleaner");
        this.postDAO = (ActivityPostDAO)applicationContext.getBean("postDAO");
        this.nodeRatingSchemeRegistry = (NamedObjectRegistry)applicationContext.getBean("nodeRatingSchemeRegistry");
        this.cociService = (CheckOutCheckInService)applicationContext.getBean("CheckoutCheckinService");
        this.favouritesService = (FavouritesService)applicationContext.getBean("FavouritesService");
        this.dictionaryService = (DictionaryService)applicationContext.getBean("dictionaryService");
        this.invitationService = (InvitationService)applicationContext.getBean("InvitationService");
        this.lockService = (LockService)applicationContext.getBean("LockService");
        this.cmisConnector = (CMISConnector)applicationContext.getBean("CMISConnector");
        this.activities = (Activities)applicationContext.getBean("activities");
        this.hiddenAspect = (HiddenAspect)applicationContext.getBean("hiddenAspect");
        this.networksService = (NetworksService)applicationContext.getBean("networksService");
        this.namespaceService = (NamespaceService)applicationContext.getBean("namespaceService");
        this.transactionHelper = (RetryingTransactionHelper)applicationContext.getBean("retryingTransactionHelper");
        Scheduler scheduler = (Scheduler)applicationContext.getBean("schedulerFactory");
        CronTrigger contentStoreCleanerTrigger = (CronTrigger)applicationContext.getBean("contentStoreCleanerTrigger");
        scheduler.pauseJob(contentStoreCleanerTrigger.getJobKey());
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)applicationContext.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        this.feedGeneratorJobDetail = (JobDetail)activitiesFeedCtx.getBean("feedGeneratorJobDetail");
        this.postLookupJobDetail = (JobDetail)activitiesFeedCtx.getBean("postLookupJobDetail");
        this.feedCleanerJobDetail = (JobDetail)activitiesFeedCtx.getBean("feedCleanerJobDetail");
        this.postCleanerJobDetail = (JobDetail)activitiesFeedCtx.getBean("postCleanerJobDetail");
        this.feedNotifierJobDetail = (JobDetail)activitiesFeedCtx.getBean("feedNotifierJobDetail");
        this.feedCleaner = (FeedCleaner)activitiesFeedCtx.getBean("feedCleaner");
        scheduler.pauseJob(this.feedGeneratorJobDetail.getKey());
        scheduler.pauseJob(this.postLookupJobDetail.getKey());
        scheduler.pauseJob(this.feedCleanerJobDetail.getKey());
        scheduler.pauseJob(this.postCleanerJobDetail.getKey());
        scheduler.pauseJob(this.feedNotifierJobDetail.getKey());
        this.systemNetwork = new TestNetwork("", true);
    }

    public TestNetwork getSystemNetwork() {
        return this.systemNetwork;
    }

    public PublicApiTestContext getPublicApiContext() {
        return this.publicApiContext;
    }

    public void addPerson(TestPerson person) {
        this.allPeople.put(person.getId().toLowerCase(), person);
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public TestPerson getPerson(String username) {
        return this.allPeople.get(username.toLowerCase());
    }

    public int getClientVisibilityMask(FileFilterMode.Client client, HiddenAspect.Visibility visibility) {
        return this.hiddenAspect.getClientVisibilityMask(client, visibility);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) {
        return this.nodeService.createAssociation(sourceRef, targetRef, assocTypeQName);
    }

    public String toPrefixString(QName qname) {
        return qname.toPrefixString((NamespacePrefixResolver)this.namespaceService);
    }

    public Invitation approveSiteInvitation(String personId, String siteId) {
        Invitation ret = null;
        List invitations = this.invitationService.listPendingInvitationsForInvitee(personId);
        for (Invitation invitation : invitations) {
            if (!invitation.getResourceName().equals(siteId)) continue;
            ret = this.invitationService.approve(invitation.getInviteId(), "I accept you");
        }
        return ret;
    }

    public void moveNode(NodeRef nodeToMoveRef, NodeRef newParentNodeRef) throws FileExistsException, FileNotFoundException {
        this.fileFolderService.move(nodeToMoveRef, newParentNodeRef, GUID.generate());
    }

    public void deleteNode(NodeRef nodeRef) {
        this.nodeService.deleteNode(nodeRef);
    }

    public void lockNode(NodeRef nodeRef) {
        this.lockNode(nodeRef, LockType.NODE_LOCK, 0, false);
    }

    public void lockNode(NodeRef nodeRef, LockType lockType, int timeToExpire, boolean includeChildren) {
        this.lockService.lock(nodeRef, lockType, timeToExpire, includeChildren);
    }

    public void unlockNode(NodeRef nodeRef) {
        this.unlockNode(nodeRef, false);
    }

    public void unlockNode(NodeRef nodeRef, boolean includeChildren) {
        this.lockService.unlock(nodeRef, true, false);
    }

    public NodeRef addUserDescription(final String personId, final TestNetwork network, final String personDescription) {
        return (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef userRef = RepoService.this.personService.getPersonOrNull(personId);
                if (userRef == null) {
                    throw new AuthenticationException("User name does not exist: " + personId);
                }
                ContentWriter writer = RepoService.this.contentService.getWriter(userRef, ContentModel.PROP_PERSONDESC, true);
                writer.setMimetype("text/html");
                writer.putContent(personDescription);
                RepoService.this.log("Updated person description " + personId + (String)(network != null ? " in network " + String.valueOf(network) : ""));
                return userRef;
            }
        });
    }

    public TestPerson createUser(PersonInfo personInfo, String username, TestNetwork network) {
        return this.getOrCreateUser(personInfo, username, network, true);
    }

    public TestPerson getOrCreateUser(PersonInfo personInfo, String username, TestNetwork network) {
        return this.getOrCreateUser(personInfo, username, network, false);
    }

    private boolean isDefaultAdmin(String username, TestNetwork network) {
        if (network == null || "".equals(network.getId())) {
            return "admin".equalsIgnoreCase(username);
        }
        return ("admin@" + network.getId()).equalsIgnoreCase(username);
    }

    public TestPerson getOrCreateUser(final PersonInfo personInfo, final String username, final TestNetwork network, final boolean deletePerson) {
        return (TestPerson)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<TestPerson>(){

            public TestPerson doWork() throws Exception {
                final TestPerson testPerson = new TestPerson(personInfo.getFirstName(), personInfo.getLastName(), username, personInfo.getPassword(), personInfo.getCompany(), network, personInfo.getSkype(), personInfo.getLocation(), personInfo.getTel(), personInfo.getMob(), personInfo.getInstantmsg(), personInfo.getGoogle());
                Map props = testPerson.toProperties();
                if (!RepoService.this.isDefaultAdmin(username, network)) {
                    NodeRef personNodeRef = RepoService.this.personService.getPersonOrNull(username);
                    if (personNodeRef != null && deletePerson) {
                        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                            public Void doWork() throws Exception {
                                RepoService.this.personService.deletePerson(testPerson.getId());
                                return null;
                            }
                        });
                    }
                    if (personNodeRef == null) {
                        personNodeRef = RepoService.this.personService.createPerson(props);
                        RepoService.this.authenticationService.createAuthentication(username, personInfo.getPassword().toCharArray());
                        if ("withAvatar".equals(personInfo.getInstantmsg())) {
                            InvitationWebScriptTest.makeAvatar(RepoService.this.nodeService, personNodeRef);
                            RepoService.this.log("Made avatar for " + testPerson.getId() + (String)(network != null ? " in network " + String.valueOf(network) : ""));
                        }
                    }
                }
                RepoService.this.log("Username " + testPerson.getId() + (String)(network != null ? " in network " + String.valueOf(network) : ""));
                RepoService.this.publicApiContext.addUser(testPerson.getId());
                RepoService.this.addPerson(testPerson);
                return testPerson;
            }
        });
    }

    protected void deleteUser(final String username, TestNetwork network) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<TestPerson>(){

            public TestPerson doWork() throws Exception {
                if (RepoService.this.personService.personExists(username)) {
                    RepoService.this.authenticationService.deleteAuthentication(username);
                    RepoService.this.personService.deletePerson(username);
                }
                return null;
            }
        });
    }

    public TestSite createSite(TestNetwork network, SiteInformation siteInfoIn) {
        SiteInfo siteInfoOut = this.siteService.createSite(siteInfoIn.getSitePreset() != null ? siteInfoIn.getSitePreset() : TEST_SITE_PRESET, siteInfoIn.getShortName(), siteInfoIn.getTitle(), siteInfoIn.getDescription(), siteInfoIn.getSiteVisibility());
        this.siteService.createContainer(siteInfoIn.getShortName(), "documentLibrary", ContentModel.TYPE_FOLDER, null);
        TestSite testSite = new TestSite(network, siteInfoOut);
        this.log("Created site " + String.valueOf(testSite) + (String)(network != null ? " in network " + String.valueOf(network) : ""));
        return testSite;
    }

    public Invitation rejectSiteInvitation(String personId, String siteId) {
        Invitation ret = null;
        List invitations = this.invitationService.listPendingInvitationsForInvitee(personId);
        for (Invitation invitation : invitations) {
            if (!invitation.getResourceName().equals(siteId)) continue;
            ret = this.invitationService.reject(invitation.getInviteId(), "I reject you");
        }
        return ret;
    }

    public List<Invitation> getModeratedSiteInvitations(String networkId, String runAsUserId, final String inviteeId, final String siteId) {
        List invitations = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Invitation>>(){

            public List<Invitation> doWork() throws Exception {
                InvitationSearchCriteriaImpl searchCriteria = new InvitationSearchCriteriaImpl();
                searchCriteria.setInvitee(inviteeId);
                if (siteId != null) {
                    searchCriteria.setResourceName(siteId);
                }
                searchCriteria.setResourceType(Invitation.ResourceType.WEB_SITE);
                searchCriteria.setInvitationType(InvitationSearchCriteria.InvitationType.MODERATED);
                List invitations = RepoService.this.invitationService.searchInvitation((InvitationSearchCriteria)searchCriteria);
                return invitations;
            }
        }, (String)runAsUserId, (String)networkId);
        return invitations;
    }

    public Version getCurrentVersion(NodeRef nodeRef) {
        return this.versionService.getCurrentVersion(nodeRef);
    }

    protected void log(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg);
        }
    }

    public SiteInfo getSiteInfo(String siteId) {
        return this.siteService.getSite(siteId);
    }

    public boolean isCheckedOut(NodeRef nodeRef) {
        return this.cociService.isCheckedOut(nodeRef);
    }

    public Serializable getProperty(NodeRef nodeRef, QName propertyName) {
        Serializable value = this.nodeService.getProperty(nodeRef, propertyName);
        return value;
    }

    public Set<QName> getAspects(NodeRef nodeRef) {
        Set aspects = this.nodeService.getAspects(nodeRef);
        return aspects;
    }

    public ContentReader getContent(NodeRef nodeRef, QName propertyQName) {
        ContentReader reader = this.contentService.getReader(nodeRef, propertyQName);
        return reader;
    }

    private void cleanupContent() {
        this.log("Cleaning up feeds...");
        this.feedCleaner.setMaxAgeMins(1);
        this.feedCleaner.setMaxFeedSize(1);
        try {
            this.feedCleaner.execute();
        }
        catch (JobExecutionException jobExecutionException) {
            // empty catch block
        }
        this.log("...done");
        this.log("Cleaning up content...");
        this.contentStoreCleaner.setProtectDays(0);
        this.contentStoreCleaner.execute();
        this.log("...done");
    }

    public void shutdown() {
        this.cleanupContent();
        this.publicApiContext.cleanup();
    }

    public Version createVersion(NodeRef nodeRef, String history, boolean majorVersion) {
        HashMap<String, String> props = new HashMap<String, String>(2, 1.0f);
        props.put("description", history);
        props.put("versionType", (String)(majorVersion ? VersionType.MAJOR : VersionType.MINOR));
        return this.versionService.createVersion(nodeRef, props);
    }

    public VersionHistory getVersionHistory(NodeRef nodeRef) {
        return this.versionService.getVersionHistory(nodeRef);
    }

    public Pair<String, String> splitSiteNetwork(String siteNetwork) {
        int idx = siteNetwork.indexOf("@");
        String siteId = siteNetwork;
        String networkId = null;
        if (idx > -1) {
            siteId = siteNetwork.substring(0, idx - 1);
            networkId = siteNetwork.substring(idx + 1);
        }
        return new Pair((Object)siteId, networkId);
    }

    private Map<String, Object> parseActivitySummary(ActivityFeedEntity entity) {
        String activityType = entity.getActivityType();
        String activitySummary = entity.getActivitySummary();
        JSONObject json = (JSONObject)JSONValue.parse((String)activitySummary);
        return Activity.getActivitySummary(json, activityType);
    }

    public List<Activity> getActivities(String personId, String siteId, boolean excludeUser, boolean excludeOthers) {
        List feedEntities = this.activityService.getUserFeedEntries(personId, siteId, excludeUser, excludeOthers, 0L);
        ArrayList<Activity> activities = new ArrayList<Activity>(feedEntities.size());
        for (ActivityFeedEntity entity : feedEntities) {
            String siteNetwork = entity.getSiteNetwork();
            Pair<String, String> pair = this.splitSiteNetwork(siteNetwork);
            siteId = (String)pair.getFirst();
            String networkId = (String)pair.getSecond();
            String postDateStr = PublicApiDateFormat.getDateFormat().format(entity.getPostDate());
            Activity activity = new Activity(entity.getId(), networkId, siteId, entity.getFeedUserId(), entity.getPostUserId(), postDateStr, entity.getActivityType(), this.parseActivitySummary(entity));
            activities.add(activity);
        }
        return activities;
    }

    public Rating getRating(NodeRef targetNode, String scheme) {
        return this.ratingService.getRatingByCurrentUser(targetNode, scheme);
    }

    public List<Rating> getRatings(NodeRef targetNode) {
        return this.ratingService.getRatingsByCurrentUser(targetNode);
    }

    public RatingScheme getApiRatingScheme(String ratingSchemeName) {
        return (RatingScheme)this.nodeRatingSchemeRegistry.getNamedObject(ratingSchemeName);
    }

    public Map<String, Object> getActivitySummary(ActivityFeedEntity entity) throws JSONException {
        Map activitySummary = this.activities.getActivitySummary(entity);
        JSONObject json = new JSONObject();
        for (String key : activitySummary.keySet()) {
            Object value = activitySummary.get(key);
            if (value instanceof NodeRef) {
                value = ((NodeRef)value).getId();
            }
            json.put((Object)key, value);
        }
        return json;
    }

    public void checkSiteMember(TestPerson person, TestSite site, SiteRole siteRole) throws Exception {
        Assert.assertTrue((boolean)this.siteService.isMember(site.getSiteId(), person.getId()));
        Assert.assertEquals((Object)siteRole.toString(), (Object)this.siteService.getMembersRole(site.getSiteId(), person.getId()));
    }

    public void addFavouriteSite(String username, String siteShortName) {
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        if (siteInfo == null) {
            throw new SiteDoesNotExistException(siteShortName);
        }
        this.favouritesService.addFavourite(username, siteInfo.getNodeRef());
    }

    private PagingResults<SiteInfo> getFavouriteSites(String userName, PagingRequest pagingRequest) {
        final Collator collator = Collator.getInstance();
        final TreeSet<SiteInfo> sortedFavouriteSites = new TreeSet<SiteInfo>(new Comparator<SiteInfo>(){

            @Override
            public int compare(SiteInfo o1, SiteInfo o2) {
                return collator.compare(o1.getTitle(), o2.getTitle());
            }
        });
        Map prefs = this.preferenceService.getPreferences(userName, FAVOURITE_SITES_PREFIX);
        for (String key : prefs.keySet()) {
            String siteShortName;
            SiteInfo siteInfo;
            boolean isFavourite = false;
            Serializable s = (Serializable)prefs.get(key);
            if (s instanceof Boolean) {
                isFavourite = (Boolean)s;
            }
            if (!isFavourite || (siteInfo = this.siteService.getSite(siteShortName = key.substring(FAVOURITE_SITES_PREFIX_LENGTH))) == null) continue;
            sortedFavouriteSites.add(siteInfo);
        }
        int totalSize = sortedFavouriteSites.size();
        final PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
        final ArrayList<SiteInfo> page = new ArrayList<SiteInfo>(pageDetails.getPageSize());
        Iterator it = sortedFavouriteSites.iterator();
        for (int counter = 0; counter < pageDetails.getEnd() && it.hasNext(); ++counter) {
            SiteInfo favouriteSite = (SiteInfo)it.next();
            if (counter < pageDetails.getSkipCount()) continue;
            if (counter > pageDetails.getEnd() - 1) break;
            page.add(favouriteSite);
        }
        return new PagingResults<SiteInfo>(){

            public List<SiteInfo> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return pageDetails.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                Integer total = sortedFavouriteSites.size();
                return new Pair((Object)total, (Object)total);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    public List<FavouriteSite> getFavouriteSites(TestPerson user) {
        ArrayList<FavouriteSite> favouriteSites = new ArrayList<FavouriteSite>();
        PagingResults<SiteInfo> pagingResults = this.getFavouriteSites(user.getId(), new PagingRequest(0, Integer.MAX_VALUE));
        for (SiteInfo siteInfo : pagingResults.getPage()) {
            String siteId = siteInfo.getShortName();
            String siteGuid = siteInfo.getNodeRef().getId();
            TestSite site = user.getDefaultAccount().getSite(siteId);
            FavouriteSite favouriteSite = null;
            favouriteSite = site.isMember(user.getId()) ? new FavouriteSite(site) : new FavouriteSite(null, siteId, siteGuid, null, null, null, null, null);
            favouriteSites.add(favouriteSite);
        }
        return favouriteSites;
    }

    public void addPreference(String username, String Key, Serializable value) {
        HashMap<String, Serializable> preferences = new HashMap<String, Serializable>(1);
        preferences.put(Key, value);
        this.preferenceService.setPreferences(username, preferences);
    }

    public List<MemberOfSite> getSiteMemberships(String personId) {
        List sites = this.siteService.listSites(personId);
        ArrayList<MemberOfSite> memberships = new ArrayList<MemberOfSite>();
        for (SiteInfo siteInfo : sites) {
            String roleStr = this.siteService.getMembersRole(siteInfo.getShortName(), personId);
            SiteRole role = SiteRole.valueOf(roleStr);
            SiteImpl site = new SiteImpl(siteInfo, role, true);
            memberships.add(new MemberOfSite(site, role));
        }
        return memberships;
    }

    public void generateFeed() throws JobExecutionException, SQLException {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RepoService.this.postLookup.execute();
                return null;
            }
        }, false, true);
        Long maxSequence = this.getMaxActivitySeq();
        while (maxSequence != null) {
            this.feedGenerator.execute();
            maxSequence = this.getMaxActivitySeq();
        }
    }

    private Long getMaxActivitySeq() throws SQLException {
        Long maxSequence = (Long)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return RepoService.this.postDAO.getMaxActivitySeq();
            }
        }, true, true);
        return maxSequence;
    }

    public Tag addTag(NodeRef nodeRef, String tag) {
        NodeRef tagNodeRef = this.taggingService.addTag(nodeRef, tag);
        return new Tag(nodeRef.getId(), tagNodeRef.getId(), tag);
    }

    public List<Tag> getTags() {
        TreeSet<Tag> tags = new TreeSet<Tag>();
        for (String tag : this.taggingService.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)) {
            tags.add(new Tag(null, this.taggingService.getTagNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, tag).getId(), tag));
        }
        return new ArrayList<Tag>(tags);
    }

    public List<Tag> getTags(NodeRef nodeRef) {
        TreeSet<Tag> tags = new TreeSet<Tag>();
        for (String tag : this.taggingService.getTags(nodeRef)) {
            tags.add(new Tag(null, this.taggingService.getTagNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, tag).getId(), tag));
        }
        return new ArrayList<Tag>(tags);
    }

    private Properties getProperties(NodeRef nodeRef) {
        CMISNodeInfoImpl nodeInfo = this.cmisConnector.createNodeInfo(nodeRef);
        final Properties properties = this.cmisConnector.getNodeProperties((CMISNodeInfo)nodeInfo, null);
        String title = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE));
        final PropertyStringImpl titleProp = new PropertyStringImpl(ContentModel.PROP_TITLE.toString(), title);
        Properties wrapProperties = new Properties(){

            public List<CmisExtensionElement> getExtensions() {
                return properties.getExtensions();
            }

            public void setExtensions(List<CmisExtensionElement> extensions) {
                properties.setExtensions(extensions);
            }

            public Map<String, PropertyData<?>> getProperties() {
                HashMap updatedProperties = new HashMap(properties.getProperties());
                updatedProperties.put(titleProp.getId(), (PropertyData<?>)titleProp);
                return updatedProperties;
            }

            public List<PropertyData<?>> getPropertyList() {
                ArrayList propertyList = new ArrayList(properties.getPropertyList());
                propertyList.add((PropertyData<?>)titleProp);
                return propertyList;
            }
        };
        return wrapProperties;
    }

    public FavouriteDocument getDocument(String networkId, final NodeRef nodeRef) {
        return (FavouriteDocument)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<FavouriteDocument>(){

            public FavouriteDocument doWork() throws Exception {
                FavouriteDocument document = null;
                QName type = RepoService.this.nodeService.getType(nodeRef);
                if (!RepoService.this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
                    throw new IllegalArgumentException("Not a document node");
                }
                Properties properties = RepoService.this.getProperties(nodeRef);
                document = FavouriteDocument.getDocument(nodeRef.getId(), nodeRef.getId(), properties);
                return document;
            }
        }, (String)networkId);
    }

    public FavouriteFolder getFolder(String networkId, final NodeRef nodeRef) {
        return (FavouriteFolder)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<FavouriteFolder>(){

            public FavouriteFolder doWork() throws Exception {
                FavouriteFolder folder = null;
                QName type = RepoService.this.nodeService.getType(nodeRef);
                if (!RepoService.this.dictionaryService.isSubClass(type, ContentModel.TYPE_FOLDER)) {
                    throw new IllegalArgumentException("Not a folder node");
                }
                Properties properties = RepoService.this.getProperties(nodeRef);
                folder = FavouriteFolder.getFolder(nodeRef.getId(), nodeRef.getId(), properties);
                return folder;
            }
        }, (String)networkId);
    }

    public List<NodeRating> getNodeRatings(String personId, String networkId, final NodeRef nodeRef) {
        List ratings = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<NodeRating>>(){

            public List<NodeRating> doWork() throws Exception {
                ArrayList<NodeRating> ratings = new ArrayList<NodeRating>();
                Rating likesRating = RepoService.this.ratingService.getRatingByCurrentUser(nodeRef, "likesRatingScheme");
                Comparable<Boolean> myRating = null;
                String ratedAt = null;
                if (likesRating != null) {
                    myRating = likesRating.getScore() == 1.0f ? Boolean.TRUE : Boolean.FALSE;
                    Date rateTime = likesRating.getAppliedAt();
                    ratedAt = PublicApiDateFormat.getDateFormat().format(rateTime);
                }
                int ratingsCount = RepoService.this.ratingService.getRatingsCount(nodeRef, "likesRatingScheme");
                NodeRating.Aggregate aggregate = new NodeRating.Aggregate(ratingsCount, null);
                ratings.add(new NodeRating(nodeRef.getId(), "likes", ratedAt, myRating, aggregate));
                Rating fiveStarRating = RepoService.this.ratingService.getRatingByCurrentUser(nodeRef, "fiveStarRatingScheme");
                myRating = null;
                ratedAt = null;
                if (fiveStarRating != null) {
                    myRating = Float.valueOf(fiveStarRating.getScore());
                    Date rateTime = fiveStarRating.getAppliedAt();
                    ratedAt = PublicApiDateFormat.getDateFormat().format(rateTime);
                }
                ratingsCount = RepoService.this.ratingService.getRatingsCount(nodeRef, "fiveStarRatingScheme");
                float averageRating = RepoService.this.ratingService.getAverageRating(nodeRef, "fiveStarRatingScheme");
                NodeRating.Aggregate aggregate2 = new NodeRating.Aggregate(ratingsCount, averageRating == -1.0f ? null : Float.valueOf(averageRating));
                ratings.add(new NodeRating(nodeRef.getId(), "fiveStar", ratedAt, myRating, aggregate2));
                return ratings;
            }
        }, (String)personId, (String)networkId);
        Collections.sort(ratings);
        return ratings;
    }

    public int numRatingSchemes() {
        return this.ratingService.getRatingSchemes().size();
    }

    public NodeRef addToDocumentLibrary(TestSite site, String name, QName type) {
        NodeRef documentLibraryContainerNodeRef = this.siteService.getContainer(site.getSiteId(), "documentLibrary");
        NodeRef nodeRef = this.fileFolderService.create(documentLibraryContainerNodeRef, name, type).getNodeRef();
        return nodeRef;
    }

    public String getSiteNetwork(final String siteShortName, String tenantDomain) {
        return (String)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

            public String doWork() throws Exception {
                return RepoService.this.tenantService.getName(siteShortName);
            }
        }, (String)tenantDomain);
    }

    public void postActivity(String activityType, String siteId, JSONObject activityData) throws JobExecutionException {
        this.activityService.postActivity(activityType, siteId, "documentlibrary", activityData.toString());
    }

    public NodeRef createDocument(NodeRef parentNodeRef, String name, String content) {
        NodeRef nodeRef = this.fileFolderService.create(parentNodeRef, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.putContent(content);
        return nodeRef;
    }

    public NodeRef createDocument(NodeRef parentNodeRef, String name, String title, String description, String content) {
        NodeRef nodeRef = this.fileFolderService.create(parentNodeRef, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.putContent(content);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description));
        return nodeRef;
    }

    public NodeRef createFolder(NodeRef parentNodeRef, String name) {
        NodeRef nodeRef = this.fileFolderService.create(parentNodeRef, name, ContentModel.TYPE_FOLDER).getNodeRef();
        return nodeRef;
    }

    public NodeRef createFolder(NodeRef parentNodeRef, String name, String title, String description) {
        NodeRef nodeRef = this.fileFolderService.create(parentNodeRef, name, ContentModel.TYPE_FOLDER).getNodeRef();
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description));
        return nodeRef;
    }

    public NodeRef createCmObject(NodeRef parentNodeRef, String name) {
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        NodeRef nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CMOBJECT).getChildRef();
        return nodeRef;
    }

    public NodeRef createObjectOfCustomType(NodeRef parentNodeRef, String name, String typeName) {
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        QName typeQName = QName.createQName((String)typeName);
        NodeRef nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, typeQName).getChildRef();
        return nodeRef;
    }

    public HiddenAspect.Visibility getVisibility(FileFilterMode.Client client, NodeRef nodeRef) {
        return this.hiddenAspect.getVisibility(client, nodeRef);
    }

    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) {
        this.nodeService.addAspect(nodeRef, aspectTypeQName, aspectProperties);
    }

    public NodeRef createComment(NodeRef nodeRef, Comment comment) {
        NodeRef commentNodeRef = this.commentService.createComment(nodeRef, comment.getTitle(), comment.getContent(), false);
        comment.setId(commentNodeRef.getId());
        Date created = (Date)this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_CREATED);
        comment.setCreatedAt(PublicApiDateFormat.getDateFormat().format(created));
        TestPerson person = this.getPerson((String)((Object)this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_CREATOR)));
        comment.setCreatedBy(person);
        return commentNodeRef;
    }

    public TestNetwork createNetworkWithAlias(String alias, boolean enabled) {
        String networkId = alias + "-" + System.currentTimeMillis();
        TestNetwork network = new TestNetwork(networkId, enabled);
        return network;
    }

    public TestNetwork createNetwork(String networkId, boolean enabled) {
        TestNetwork network = new TestNetwork(networkId, enabled);
        return network;
    }

    public static <T> Iterator<T> getWrappingIterator(final int startIdx, final List<T> list) {
        return new AbstractIterator<T>(){
            private int idx;
            {
                this.idx = Math.max(0, Math.min(startIdx, list.size() - 1));
            }

            protected T computeNext() {
                Object o = list.get(this.idx);
                ++this.idx;
                if (this.idx >= list.size()) {
                    this.idx = 0;
                }
                return o;
            }
        };
    }

    public class TestNetwork
    extends NetworkImpl
    implements Comparable<TestNetwork> {
        private static final long serialVersionUID = -107881141652228471L;
        protected Map<String, TestPerson> people;
        protected TreeMap<String, TestSite> sites;
        protected Set<TestSite> publicSites;

        public TestNetwork(String domain, boolean enabled) {
            super(domain, enabled);
            this.people = new TreeMap<String, TestPerson>();
            this.sites = new TreeMap();
            this.publicSites = new TreeSet<TestSite>();
        }

        public void create() {
            if (!this.getId().equals("") && !RepoService.this.tenantAdminService.existsTenant(this.getId())) {
                RepoService.this.tenantAdminService.createTenant(this.getId(), "admin".toCharArray());
                ++numNetworks;
                RepoService.this.log("Created network " + this.getId());
            }
        }

        public TestSite createSite(String siteRootName, SiteVisibility siteVisibility) {
            String shortName = "TESTSITE" + (siteRootName != null ? siteRootName : "") + GUID.generate();
            SiteInformation siteInfo = new SiteInformation(shortName, shortName, shortName, siteVisibility);
            return this.createSite(siteInfo);
        }

        public TestSite createSite(String id, String title, String description, String sitePreset, SiteVisibility visibility) {
            SiteInformation siteInfo = new SiteInformation(id, title, description, sitePreset, visibility);
            return this.createSite(siteInfo);
        }

        public TestSite createSite(SiteVisibility siteVisibility) {
            return this.createSite(null, siteVisibility);
        }

        public TestSite createSite(SiteInformation site) {
            TestSite testSite = RepoService.this.createSite(this, site);
            this.addSite(testSite);
            return testSite;
        }

        public TestPerson createUser() {
            long timeMillis = System.currentTimeMillis();
            String firstname = "first" + timeMillis;
            String lastname = "last" + timeMillis;
            String username = "user" + timeMillis;
            PersonInfo personInfo = new PersonInfo(firstname, lastname, username, "password", null, "skype", "location", "telephone", "mob", "instant", "google");
            TestPerson person = this.createUser(personInfo);
            return person;
        }

        public NodeRef addUserDescription(final String personId, final String personDescription) {
            NodeRef personRef = (NodeRef)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return RepoService.this.addUserDescription(personId, TestNetwork.this, personDescription);
                }
            }, (String)this.getId());
            return personRef;
        }

        public TestPerson createUser(final PersonInfo personInfo) {
            final String username = RepoService.this.publicApiContext.createUserName(personInfo.getUsername(), this.getId());
            TestPerson testPerson = (TestPerson)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<TestPerson>(){

                public TestPerson doWork() throws Exception {
                    TestPerson person = RepoService.this.createUser(personInfo, username, TestNetwork.this);
                    return person;
                }
            }, (String)this.getId());
            this.addPerson(testPerson);
            return testPerson;
        }

        public List<String> peopleSample(int sampleSize) {
            ArrayList<String> p = new ArrayList<String>();
            if (sampleSize < 0) {
                p.addAll(this.people.keySet());
            } else {
                int startIdx = RepoService.this.random.nextInt(this.people.size());
                ArrayList<String> peopleList = new ArrayList<String>(this.people.keySet());
                Iterator<String> it = RepoService.getWrappingIterator(startIdx, peopleList);
                for (int i = 0; i < sampleSize && it.hasNext(); ++i) {
                    p.add(it.next());
                }
            }
            return p;
        }

        public TestSite getSiteNonMember(final String personId) {
            return (TestSite)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<TestSite>(){

                public TestSite doWork() throws Exception {
                    TestSite ret = null;
                    SiteInfo match = null;
                    for (SiteInfo info : RepoService.this.siteService.listSites(null, null)) {
                        boolean isMember = RepoService.this.siteService.isMember(info.getShortName(), personId);
                        if (isMember) continue;
                        match = info;
                        break;
                    }
                    if (match != null) {
                        ret = new TestSite(TestNetwork.this, match);
                    }
                    return ret;
                }
            }, (String)this.getId());
        }

        public void addSite(TestSite site) {
            this.sites.put(site.getSiteId(), site);
            if (site.getVisibility().equals(SiteVisibility.PUBLIC.toString())) {
                this.publicSites.add(site);
            }
        }

        public Set<TestSite> getPublicSites() {
            return this.publicSites;
        }

        public TestSite getSite(final String siteShortName) {
            TestSite site = (TestSite)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<TestSite>(){

                public TestSite doWork() throws Exception {
                    SiteInfo siteInfo = RepoService.this.siteService.getSite(siteShortName);
                    return new TestSite(TestNetwork.this, siteInfo);
                }
            }, (String)this.getId());
            return site;
        }

        public List<TestSite> getSites(String personId) {
            List sites = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<TestSite>>(){

                public List<TestSite> doWork() throws Exception {
                    List results = RepoService.this.siteService.listSites(null, null);
                    TreeMap<String, TestSite> ret = new TreeMap<String, TestSite>();
                    for (SiteInfo siteInfo : results) {
                        TestSite site = new TestSite(TestNetwork.this, siteInfo);
                        ret.put(site.getSiteId(), site);
                    }
                    return new ArrayList<TestSite>(ret.values());
                }
            }, (String)personId, (String)this.getId());
            return sites;
        }

        public List<TestSite> getAllSites() {
            List sites = (List)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<TestSite>>(){

                public List<TestSite> doWork() throws Exception {
                    List results = RepoService.this.siteService.listSites(null, null);
                    TreeMap<String, TestSite> ret = new TreeMap<String, TestSite>();
                    for (SiteInfo siteInfo : results) {
                        TestSite site = new TestSite(TestNetwork.this, siteInfo);
                        ret.put(site.getSiteId(), site);
                    }
                    return new ArrayList<TestSite>(ret.values());
                }
            }, (String)this.getId());
            return sites;
        }

        public List<SiteContainer> getSiteContainers(final String siteId, TestPerson runAs) {
            List siteContainers = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<SiteContainer>>(){

                public List<SiteContainer> doWork() throws Exception {
                    PagingResults results = RepoService.this.siteService.listContainers(siteId, new PagingRequest(0, Integer.MAX_VALUE));
                    ArrayList<SiteContainer> ret = new ArrayList<SiteContainer>(results.getPage().size());
                    for (FileInfo fileInfo : results.getPage()) {
                        SiteContainer siteContainer = new SiteContainer(siteId, fileInfo.getName(), fileInfo.getNodeRef().getId());
                        ret.add(siteContainer);
                    }
                    return ret;
                }
            }, (String)runAs.getId(), (String)this.getId());
            return siteContainers;
        }

        public Map<String, TestSite> getSitesForUser(String username) {
            if (username == null) {
                username = AuthenticationUtil.getAdminUserName();
            }
            List sites = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<SiteInfo>>(){

                public List<SiteInfo> doWork() throws Exception {
                    List results = RepoService.this.siteService.listSites(null, null);
                    return results;
                }
            }, (String)username, (String)this.getId());
            TreeMap<String, TestSite> ret = new TreeMap<String, TestSite>();
            for (SiteInfo siteInfo : sites) {
                TestSite site = new TestSite(this, siteInfo);
                ret.put(site.getSiteId(), site);
            }
            return ret;
        }

        public List<MemberOfSite> getSiteMemberships(String username) {
            if (username == null) {
                username = AuthenticationUtil.getAdminUserName();
            }
            final String userId = username;
            List sites = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<MemberOfSite>>(){

                public List<MemberOfSite> doWork() throws Exception {
                    List sites = RepoService.this.siteService.listSites(userId);
                    TreeSet<MemberOfSite> personSites = new TreeSet<MemberOfSite>();
                    for (SiteInfo siteInfo : sites) {
                        TestSite site = TestNetwork.this.getSite(siteInfo.getShortName());
                        String role = RepoService.this.siteService.getMembersRole(siteInfo.getShortName(), userId);
                        MemberOfSite ms = new MemberOfSite(site, SiteRole.valueOf(role));
                        personSites.add(ms);
                    }
                    return new ArrayList<MemberOfSite>(personSites);
                }
            }, (String)userId, (String)this.getId());
            return sites;
        }

        public Map<String, TestSite> getSites(SiteVisibility siteVisibility) {
            HashMap<String, TestSite> ret = new HashMap<String, TestSite>();
            for (String key : this.getSitesForUser(null).keySet()) {
                TestSite site = this.getSitesForUser(null).get(key);
                if (!site.getVisibility().equals(siteVisibility.toString())) continue;
                ret.put(key, site);
            }
            return ret;
        }

        public void addPerson(TestPerson person) {
            this.people.put(person.getId(), person);
        }

        public List<String> getPersonIds() {
            return new ArrayList<String>(this.people.keySet());
        }

        public List<TestPerson> getPeople() {
            return new ArrayList<TestPerson>(this.people.values());
        }

        @Override
        public int compareTo(TestNetwork o) {
            return this.getId().compareTo(o.getId());
        }

        public void addExternalUser(String personId) {
            throw new UnsupportedOperationException();
        }

        public TestSite homeSite(TestPerson person) {
            throw new UnsupportedOperationException();
        }

        public void inviteUser(String user) {
            throw new UnsupportedOperationException();
        }

        public Collection<TestSite> getHomeSites() {
            throw new UnsupportedOperationException();
        }

        public Long getAccountId() {
            throw new UnsupportedOperationException();
        }

        public void setAccountId(Long accountId) {
            throw new UnsupportedOperationException();
        }

        public int getType() {
            throw new UnsupportedOperationException();
        }

        public void addNetworkAdmin(String email) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getNetworkAdmins() {
            throw new UnsupportedOperationException();
        }

        public Set<String> getNonNetworkAdmins() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestNetwork other = (TestNetwork)obj;
            return this.getId().equals(other.getId());
        }

        public TestSite getSite(SiteVisibility siteVisibility) {
            TestSite ret = null;
            for (TestSite site : this.getSitesForUser(null).values()) {
                if (!site.getVisibility().equals(siteVisibility)) continue;
                ret = site;
                break;
            }
            return ret;
        }

        @Override
        public String toString() {
            return "TestNetwork [people=" + String.valueOf(this.people) + ", sites=" + String.valueOf(this.sites) + ", publicSites=" + String.valueOf(this.publicSites) + "]";
        }
    }

    public class TestPerson
    extends Person {
        private static final long serialVersionUID = 4038390056182705588L;
        protected boolean enabled;
        protected String password;
        protected TestNetwork defaultAccount;
        protected TreeMap<TestSite, SiteRole> siteMemberships;

        public TestPerson(String firstName, String lastName, String username, String password, Company company, TestNetwork defaultAccount, String skype, String location, String tel, String mob, String instantmsg, String google) {
            super(username, username, true, firstName, lastName, company, skype, location, tel, mob, instantmsg, google, null);
            this.siteMemberships = new TreeMap();
            this.password = password;
            this.enabled = true;
            this.defaultAccount = defaultAccount;
        }

        public boolean isNetworkAdmin() {
            return false;
        }

        public String getDefaultDomain() {
            return this.defaultAccount == null ? null : this.defaultAccount.getId();
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public void addSiteMembership(TestSite site, SiteRole siteRole) {
            this.siteMemberships.put(site, siteRole);
        }

        public TestNetwork getDefaultAccount() {
            return this.defaultAccount;
        }

        public String getPassword() {
            return this.password;
        }

        public List<PersonNetwork> getNetworkMemberships() {
            String personId = this.getId();
            String runAsNetworkId = Person.getNetworkId(personId);
            return (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<PersonNetwork>>(){

                public List<PersonNetwork> doWork() throws Exception {
                    ArrayList<PersonNetwork> members = new ArrayList<PersonNetwork>();
                    PagingResults networks = RepoService.this.networksService.getNetworks(new PagingRequest(0, Integer.MAX_VALUE));
                    for (Network network : networks.getPage()) {
                        NetworkImpl restNetwork = new NetworkImpl(network);
                        PersonNetwork personNetwork = new PersonNetwork(network.getIsHomeNetwork(), restNetwork);
                        members.add(personNetwork);
                    }
                    return members;
                }
            }, (String)personId, (String)runAsNetworkId);
        }

        @Override
        public String toString() {
            return "TestPerson [enabled=" + this.enabled + ", password=" + this.password + ", defaultAccount=" + this.defaultAccount.getId() + ", siteMemberships=" + String.valueOf(this.siteMemberships) + ", getId()=" + this.getId() + ", getFirstName()=" + this.getFirstName() + ", getCompany()=" + String.valueOf(this.getCompany()) + ", getLastName()=" + this.getLastName() + "]";
        }
    }

    public static class SiteInformation
    implements Comparable<SiteInformation> {
        private String shortName;
        private String title;
        private String sitePreset;
        private String description;
        private SiteVisibility siteVisibility;

        public SiteInformation(String shortName, String title, String description, SiteVisibility siteVisibility) {
            if (shortName == null) {
                throw new IllegalArgumentException();
            }
            this.shortName = shortName;
            this.title = title;
            this.description = description;
            this.siteVisibility = siteVisibility;
        }

        public SiteInformation(String shortName, String title, String description, String sitePreset, SiteVisibility siteVisibility) {
            this(shortName, title, description, siteVisibility);
            this.sitePreset = sitePreset;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSitePreset() {
            return this.sitePreset;
        }

        public String getDescription() {
            return this.description;
        }

        public SiteVisibility getSiteVisibility() {
            return this.siteVisibility;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SiteInformation)) {
                return false;
            }
            SiteInformation site = (SiteInformation)other;
            return this.shortName == site.getShortName();
        }

        @Override
        public int compareTo(SiteInformation site) {
            return this.shortName.compareTo(site.getShortName());
        }

        public int hashCode() {
            return this.getShortName().hashCode();
        }
    }

    public class TestSite
    extends SiteImpl {
        private static final long serialVersionUID = 5317623044880374281L;
        private TestNetwork account;
        private SiteInfo siteInfo;

        public TestSite(TestNetwork account, SiteInfo siteInfo) {
            this(account, siteInfo.getShortName(), siteInfo.getNodeRef().getId(), siteInfo.getTitle(), siteInfo.getDescription(), siteInfo.getVisibility());
            this.account = account;
            this.siteInfo = siteInfo;
        }

        public TestSite(TestNetwork account, String siteId, String guid, String title, String description, SiteVisibility siteVisibility) {
            super(account == null ? null : account.getId(), siteId, guid);
            this.setTitle(title);
            this.setDescription(description);
            this.setVisibility(siteVisibility.toString());
            this.siteInfo = RepoService.this.siteService.getSite(siteId);
        }

        public SiteInfo getSiteInfo() {
            return this.siteInfo;
        }

        public NodeRef getContainerNodeRef(String containerId) {
            return RepoService.this.siteService.getContainer(this.siteId, containerId);
        }

        public NodeRef createContainer(String containerName) {
            return RepoService.this.siteService.createContainer(this.getSiteId(), containerName, ContentModel.TYPE_FOLDER, null);
        }

        public void inviteToSite(String toInvite, SiteRole siteRole) {
            RepoService.this.siteService.setMembership(this.getSiteId(), toInvite, siteRole.toString());
            RepoService.this.log(toInvite + " invited to site " + this.getSiteId());
        }

        public TestNetwork getAccount() {
            return this.account;
        }

        public Map<String, String> getMembers(final String roleFilter) {
            Map members = (Map)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Map<String, String>>(){

                public Map<String, String> doWork() throws Exception {
                    Map members = RepoService.this.siteService.listMembers(TestSite.this.getSiteId(), null, roleFilter, 0);
                    return members;
                }
            }, (String)this.getAccount().getId());
            return members;
        }

        public List<SiteMember> getMembers() {
            Map members = (Map)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Map<String, String>>(){

                public Map<String, String> doWork() throws Exception {
                    Map members = RepoService.this.siteService.listMembers(TestSite.this.getSiteId(), null, null, 0);
                    return members;
                }
            }, (String)this.getAccount().getId());
            ArrayList<SiteMember> ret = new ArrayList<SiteMember>(members.size());
            for (String userId : members.keySet()) {
                String role = (String)members.get(userId);
                TestPerson person = RepoService.this.getPerson(userId);
                SiteMember sm = new SiteMember(userId, person, this.getSiteId(), role);
                ret.add(sm);
            }
            Collections.sort(ret);
            return ret;
        }

        public boolean isMember(final String personId) {
            Boolean isMember = (Boolean)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return RepoService.this.siteService.isMember(TestSite.this.getSiteId(), personId);
                }
            }, (String)this.getAccount().getId());
            return isMember;
        }

        public SiteRole getMember(String personId) {
            return SiteRole.valueOf(RepoService.this.siteService.getMembersRole(this.getSiteId(), personId));
        }

        public void updateMember(String personId, SiteRole role) {
            RepoService.this.siteService.setMembership(this.getSiteId(), personId, role.toString());
        }

        public void removeMember(String personId) {
            if (RepoService.this.siteService.isMember(this.getSiteId(), personId)) {
                RepoService.this.siteService.removeMembership(this.getSiteId(), personId);
            }
        }

        public void setSiteVisibility(SiteVisibility siteVisibility) {
            this.visibility = siteVisibility.toString();
            this.siteInfo.setVisibility(siteVisibility);
            RepoService.this.siteService.updateSite(this.siteInfo);
        }

        @Override
        public String toString() {
            return "TestSite [siteid=" + this.getSiteId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", siteVisibility=" + this.getVisibility() + "]";
        }
    }

    public static class SiteMembership
    implements Comparable<SiteMembership> {
        private TestSite site;
        private SiteRole role;

        public SiteMembership(TestSite site, SiteRole role) {
            if (site == null) {
                throw new IllegalArgumentException();
            }
            if (role == null) {
                throw new IllegalArgumentException();
            }
            this.site = site;
            this.role = role;
        }

        public TestSite getSite() {
            return this.site;
        }

        public SiteRole getRole() {
            return this.role;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            result = 31 * result + (this.site == null ? 0 : this.site.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SiteMembership other = (SiteMembership)obj;
            if (this.role != other.role) {
                return false;
            }
            return this.site.equals(other.site);
        }

        @Override
        public int compareTo(SiteMembership siteMembership) {
            int ret = this.site.getSiteId().compareTo(siteMembership.getSite().getSiteId());
            if (ret == 0) {
                ret = this.role.compareTo(siteMembership.getRole());
            }
            return ret;
        }
    }
}

