/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.alfresco.rest.api.tests.client.AbstractHttp;
import org.alfresco.rest.api.tests.client.AuthenticationDetailsProvider;
import org.alfresco.rest.api.tests.client.HttpClientProvider;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.simple.JSONObject;

public class AuthenticatedHttp
extends AbstractHttp {
    private static final String JSON_TICKET_KEY = "ticket";
    private static final String TICKET_CREDENTIAL_PLACEHOLDER = "ROLE_TICKET";
    private String LOGIN_URL = "/alfresco/service/api/login";
    private String LOGIN_JSON_USERNAME = "username";
    private String LOGIN_JSON_PASSWORD = "password";
    public static final String MIME_TYPE_JSON = "application/json";
    public static final String HEADER_ACCEPT = "Accept";
    private HttpClientProvider httpProvider;
    private AuthenticationDetailsProvider authDetailProvider;
    private boolean ticketBasedAuthentication;

    public AuthenticatedHttp(HttpClientProvider httpProvider, AuthenticationDetailsProvider authenticationDetailsProvider) {
        this.httpProvider = httpProvider;
        this.authDetailProvider = authenticationDetailsProvider;
        this.ticketBasedAuthentication = false;
    }

    public void setTicketBasedAuthentication(boolean ticketBasedAuthentication) {
        this.ticketBasedAuthentication = ticketBasedAuthentication;
    }

    public HttpClientProvider getHttpProvider() {
        return this.httpProvider;
    }

    public AuthenticationDetailsProvider getAuthDetailProvider() {
        return this.authDetailProvider;
    }

    public <T> T executeHttpMethodAuthenticated(HttpMethod method, String userName, HttpRequestCallback<T> callback) {
        if (this.ticketBasedAuthentication) {
            return this.executeWithTicketAuthentication(method, userName, this.authDetailProvider.getPasswordForUser(userName), callback);
        }
        return this.executeWithBasicAuthentication(method, userName, this.authDetailProvider.getPasswordForUser(userName), callback);
    }

    public <T> T executeHttpMethodAuthenticated(HttpMethod method, String userName, String password, HttpRequestCallback<T> callback) {
        if (this.ticketBasedAuthentication) {
            return this.executeWithTicketAuthentication(method, userName, password, callback);
        }
        return this.executeWithBasicAuthentication(method, userName, password, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeHttpMethodUnauthenticated(HttpMethod method, HttpRequestCallback<T> callback) {
        try {
            this.httpProvider.getHttpClient().executeMethod(null, method);
            if (callback != null) {
                T t = callback.onCallSuccess(method);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Throwable t) {
            boolean handled = false;
            if (callback != null) {
                handled = callback.onError(method, t);
            }
            if (!handled) {
                throw new RuntimeException("Error while executing an un-authenticated HTTP-call (" + method.getPath() + ")", t);
            }
            T t2 = null;
            return t2;
        }
        finally {
            method.releaseConnection();
        }
    }

    public <T> T executeHttpMethodAsAdmin(HttpMethod method, HttpRequestCallback<T> callback) {
        if (this.ticketBasedAuthentication) {
            return this.executeWithTicketAuthentication(method, this.authDetailProvider.getAdminUserName(), this.authDetailProvider.getAdminPassword(), callback);
        }
        return this.executeWithBasicAuthentication(method, this.authDetailProvider.getAdminUserName(), this.authDetailProvider.getAdminPassword(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithBasicAuthentication(HttpMethod method, String userName, String password, HttpRequestCallback<T> callback) {
        try {
            HttpState state = new HttpState();
            if (userName != null) {
                state.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            }
            this.httpProvider.getHttpClient().executeMethod(null, method, state);
            if (callback != null) {
                T t = callback.onCallSuccess(method);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Throwable t) {
            boolean handled = false;
            if (callback != null) {
                handled = callback.onError(method, t);
            }
            if (!handled) {
                throw new RuntimeException("Error while executing HTTP-call (" + method.getPath() + ")", t);
            }
            T t2 = null;
            return t2;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithTicketAuthentication(HttpMethod method, String userName, String password, HttpRequestCallback<T> callback) {
        String ticket = this.authDetailProvider.getTicketForUser(userName);
        if (ticket == null) {
            ticket = this.fetchLoginTicket(userName, password);
            this.authDetailProvider.updateTicketForUser(userName, ticket);
        }
        try {
            HttpState state = this.applyTicketToMethod(method, ticket);
            int result = this.httpProvider.getHttpClient().executeMethod(null, method, state);
            if (result == 401 || result == 403) {
                method.releaseConnection();
                if (!method.validate()) {
                    throw new RuntimeException("Ticket re-authentication failed for user " + userName + " (HTTPMethod not reusable)");
                }
                ticket = this.fetchLoginTicket(userName, userName);
                this.authDetailProvider.updateTicketForUser(userName, ticket);
                state = this.applyTicketToMethod(method, ticket);
                result = this.httpProvider.getHttpClient().executeMethod(null, method, state);
            }
            if (callback != null) {
                T t = callback.onCallSuccess(method);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Throwable t) {
            boolean handled = false;
            if (callback != null) {
                handled = callback.onError(method, t);
            }
            if (!handled) {
                throw new RuntimeException("Error while executing HTTP-call (" + method.getPath() + ")", t);
            }
            T t2 = null;
            return t2;
        }
        finally {
            method.releaseConnection();
        }
    }

    private HttpState applyTicketToMethod(HttpMethod method, String ticket) throws URIException {
        HttpState state = new HttpState();
        state.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(TICKET_CREDENTIAL_PLACEHOLDER, ticket));
        return state;
    }

    private void populateRequestBody(EntityEnclosingMethod method, JSONObject object) {
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity(object.toJSONString(), MIME_TYPE_JSON, "UTF-8"));
        }
        catch (UnsupportedEncodingException error) {
            throw new RuntimeException("All hell broke loose, a JVM that doesn't have UTF-8 encoding...");
        }
    }

    private String fetchLoginTicket(String userName, String password) {
        String url = this.httpProvider.getFullAlfrescoUrlForPath(this.LOGIN_URL);
        PostMethod loginMethod = null;
        try {
            loginMethod = new PostMethod(url);
            loginMethod.setRequestHeader(HEADER_ACCEPT, MIME_TYPE_JSON);
            JSONObject requestBody = new JSONObject();
            requestBody.put((Object)this.LOGIN_JSON_USERNAME, (Object)userName);
            requestBody.put((Object)this.LOGIN_JSON_PASSWORD, (Object)password);
            this.populateRequestBody((EntityEnclosingMethod)loginMethod, requestBody);
            HttpClient client = this.httpProvider.getHttpClient();
            client.executeMethod((HttpMethod)loginMethod);
            if (loginMethod.getStatusCode() == 200) {
                JSONObject data = this.getDataFromResponse((HttpMethod)loginMethod);
                if (data == null) {
                    throw new RuntimeException("Failed to login to Alfresco with user " + userName + " (No JSON-data found in response)");
                }
                String ticket = this.getString(data, JSON_TICKET_KEY, null);
                if (ticket == null) {
                    throw new RuntimeException("Failed to login to Alfresco with user " + userName + " (No ticket found in JSON-response)");
                }
                String string = ticket;
                return string;
            }
            try {
                throw new RuntimeException("Failed to login to Alfresco with user " + userName + " (" + loginMethod.getStatusCode() + loginMethod.getStatusLine().getReasonPhrase() + ")");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to login to Alfresco with user " + userName, ioe);
            }
        }
        finally {
            if (loginMethod != null) {
                try {
                    loginMethod.releaseConnection();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static interface HttpRequestCallback<T> {
        public T onCallSuccess(HttpMethod var1) throws Exception;

        public boolean onError(HttpMethod var1, Throwable var2);
    }
}

