/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.action.AbstractActionWebscript;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.ISO8601DateFormat;

public class RunningActionModelBuilder {
    protected static final String MODEL_DATA_ITEM = "runningAction";
    protected static final String MODEL_DATA_LIST = "runningActions";
    protected static final String ACTION_ID = "id";
    protected static final String ACTION_TYPE = "type";
    protected static final String ACTION_INSTANCE = "instance";
    protected static final String ACTION_NODE_REF = "nodeRef";
    protected static final String ACTION_STARTED_AT = "startedAt";
    protected static final String ACTION_RUNNING_ON = "runningOn";
    protected static final String ACTION_CANCEL_REQUESTED = "cancelRequested";
    protected static final String ACTION_KEY = "key";
    protected NodeService nodeService;
    protected ActionService actionService;
    protected ActionTrackingService actionTrackingService;

    public RunningActionModelBuilder(NodeService nodeService, ActionService actionService, ActionTrackingService actionTrackingService) {
        this.nodeService = nodeService;
        this.actionService = actionService;
        this.actionTrackingService = actionTrackingService;
    }

    protected Map<String, Object> buildSimpleModel(ExecutionSummary summary) {
        Map<String, Object> ram = this.buildModel(summary);
        if (ram != null) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put(MODEL_DATA_ITEM, ram);
            return model;
        }
        return null;
    }

    protected Map<String, Object> buildSimpleList(List<ExecutionSummary> runningActions) {
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        for (ExecutionSummary summary : runningActions) {
            Map<String, Object> ram = this.buildModel(summary);
            if (ram == null) continue;
            models.add(ram);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_DATA_LIST, models);
        return model;
    }

    private Map<String, Object> buildModel(ExecutionSummary summary) {
        if (summary == null) {
            return null;
        }
        ExecutionDetails details = this.actionTrackingService.getExecutionDetails(summary);
        if (details != null) {
            HashMap<String, Object> ram = new HashMap<String, Object>();
            ram.put(ACTION_ID, summary.getActionId());
            ram.put(ACTION_TYPE, summary.getActionType());
            ram.put(ACTION_INSTANCE, summary.getExecutionInstance());
            ram.put(ACTION_KEY, AbstractActionWebscript.getRunningId(summary));
            ram.put(ACTION_NODE_REF, details.getPersistedActionRef());
            ram.put(ACTION_RUNNING_ON, details.getRunningOn());
            ram.put(ACTION_CANCEL_REQUESTED, details.isCancelRequested());
            if (details.getStartedAt() != null) {
                ram.put(ACTION_STARTED_AT, ISO8601DateFormat.format((Date)details.getStartedAt()));
            } else {
                ram.put(ACTION_STARTED_AT, null);
            }
            return ram;
        }
        return null;
    }
}

