/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import java.util.List;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public interface Renditions {
    public static final String PARAM_STATUS = "status";
    public static final String PARAM_ATTACHMENT = "attachment";
    public static final String PARAM_PLACEHOLDER = "placeholder";

    public CollectionWithPagingInfo<Rendition> getRenditions(NodeRef var1, Parameters var2);

    public CollectionWithPagingInfo<Rendition> getRenditions(NodeRef var1, String var2, Parameters var3);

    public Rendition getRendition(NodeRef var1, String var2, Parameters var3);

    public Rendition getRendition(NodeRef var1, String var2, String var3, Parameters var4);

    public void createRendition(NodeRef var1, Rendition var2, Parameters var3);

    public void createRendition(NodeRef var1, Rendition var2, boolean var3, Parameters var4);

    public void createRendition(NodeRef var1, String var2, Rendition var3, boolean var4, Parameters var5);

    public void createRenditions(NodeRef var1, List<Rendition> var2, Parameters var3) throws NotFoundException, ConstraintViolatedException;

    public void createRenditions(NodeRef var1, String var2, List<Rendition> var3, Parameters var4) throws NotFoundException, ConstraintViolatedException;

    public void deleteRendition(NodeRef var1, String var2, Parameters var3);

    public void deleteRendition(NodeRef var1, String var2, String var3, Parameters var4);

    public BinaryResource getContent(NodeRef var1, String var2, Parameters var3);

    public BinaryResource getContent(NodeRef var1, String var2, String var3, Parameters var4);

    public BinaryResource getContentNoValidation(NodeRef var1, String var2, Parameters var3);

    public BinaryResource getContentNoValidation(NodeRef var1, String var2, String var3, Parameters var4);

    default public DirectAccessUrl requestContentDirectUrl(String nodeId, String versionId, String renditionId, boolean attachment) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.requestContentDirectUrl(nodeRef, versionId, renditionId, attachment);
    }

    default public DirectAccessUrl requestContentDirectUrl(String nodeId, String versionId, String renditionId, boolean attachment, Long validFor) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.requestContentDirectUrl(nodeRef, versionId, renditionId, attachment, validFor);
    }

    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, String versionId, String renditionId, boolean attachment) {
        return this.requestContentDirectUrl(nodeRef, versionId, renditionId, attachment, null);
    }

    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, String versionId, String renditionId, boolean attachment, Long validFor) {
        return this.requestContentDirectUrl(nodeRef, versionId, renditionId, attachment, validFor, null);
    }

    public DirectAccessUrl requestContentDirectUrl(NodeRef var1, String var2, String var3, boolean var4, Long var5, String var6);
}

