/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.List;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.nodes.AbstractNodeRelation;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

@RelationshipResource(name="secondary-children", entityResource=NodesEntityResource.class, title="Node Secondary Children")
public class NodeSecondaryChildrenRelation
extends AbstractNodeRelation
implements RelationshipResourceAction.Read<Node>,
RelationshipResourceAction.Create<AssocChild>,
RelationshipResourceAction.Delete {
    @Override
    @WebApiDescription(title="Return a paged list of secondary child nodes based on child assocs")
    public CollectionWithPagingInfo<Node> readAll(String parentNodeId, Parameters parameters) {
        NodeRef parentNodeRef = this.nodes.validateOrLookupNode(parentNodeId);
        QNamePattern assocTypeQNameParam = this.getAssocTypeFromWhereElseAll(parameters);
        List childAssocRefs = null;
        childAssocRefs = assocTypeQNameParam.equals((Object)RegexQNamePattern.MATCH_ALL) ? this.nodeService.getChildAssocs(parentNodeRef) : this.nodeService.getChildAssocs(parentNodeRef, assocTypeQNameParam, RegexQNamePattern.MATCH_ALL);
        return this.listNodeChildAssocs(childAssocRefs, parameters, false, true);
    }

    @Override
    @WebApiDescription(title="Add secondary child assoc")
    public List<AssocChild> create(String parentNodeId, List<AssocChild> entities, Parameters parameters) {
        return this.nodes.addChildren(parentNodeId, entities);
    }

    @Override
    @WebApiDescription(title="Remove secondary child assoc(s)")
    public void delete(String parentNodeId, String childNodeId, Parameters parameters) {
        NodeRef parentNodeRef = this.nodes.validateNode(parentNodeId);
        NodeRef childNodeRef = this.nodes.validateNode(childNodeId);
        String assocTypeStr = parameters.getParameter("assocType");
        QName assocTypeQName = this.nodes.getAssocType(assocTypeStr, false);
        List assocRefs = this.nodeService.getChildAssocs(parentNodeRef);
        boolean found = false;
        for (ChildAssociationRef assocRef : assocRefs) {
            boolean existed;
            if (!assocRef.getChildRef().equals((Object)childNodeRef)) continue;
            if (assocTypeQName != null) {
                if (!assocTypeQName.equals((Object)assocRef.getTypeQName())) continue;
                if (assocRef.isPrimary()) {
                    throw new InvalidArgumentException("Cannot use secondary-children to delete primary assoc: " + parentNodeId + "," + assocTypeStr + "," + childNodeId);
                }
                existed = this.nodeService.removeSecondaryChildAssociation(assocRef);
                if (!existed) continue;
                found = true;
                continue;
            }
            if (assocRef.isPrimary() || !(existed = this.nodeService.removeSecondaryChildAssociation(assocRef))) continue;
            found = true;
        }
        if (!found) {
            throw new EntityNotFoundException(parentNodeId + "," + assocTypeStr + "," + childNodeId);
        }
    }
}

