/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters.where;

import org.alfresco.rest.antlr.WhereClauseLexer;
import org.alfresco.rest.antlr.WhereClauseParser;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WhereCompiler {
    private static Log logger = LogFactory.getLog(WhereCompiler.class);

    public static CommonTree compileWhereClause(String expression) throws RecognitionException {
        ANTLRStringStream input = new ANTLRStringStream(expression);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)new WhereClauseLexer((CharStream)input));
        WhereClauseParser parser = new WhereClauseParser((TokenStream)tokens);
        WhereClauseParser.whereclause_return ret = parser.whereclause();
        CommonTree ast = (CommonTree)ret.getTree();
        if (logger.isDebugEnabled()) {
            WhereCompiler.print(ast, 0);
        }
        return ast;
    }

    public static CommonTree compileSelectClause(String selectParam) throws RecognitionException {
        ANTLRStringStream input = new ANTLRStringStream(selectParam);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)new WhereClauseLexer((CharStream)input));
        WhereClauseParser parser = new WhereClauseParser((TokenStream)tokens);
        WhereClauseParser.selectClause_return ret = parser.selectClause();
        CommonTree ast = (CommonTree)ret.getTree();
        if (logger.isDebugEnabled()) {
            WhereCompiler.print(ast, 0);
        }
        return ast;
    }

    private static void print(CommonTree tree, int level) {
        for (int i = 0; i < level; ++i) {
            logger.debug((Object)"--");
        }
        logger.debug((Object)(" " + tree.getType() + " " + tree.getText()));
        if (tree.getChildren() != null) {
            for (Object ie : tree.getChildren()) {
                WhereCompiler.print((CommonTree)ie, level + 1);
            }
        }
    }

    public static String resolveMessage(RecognitionException exception) {
        if (exception != null) {
            return "Error at char position " + exception.charPositionInLine;
        }
        return "";
    }
}

