/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebscriptCookieAuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter {
    private static final Log logger = LogFactory.getLog(WebscriptCookieAuthenticationFilter.class);
    private static final String API_LOGIN = "/api/login";

    public WebscriptCookieAuthenticationFilter() {
        this.setUserAttributeName("_alfAuthTicket");
    }

    @Override
    public void doFilter(ServletContext context, ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse res = (HttpServletResponse)sresp;
        if (API_LOGIN.equals(req.getPathInfo()) && req.getMethod().equalsIgnoreCase("POST")) {
            this.handleLoginForm(req, res);
        } else {
            chain.doFilter(sreq, sresp);
        }
    }

    @Override
    protected Log getLogger() {
        return logger;
    }
}

