/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bulkimport;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.bulkimport.BulkFilesystemImporter;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BulkFilesystemImportStatusWebScript
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(BulkFilesystemImportStatusWebScript.class);
    private static final String RESULT_IMPORT_STATUS = "importStatus";
    private static final String IS_ENTERPRISE = "isEnterprise";
    private BulkFilesystemImporter bulkImporter;
    private DescriptorService descriptorService;

    public void setBulkImporter(BulkFilesystemImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        cache.setNeverCache(true);
        LicenseDescriptor licenseDescriptor = this.descriptorService.getLicenseDescriptor();
        boolean isEnterprise = licenseDescriptor == null ? false : licenseDescriptor.getLicenseMode() == RepoUsage.LicenseMode.ENTERPRISE;
        result.put(IS_ENTERPRISE, isEnterprise);
        result.put(RESULT_IMPORT_STATUS, this.bulkImporter.getStatus());
        return result;
    }
}

