/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Arrays;
import java.util.Collection;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RenameShuffleDetectionTest {
    private WebDAVHelper davHelper;
    private String path;
    private boolean expectedResult;

    public RenameShuffleDetectionTest(String path, boolean expectedResult) {
        this.path = path;
        this.expectedResult = expectedResult;
    }

    @Before
    public void setUp() throws Exception {
        this.davHelper = new WebDAVHelper();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"a_file.doc", false}, {"/path/a_file.doc", false}, {"__file__name.xls", false}, {"/some/parent/ffffffff.doc", false}, {"/some/parent/.tmp", true}, {"/some/parent/a.tmp", true}, {"/some/parent/ffffffff.tmp", true}, {"/some/parent/.any_hidden_file", true}, {"/some/parent/any_file.wbk", true}, {"/some/parent/ends_in_tilda~", true}, {"/some/parent/junk_backup_morejunk.doc", true}, {"/some/parent/junk_backup_morejunk.docx", true}, {"/some/parent/junk_backup_morejunk.docm", true}, {"/some/parent/junk_backup_morejunk.docxm", true}, {"/some/parent/junk_backup_morejunk.dotx", true}, {"/some/parent/junk_backup_morejunk.dotm", true}, {"/some/parent/junk_backup_morejunk.dotxm", true}, {"/some/parent/aaaaaaaa", true}, {"/some/parent/ffffffff", true}, {"/some/parent/ffffffffff", true}, {"/some/parent/ab0c1d2ef3456789", true}, {"aaaaaaaa", true}, {"abcdef01", true}, {"1234567890.txt.sb-764f0c5c-JUoEKy", true}, {"/psC1DA.tmp", true}, {"/path/psA1B5.tmp", true}};
        return Arrays.asList(data);
    }

    @Test
    public void testIsRenameShuffle() {
        Assert.assertEquals((String)("Incorrect result for path: " + this.path), (Object)this.expectedResult, (Object)this.davHelper.isRenameShuffle(this.path));
    }
}

