/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Preference;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Test;

public class TestUserPreferences
extends EnterpriseTestApi {
    @Test
    public void testUserPreferences() throws Exception {
        HashMap<String, String> params;
        String maxItems;
        HashMap<String, String> params2;
        String maxItems2;
        String skipCount;
        PublicApiClient.Paging paging;
        int maxItems3;
        int skipCount2;
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network1 = networksIt.next();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network2 = networksIt.next();
        final ArrayList people = new ArrayList(3);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)network2.getId());
        final RepoService.TestPerson person1 = (RepoService.TestPerson)people.get(0);
        RepoService.TestPerson person2 = (RepoService.TestPerson)people.get(1);
        RepoService.TestPerson person3 = (RepoService.TestPerson)people.get(2);
        final ArrayList<Preference> expectedPreferences = new ArrayList<Preference>();
        expectedPreferences.add(new Preference("org.alfresco.share.documentList.testPreference2", String.valueOf(true)));
        expectedPreferences.add(new Preference("org.alfresco.share.documentList.testPreference1", String.valueOf(true)));
        expectedPreferences.add(new Preference("org.alfresco.share.documentList.sortAscending", String.valueOf(true)));
        expectedPreferences.add(new Preference("org.alfresco.share.documentList.testPreference3", String.valueOf(true)));
        expectedPreferences.add(new Preference("org.alfresco.ext.folders.favourites.workspace://SpacesStore/4e3d0779-388a-4b94-91e1-eab588a7da3d.createdAt", String.valueOf(true)));
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                for (Preference pref : expectedPreferences) {
                    TestUserPreferences.this.repoService.addPreference(person1.getId(), pref.getId(), (Serializable)((Object)pref.getValue()));
                }
                return null;
            }
        }, (String)person1.getId(), (String)network1.getId());
        Collections.sort(expectedPreferences);
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        try {
            skipCount2 = 0;
            maxItems3 = 2;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            paging = this.getPaging(skipCount2, maxItems3, expectedPreferences.size(), expectedPreferences.size());
            peopleProxy.getPreferences(GUID.generate(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        skipCount2 = 0;
        maxItems3 = 2;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        paging = this.getPaging(skipCount2, maxItems3, expectedPreferences.size(), expectedPreferences.size());
        PublicApiClient.ListResponse<Preference> resp = peopleProxy.getPreferences(person1.getId(), this.createParams(paging, null));
        this.checkList(expectedPreferences.subList(skipCount2, skipCount2 + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount2 = 2;
        maxItems3 = 10;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        paging = this.getPaging(skipCount2, maxItems3, expectedPreferences.size(), expectedPreferences.size());
        resp = peopleProxy.getPreferences(person1.getId(), this.createParams(paging, null));
        this.checkList(expectedPreferences.subList(skipCount2, skipCount2 + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount2 = 0;
        maxItems3 = 2;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        paging = this.getPaging(skipCount2, maxItems3, expectedPreferences.size(), expectedPreferences.size());
        resp = peopleProxy.getPreferences("-me-", this.createParams(paging, null));
        this.checkList(expectedPreferences.subList(skipCount2, skipCount2 + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        try {
            skipCount2 = 2;
            maxItems3 = 10;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            paging = this.getPaging(skipCount2, maxItems3, expectedPreferences.size(), expectedPreferences.size());
            peopleProxy.getPreferences("invalid.user", this.createParams(paging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = 0;
            maxItems3 = 2;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person3.getId()));
            paging = this.getPaging(skipCount, maxItems3, expectedPreferences.size(), expectedPreferences.size());
            peopleProxy.getPreferences(person1.getId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)e.getHttpResponse().getStatusCode(), (long)401L);
        }
        try {
            skipCount = 0;
            maxItems3 = 2;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            paging = this.getPaging(skipCount, maxItems3, expectedPreferences.size(), expectedPreferences.size());
            peopleProxy.getPreferences(person1.getId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        Preference pref = (Preference)expectedPreferences.get(0);
        Preference ret = peopleProxy.getPreference(person1.getId(), pref.getId());
        pref.expected(ret);
        try {
            pref = (Preference)expectedPreferences.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            peopleProxy.getPreference(GUID.generate(), pref.getId());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreference(person1.getId(), GUID.generate());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pref = (Preference)expectedPreferences.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.create("people", person1.getId(), "preferences", pref.getId(), pref.toJSON().toString(), "Unable to POST to a preference");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        Preference updatedPref = new Preference("preference.to.update", "updated.value");
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        Preference response = peopleProxy.updatePreference(person1.getId(), updatedPref);
        Assert.assertEquals((Object)updatedPref.getId(), (Object)response.getId());
        Assert.assertEquals((Object)updatedPref.getValue(), (Object)response.getValue());
        try {
            pref = (Preference)expectedPreferences.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.remove("people", person1.getId(), "preferences", pref.getId(), "Unable to DELETE a preference");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pref = (Preference)expectedPreferences.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.create("people", person1.getId(), "preferences", null, pref.toJSON().toString(), "Unable to POST to preferences");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pref = (Preference)expectedPreferences.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.update("people", person1.getId(), "preferences", null, pref.toJSON().toString(), "Unable to PUT preferences");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.remove("people", person1.getId(), "preferences", null, "Unable to DELETE preferences");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = "a";
            maxItems2 = "hi";
            params2 = new HashMap<String, String>();
            params2.put("skipCount", skipCount);
            params2.put("maxItems", maxItems2);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreferences(person1.getId(), params2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = "a";
            maxItems2 = "null";
            params2 = new HashMap();
            params2.put("skipCount", skipCount);
            params2.put("maxItems", maxItems2);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreferences(person1.getId(), params2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            maxItems = "Red";
            params = new HashMap<String, String>();
            params.put("maxItems", maxItems);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreferences(person1.getId(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = "yuck";
            params = new HashMap();
            params.put("skipCount", skipCount);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreferences(person1.getId(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = "-1";
            params = new HashMap();
            params.put("skipCount", skipCount);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreferences(person1.getId(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            maxItems = "0";
            params = new HashMap();
            params.put("maxItems", maxItems);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            peopleProxy.getPreferences(person1.getId(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }
}

