/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters.where;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.framework.resource.parameters.where.BasicQueryWalker;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.framework.resource.parameters.where.WhereProperty;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class QueryResolverTest {
    private final RecognizedParamsExtractor queryExtractor = new RecognizedParamsExtractor(this){};

    @Test
    public void testResolveQuery_equals() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(8, false)).isTrue();
        Assertions.assertThat((boolean)property.containsType(10, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(18, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(11, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(19, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(16, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(20, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(5, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(9, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(8, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(10, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(18, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(11, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(19, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(16, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(20, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(5, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(9, true)).isFalse();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(8, false)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_greaterThan() {
        Query query = this.queryExtractor.getWhereClause("(propName > testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(10, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(10, false)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_greaterThanOrEquals() {
        Query query = this.queryExtractor.getWhereClause("(propName >= testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(11, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(11, false)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_lessThan() {
        Query query = this.queryExtractor.getWhereClause("(propName < testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(18, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(18, false)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_lessThanOrEquals() {
        Query query = this.queryExtractor.getWhereClause("(propName <= testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(19, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(19, false)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_between() {
        Query query = this.queryExtractor.getWhereClause("(propName BETWEEN (testValue, testValue2))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(5, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(5, false)).containsOnly((Object[])new String[]{"testValue", "testValue2"});
    }

    @Test
    public void testResolveQuery_in() {
        Query query = this.queryExtractor.getWhereClause("(propName IN (testValue, testValue2))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(16, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(16, false)).containsOnly((Object[])new String[]{"testValue", "testValue2"});
    }

    @Test
    public void testResolveQuery_matches() {
        Query query = this.queryExtractor.getWhereClause("(propName MATCHES ('*Value'))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(20, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(20, false)).containsOnly((Object[])new String[]{"*Value"});
    }

    @Test
    public void testResolveQuery_exists() {
        Query query = this.queryExtractor.getWhereClause("(EXISTS (propName))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(9, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(9, false)).isEmpty();
    }

    @Test
    public void testResolveQuery_notEquals() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName=testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(8, true)).isTrue();
        Assertions.assertThat((boolean)property.containsType(8, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(10, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(18, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(11, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(19, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(16, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(20, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(5, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(9, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(10, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(18, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(11, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(19, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(16, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(20, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(5, true)).isFalse();
        Assertions.assertThat((boolean)property.containsType(9, true)).isFalse();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(8, true)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_notGreaterThan() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName > testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(10, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(10, true)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_notGreaterThanOrEquals() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName >= testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(11, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(11, true)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_notLessThan() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName < testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(18, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(18, true)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_notLessThanOrEquals() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName <= testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(19, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(19, true)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_notBetween() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName BETWEEN (testValue, testValue2))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(5, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(5, true)).containsOnly((Object[])new String[]{"testValue", "testValue2"});
    }

    @Test
    public void testResolveQuery_notIn() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName IN (testValue, testValue2))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(16, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(16, true)).containsOnly((Object[])new String[]{"testValue", "testValue2"});
    }

    @Test
    public void testResolveQuery_notMatches() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName MATCHES ('*Value'))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(20, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(20, true)).containsOnly((Object[])new String[]{"*Value"});
    }

    @Test
    public void testResolveQuery_notExists() {
        Query query = this.queryExtractor.getWhereClause("(NOT EXISTS (propName))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(9, true)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(9, true)).isEmpty();
    }

    @Test
    public void testResolveQuery_propertyNotExpected() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue AND differentName>18)");
        Throwable actualException = Assertions.catchThrowable(() -> QueryHelper.resolve((Query)query).getProperty("differentName"));
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testResolveQuery_propertyNotExpectedUsingLenientApproach() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue AND differentName>18)");
        WhereProperty property = ((QueryHelper.QueryResolver.WalkerSpecifier)QueryHelper.resolve((Query)query).leniently()).getProperty("differentName");
        Assertions.assertThat((boolean)property.containsType(8, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(8, true)).isFalse();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(8, false)).isNull();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(8, true)).isNull();
        Assertions.assertThat((boolean)property.containsType(10, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(10, false)).containsOnly((Object[])new String[]{"18"});
    }

    @Test
    public void testResolveQuery_propertyNotPresentUsingLenientApproach() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue)");
        Throwable actualException = Assertions.catchThrowable(() -> QueryHelper.resolve((Query)query).getProperty("differentName"));
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testResolveQuery_slashInPropertyName() {
        Query query = this.queryExtractor.getWhereClause("(EXISTS (prop/name/with/slashes))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("prop/name/with/slashes");
        Assertions.assertThat((boolean)property.containsType(9, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(9, false)).isEmpty();
    }

    @Test
    public void testResolveQuery_propertyBetweenDates() {
        Query query = this.queryExtractor.getWhereClause("(propName BETWEEN ('2012-01-01', '2012-12-31'))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(5, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(5, false)).containsOnly((Object[])new String[]{"2012-01-01", "2012-12-31"});
    }

    @Test
    public void testResolveQuery_singlePropertyGreaterThanOrEqualsAndLessThan() {
        Query query = this.queryExtractor.getWhereClause("(propName >= 18 AND propName < 65)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(11, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(11, false)).containsOnly((Object[])new String[]{"18"});
        Assertions.assertThat((boolean)property.containsType(18, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(18, false)).containsOnly((Object[])new String[]{"65"});
    }

    @Test
    public void testResolveQuery_onePropertyGreaterThanAndSecondPropertyNotMatches() {
        Query query = this.queryExtractor.getWhereClause("(propName1 > 20 AND NOT propName2 MATCHES ('external*'))");
        List property = QueryHelper.resolve((Query)query).getProperties(new String[]{"propName1", "propName2"});
        Assertions.assertThat((boolean)((WhereProperty)property.get(0)).containsType(10, false)).isTrue();
        Assertions.assertThat((Collection)((WhereProperty)property.get(0)).getExpectedValuesFor(10, false)).containsOnly((Object[])new String[]{"20"});
        Assertions.assertThat((boolean)((WhereProperty)property.get(1)).containsType(20, true)).isTrue();
        Assertions.assertThat((Collection)((WhereProperty)property.get(1)).getExpectedValuesFor(20, true)).containsOnly((Object[])new String[]{"external*"});
    }

    @Test
    public void testResolveQuery_negationsForbidden() {
        Query query = this.queryExtractor.getWhereClause("(NOT propName=testValue)");
        Throwable actualException = Assertions.catchThrowable(() -> ((QueryHelper.QueryResolver.WalkerSpecifier)QueryHelper.resolve((Query)query).withoutNegations()).getProperty("propName"));
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testResolveQuery_withoutNegations() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue)");
        WhereProperty actualProperty = ((QueryHelper.QueryResolver.WalkerSpecifier)QueryHelper.resolve((Query)query).withoutNegations()).getProperty("propName");
        Assertions.assertThat((boolean)actualProperty.containsType(8, false)).isTrue();
        Assertions.assertThat((boolean)actualProperty.containsType(8, true)).isFalse();
        Assertions.assertThat((Collection)actualProperty.getExpectedValuesFor(8).onlyNegated()).isNull();
        Assertions.assertThat((Collection)actualProperty.getExpectedValuesFor(8).skipNegated()).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_orNotAllowed() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue OR propName BETWEEN (testValue2, testValue3))");
        Throwable actualException = Assertions.catchThrowable(() -> QueryHelper.resolve((Query)query).getProperty("propName"));
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testResolveQuery_orAllowedInFavorOfAnd() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue OR propName=testValue2)");
        WhereProperty property = QueryHelper.resolve((Query)query).usingOrOperator().getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(8, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(8, false)).containsOnly((Object[])new String[]{"testValue", "testValue2"});
    }

    @Test
    public void testResolveQuery_usingCustomQueryWalker() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue)");
        Collection propertyValues = QueryHelper.resolve((Query)query).usingWalker((QueryHelper.WalkerCallback)new MapBasedQueryWalker(Set.of("propName"), null)).getProperty("propName", 8, false);
        Assertions.assertThat((Collection)propertyValues).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_usingCustomBasicQueryWalkerExtension() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue OR propName=testValue2)");
        WhereProperty property = QueryHelper.resolve((Query)query).usingWalker(new BasicQueryWalker(this, new String[]{"propName"}){

            public void or() {
            }

            public void and() {
                throw UNSUPPORTED;
            }
        }).withoutNegations().getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(8, false)).isTrue();
        Assertions.assertThat((Collection)property.getExpectedValuesFor(8, false)).containsOnly((Object[])new String[]{"testValue", "testValue2"});
    }

    @Test
    public void testResolveQuery_equalsAndInNotAllowedTogether() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue AND propName IN (testValue2, testValue3))");
        Throwable actualException = Assertions.catchThrowable(() -> QueryHelper.resolve((Query)query).getProperty("propName"));
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testResolveQuery_equalsOrInAllowedTogether() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue OR propName IN (testValue2, testValue3))");
        WhereProperty whereProperty = QueryHelper.resolve((Query)query).usingOrOperator().getProperty("propName");
        Assertions.assertThat((Map)whereProperty).isNotNull();
        Assertions.assertThat((Map)whereProperty.getExpectedValuesForAllOf(new int[]{8, 16}).skipNegated()).isEqualTo(Map.of(8, Set.of("testValue"), 16, Set.of("testValue2", "testValue3")));
    }

    @Test
    public void testResolveQuery_equalsAndInAllowedTogetherWithDifferentProperties() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue AND propName2 IN (testValue2, testValue3))");
        List properties = QueryHelper.resolve((Query)query).getProperties(new String[]{"propName", "propName2"});
        Assertions.assertThat((boolean)((WhereProperty)properties.get(0)).containsType(8, false)).isTrue();
        Assertions.assertThat((boolean)((WhereProperty)properties.get(0)).containsType(16, false)).isFalse();
        Assertions.assertThat((Collection)((Collection)((WhereProperty)properties.get(0)).getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().get(8))).containsOnly((Object[])new String[]{"testValue"});
        Assertions.assertThat((boolean)((WhereProperty)properties.get(0)).getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().containsKey(16)).isFalse();
        Assertions.assertThat((boolean)((WhereProperty)properties.get(1)).containsType(8, false)).isFalse();
        Assertions.assertThat((boolean)((WhereProperty)properties.get(1)).containsType(16, false)).isTrue();
        Assertions.assertThat((boolean)((WhereProperty)properties.get(1)).getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().containsKey(8)).isFalse();
        Assertions.assertThat((Collection)((Collection)((WhereProperty)properties.get(1)).getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().get(16))).containsOnly((Object[])new String[]{"testValue2", "testValue3"});
    }

    @Test
    public void testResolveQuery_equalsAndInAllowedAlternately_equals() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue)");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(8, false)).isTrue();
        Assertions.assertThat((boolean)property.containsType(16, false)).isFalse();
        Assertions.assertThat((Collection)((Collection)property.getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().get(8))).containsOnly((Object[])new String[]{"testValue"});
        Assertions.assertThat((boolean)property.getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().containsKey(16)).isFalse();
    }

    @Test
    public void testResolveQuery_equalsAndInAllowedAlternately_in() {
        Query query = this.queryExtractor.getWhereClause("(propName IN (testValue))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((boolean)property.containsType(8, false)).isFalse();
        Assertions.assertThat((boolean)property.containsType(16, false)).isTrue();
        Assertions.assertThat((boolean)property.getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().containsKey(8)).isFalse();
        Assertions.assertThat((Collection)((Collection)property.getExpectedValuesForAnyOf(new int[]{8, 16}).skipNegated().get(16))).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_missingEqualsClauseType() {
        Query query = this.queryExtractor.getWhereClause("(propName MATCHES (testValue))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThatExceptionOfType(InvalidQueryException.class).isThrownBy(() -> property.getExpectedValuesForAllOf(new int[]{8, 20}));
    }

    @Test
    public void testResolveQuery_ignoreUnexpectedClauseType() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue AND propName MATCHES (testValue))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((Collection)property.getExpectedValuesForAllOf(new int[]{8}).skipNegated(8)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_complexAndQuery() {
        Query query = this.queryExtractor.getWhereClause("(a=v1 AND b>18 AND b<=65 AND NOT c BETWEEN ('2012-01-01','2012-12-31') AND d IN (v1, v2) AND e MATCHES ('*@mail.com') AND EXISTS (f/g))");
        List properties = QueryHelper.resolve((Query)query).getProperties(new String[]{"a", "b", "c", "d", "e", "f/g"});
        Assertions.assertThat((List)properties).hasSize(6);
        Assertions.assertThat((Collection)((WhereProperty)properties.get(0)).getExpectedValuesFor(WhereProperty.ClauseType.EQUALS)).containsOnly((Object[])new String[]{"v1"});
        Assertions.assertThat((boolean)((WhereProperty)properties.get(1)).containsAllTypes(new WhereProperty.ClauseType[]{WhereProperty.ClauseType.GREATER_THAN, WhereProperty.ClauseType.LESS_THAN_OR_EQUALS})).isTrue();
        Assertions.assertThat((Collection)((WhereProperty)properties.get(1)).getExpectedValuesFor(WhereProperty.ClauseType.GREATER_THAN)).containsOnly((Object[])new String[]{"18"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(1)).getExpectedValuesFor(WhereProperty.ClauseType.LESS_THAN_OR_EQUALS)).containsOnly((Object[])new String[]{"65"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(2)).getExpectedValuesFor(WhereProperty.ClauseType.NOT_BETWEEN)).containsOnly((Object[])new String[]{"2012-01-01", "2012-12-31"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(3)).getExpectedValuesFor(WhereProperty.ClauseType.IN)).containsOnly((Object[])new String[]{"v1", "v2"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(4)).getExpectedValuesFor(WhereProperty.ClauseType.MATCHES)).containsOnly((Object[])new String[]{"*@mail.com"});
        Assertions.assertThat((boolean)((WhereProperty)properties.get(5)).containsType(WhereProperty.ClauseType.EXISTS)).isTrue();
        Assertions.assertThat((Collection)((WhereProperty)properties.get(5)).getExpectedValuesFor(WhereProperty.ClauseType.EXISTS)).isEmpty();
    }

    @Test
    public void testResolveQuery_complexOrQuery() {
        Query query = this.queryExtractor.getWhereClause("(a=v1 OR b>18 OR b<=65 OR NOT c BETWEEN ('2012-01-01','2012-12-31') OR d IN (v1, v2) OR e MATCHES ('*@mail.com') OR EXISTS (f/g))");
        List properties = QueryHelper.resolve((Query)query).usingOrOperator().getProperties(new String[]{"a", "b", "c", "d", "e", "f/g"});
        Assertions.assertThat((List)properties).hasSize(6);
        Assertions.assertThat((Collection)((WhereProperty)properties.get(0)).getExpectedValuesFor(WhereProperty.ClauseType.EQUALS)).containsOnly((Object[])new String[]{"v1"});
        Assertions.assertThat((boolean)((WhereProperty)properties.get(1)).containsAllTypes(new WhereProperty.ClauseType[]{WhereProperty.ClauseType.GREATER_THAN, WhereProperty.ClauseType.LESS_THAN_OR_EQUALS})).isTrue();
        Assertions.assertThat((Collection)((WhereProperty)properties.get(1)).getExpectedValuesFor(WhereProperty.ClauseType.GREATER_THAN)).containsOnly((Object[])new String[]{"18"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(1)).getExpectedValuesFor(WhereProperty.ClauseType.LESS_THAN_OR_EQUALS)).containsOnly((Object[])new String[]{"65"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(2)).getExpectedValuesFor(WhereProperty.ClauseType.NOT_BETWEEN)).containsOnly((Object[])new String[]{"2012-01-01", "2012-12-31"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(3)).getExpectedValuesFor(WhereProperty.ClauseType.IN)).containsOnly((Object[])new String[]{"v1", "v2"});
        Assertions.assertThat((Collection)((WhereProperty)properties.get(4)).getExpectedValuesFor(WhereProperty.ClauseType.MATCHES)).containsOnly((Object[])new String[]{"*@mail.com"});
        Assertions.assertThat((boolean)((WhereProperty)properties.get(5)).containsType(WhereProperty.ClauseType.EXISTS)).isTrue();
        Assertions.assertThat((Collection)((WhereProperty)properties.get(5)).getExpectedValuesFor(WhereProperty.ClauseType.EXISTS)).isEmpty();
    }

    @Test
    public void testResolveQuery_clauseTypeOptional() {
        Query query = this.queryExtractor.getWhereClause("(propName MATCHES (testValue))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThat((Collection)property.getExpectedValuesForAnyOf(new int[]{8, 20}).skipNegated(20)).containsOnly((Object[])new String[]{"testValue"});
    }

    @Test
    public void testResolveQuery_optionalClauseTypesNotPresent() {
        Query query = this.queryExtractor.getWhereClause("(propName=testValue AND propName MATCHES (testValue))");
        WhereProperty property = QueryHelper.resolve((Query)query).getProperty("propName");
        Assertions.assertThatExceptionOfType(InvalidQueryException.class).isThrownBy(() -> property.getExpectedValuesForAnyOf(new int[]{16}));
    }

    @Test
    public void testResolveQuery_matchesOrMatchesAllowed() {
        Query query = this.queryExtractor.getWhereClause("(propName MATCHES ('test*') OR propName MATCHES ('*value*'))");
        Collection expectedValues = QueryHelper.resolve((Query)query).usingOrOperator().getProperty("propName").getExpectedValuesFor(20).skipNegated();
        Assertions.assertThat((Collection)expectedValues).containsOnly((Object[])new String[]{"test*", "*value*"});
    }
}

