/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.solr.facet.Exceptions;
import org.alfresco.repo.search.impl.solr.facet.FacetQNameUtils;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.repo.web.scripts.facet.AbstractSolrFacetConfigAdminWebScript;
import org.alfresco.repo.web.scripts.facet.SolrFacetConfigAdminPost;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SolrFacetConfigAdminPut
extends AbstractSolrFacetConfigAdminWebScript {
    private static final Log logger = LogFactory.getLog(SolrFacetConfigAdminPost.class);
    protected static final String PARAM_RELATIVE_POS = "relativePos";
    protected static final String URL_PARAM_FILTER_ID = "filterID";

    @Override
    protected Map<String, Object> unprotectedExecuteImpl(WebScriptRequest req, Status status, Cache cache) {
        block10: {
            String relativePosString = req.getParameter(PARAM_RELATIVE_POS);
            try {
                if (relativePosString != null) {
                    int relativePos;
                    try {
                        relativePos = Integer.parseInt(relativePosString);
                    }
                    catch (NumberFormatException nfe) {
                        throw new WebScriptException(400, "Cannot move facet as could not parse relative position: '" + relativePosString + "'");
                    }
                    Map templateVars = req.getServiceMatch().getTemplateVars();
                    String filterId = (String)templateVars.get(URL_PARAM_FILTER_ID);
                    if (filterId == null) {
                        throw new WebScriptException(400, "Illegal null filterId");
                    }
                    try {
                        List facets = this.facetService.getFacets();
                        List facetIDs = CollectionUtils.transform((Collection)facets, (Function)new Function<SolrFacetProperties, String>(this){

                            public String apply(SolrFacetProperties value) {
                                return value.getFilterID();
                            }
                        });
                        List reorderedIDs = CollectionUtils.moveRight((int)relativePos, (Object)filterId, (List)facetIDs);
                        this.facetService.reorderFacets(reorderedIDs);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Moved facet " + filterId + " to relative position: " + relativePos));
                        }
                        break block10;
                    }
                    catch (Exceptions.UnrecognisedFacetId ufi) {
                        throw new WebScriptException(404, "Unrecognised filter ID: " + ufi.getFacetId());
                    }
                }
                SolrFacetProperties fp = this.parseRequestForFacetProperties(req);
                this.facetService.updateFacet(fp);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updated facet node: " + String.valueOf(fp)));
                }
            }
            catch (Throwable t) {
                throw new WebScriptException(400, "Could not update the facet configuration.", t);
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        return model;
    }

    private SolrFacetProperties parseRequestForFacetProperties(WebScriptRequest req) {
        JSONObject json = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            String filterID = json.getString(URL_PARAM_FILTER_ID);
            String facetQNameStr = this.getValue(String.class, json.opt("facetQName"), null);
            QName facetQName = facetQNameStr == null ? null : FacetQNameUtils.createQName((String)facetQNameStr, (NamespacePrefixResolver)this.namespaceService);
            String displayName = this.getValue(String.class, json.opt("displayName"), null);
            String displayControl = this.getValue(String.class, json.opt("displayControl"), null);
            int maxFilters = this.getValue(Integer.class, json.opt("maxFilters"), -1);
            int hitThreshold = this.getValue(Integer.class, json.opt("hitThreshold"), -1);
            int minFilterValueLength = this.getValue(Integer.class, json.opt("minFilterValueLength"), -1);
            String sortBy = this.getValue(String.class, json.opt("sortBy"), null);
            String scope = this.getValue(String.class, json.opt("scope"), null);
            Boolean isEnabled = this.getValue(Boolean.class, json.opt("isEnabled"), null);
            JSONArray scopedSitesJsonArray = this.getValue(JSONArray.class, json.opt("scopedSites"), null);
            Set<String> scopedSites = this.getScopedSites(scopedSitesJsonArray);
            JSONObject customPropJsonObj = this.getValue(JSONObject.class, json.opt("customProperties"), null);
            Set<SolrFacetProperties.CustomProperties> customProps = this.getCustomProperties(customPropJsonObj);
            SolrFacetProperties fp = new SolrFacetProperties.Builder().filterID(filterID).facetQName(facetQName).displayName(displayName).displayControl(displayControl).maxFilters(maxFilters).hitThreshold(hitThreshold).minFilterValueLength(minFilterValueLength).sortBy(sortBy).scope(scope).isEnabled(isEnabled).scopedSites(scopedSites).customProperties(customProps).build();
            return fp;
        }
        catch (IOException e) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)e);
        }
    }
}

