/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Hashtable;
import org.alfresco.repo.webdav.PutMethod;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServlet;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class WebDAVInsecurePostMethodTest {
    private WebDAVServlet davServlet;
    @Mock
    private WebDAVServlet.WebDAVInitParameters webDAVInitParameters;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private Hashtable<String, Class<? extends WebDAVMethod>> davMethods;

    @Before
    public void setUp() {
        this.davServlet = new WebDAVServlet();
        ReflectionTestUtils.setField((Object)this.davServlet, (String)"initParams", (Object)this.webDAVInitParameters);
        ReflectionTestUtils.setField((Object)this.davServlet, (String)"m_davMethods", this.davMethods);
        Mockito.when((Object)this.webDAVInitParameters.getEnabled()).thenReturn((Object)true);
    }

    @Test
    public void shouldReturn405StatusWhenPostMethodIsNotAllowed() throws ServletException, IOException {
        this.prepareRequest("POST");
        Mockito.when((Object)this.webDAVInitParameters.allowInsecurePOSTMethod()).thenReturn((Object)false);
        this.davServlet.service(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendError(405);
    }

    @Test
    public void shouldNotReturn405StatusWhenPostMethodIsAllowed() throws ServletException, IOException {
        this.prepareRequest("POST");
        Mockito.when((Object)this.webDAVInitParameters.allowInsecurePOSTMethod()).thenReturn((Object)true);
        this.davServlet.service(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(405);
    }

    @Test
    public void shouldNotReturn405StatusForPutMethod() throws ServletException, IOException {
        this.prepareRequest("PUT");
        this.davServlet.service(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(405);
    }

    @Test
    public void shouldNotReturn405StatusForGetMethod() throws ServletException, IOException {
        this.prepareRequest("GET");
        this.davServlet.service(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(405);
    }

    @Test
    public void shouldNotReturn405StatusForDeleteMethod() throws ServletException, IOException {
        this.prepareRequest("DELETE");
        this.davServlet.service(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(405);
    }

    private void prepareRequest(String requestMethodName) {
        ((Hashtable)Mockito.doReturn(PutMethod.class).when(this.davMethods)).get(requestMethodName);
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)requestMethodName);
    }
}

