/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.rest.api.Comments;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Comment;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TypeConstraint;

public class CommentsImpl
implements Comments {
    private static final List<String> INCLUDE_FULL_PERSON = Arrays.asList("aspectNames", "properties");
    private Nodes nodes;
    private NodeService nodeService;
    private CommentService commentService;
    private ContentService contentService;
    private TypeConstraint typeConstraint;
    private People people;

    public void setTypeConstraint(TypeConstraint typeConstraint) {
        this.typeConstraint = typeConstraint;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPeople(People people) {
        this.people = people;
    }

    private Comment toComment(NodeRef nodeRef, NodeRef commentNodeRef, List<String> include) {
        Person modifiedBy;
        Person createdBy;
        Map nodeProps = this.nodeService.getProperties(commentNodeRef);
        ContentReader reader = this.contentService.getReader(commentNodeRef, ContentModel.PROP_CONTENT);
        if (reader != null) {
            String content = reader.getContentString();
            nodeProps.put(Comment.PROP_COMMENT_CONTENT, content);
            nodeProps.remove(ContentModel.PROP_CONTENT);
        }
        Map map = this.commentService.getCommentPermissions(nodeRef, commentNodeRef);
        boolean canEdit = (Boolean)map.get("canEdit");
        boolean canDelete = (Boolean)map.get("canDelete");
        try {
            createdBy = this.people.getPerson((String)nodeProps.get(ContentModel.PROP_CREATOR), include);
        }
        catch (EntityNotFoundException enfe) {
            createdBy = new Person();
            createdBy.setUserName((String)nodeProps.get(ContentModel.PROP_CREATOR));
        }
        nodeProps.put(Comment.PROP_COMMENT_CREATED_BY, createdBy);
        try {
            modifiedBy = this.people.getPerson((String)nodeProps.get(ContentModel.PROP_MODIFIER), include);
        }
        catch (EntityNotFoundException enfe) {
            modifiedBy = new Person();
            modifiedBy.setUserName((String)nodeProps.get(ContentModel.PROP_MODIFIER));
        }
        nodeProps.put(Comment.PROP_COMMENT_MODIFIED_BY, modifiedBy);
        Comment comment = new Comment(commentNodeRef.getId(), nodeProps, canEdit, canDelete);
        return comment;
    }

    @Override
    public Comment createComment(String nodeId, Comment comment) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        if (!this.typeConstraint.matches(nodeRef)) {
            throw new UnsupportedResourceOperationException("Cannot comment on this node");
        }
        try {
            NodeRef commentNode = this.commentService.createComment(nodeRef, comment.getTitle(), comment.getContent(), false);
            return this.toComment(nodeRef, commentNode, INCLUDE_FULL_PERSON);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public Comment updateComment(String nodeId, Comment comment) {
        try {
            NodeRef nodeRef = this.nodes.validateNode(nodeId);
            String commentNodeId = comment.getId();
            NodeRef commentNodeRef = this.nodes.validateNode(commentNodeId);
            String title = comment.getTitle();
            String content = comment.getContent();
            if (content == null) {
                throw new InvalidArgumentException();
            }
            this.commentService.updateComment(commentNodeRef, title, content);
            return this.toComment(nodeRef, commentNodeRef, INCLUDE_FULL_PERSON);
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintViolatedException(e.getMessage());
        }
    }

    @Override
    public CollectionWithPagingInfo<Comment> getComments(String nodeId, Paging paging, final List<String> include) {
        final NodeRef nodeRef = this.nodes.validateNode(nodeId);
        HashSet<QName> contentAndFolders = new HashSet<QName>(Arrays.asList(ContentModel.TYPE_FOLDER, ContentModel.TYPE_CONTENT));
        if (!this.nodes.nodeMatches(nodeRef, contentAndFolders, null)) {
            throw new InvalidArgumentException("NodeId of folder or content is expected");
        }
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        PagingResults pagingResults = this.commentService.listComments(nodeRef, pagingRequest);
        final List page = pagingResults.getPage();
        AbstractList<Comment> comments = new AbstractList<Comment>(){

            @Override
            public Comment get(int index) {
                return CommentsImpl.this.toComment(nodeRef, (NodeRef)page.get(index), include);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        return CollectionWithPagingInfo.asPaged(paging, comments, pagingResults.hasMoreItems(), (Integer)pagingResults.getTotalResultCount().getFirst());
    }

    @Override
    public void deleteComment(String nodeId, String commentNodeId) {
        try {
            NodeRef nodeRef = this.nodes.validateNode(nodeId);
            NodeRef commentNodeRef = this.nodes.validateNode(commentNodeId);
            if (!nodeRef.equals((Object)this.commentService.getDiscussableAncestor(commentNodeRef))) {
                throw new InvalidArgumentException("Unexpected " + nodeId + "," + commentNodeId);
            }
            this.commentService.deleteComment(commentNodeRef);
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintViolatedException(e.getMessage());
        }
    }
}

