/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.lookups;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.api.lookups.PropertyLookup;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;

public class MimeTypePropertyLookup
implements PropertyLookup<String> {
    private Set<String> supported = new HashSet<String>();
    private ServiceRegistry serviceRegistry;

    @Override
    public String lookup(String propertyValue) {
        Map mimetypes = this.serviceRegistry.getMimetypeService().getDisplaysByMimetype();
        return (String)mimetypes.get(propertyValue);
    }

    @Override
    public Set<String> supports() {
        return this.supported;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSupported(List<String> supported) {
        this.supported.add(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"content.mimetype").toString());
        this.supported.addAll(supported);
    }
}

