/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.probes;

import org.alfresco.repo.admin.RepoHealthChecker;
import org.alfresco.rest.api.discovery.DiscoveryApiWebscript;
import org.alfresco.rest.api.model.Probe;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiNoAuth;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.ServiceUnavailableException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EntityResource(name="probes", title="Probes")
public class ProbeEntityResource
implements EntityResourceAction.ReadById<Probe> {
    public static final long CHECK_PERIOD = 10000L;
    private static final Logger logger = LoggerFactory.getLogger(ProbeEntityResource.class);
    private final Object lock = new Object();
    private final Probe liveProbe = new Probe("liveProbe: Success - Tested");
    private long lastCheckTime = 0L;
    private Boolean checkResult;
    private DiscoveryApiWebscript discovery;
    private RepoHealthChecker repoHealthChecker;

    public DiscoveryApiWebscript setDiscovery(DiscoveryApiWebscript discovery) {
        DiscoveryApiWebscript result = this.discovery;
        this.discovery = discovery;
        return result;
    }

    public void setRepoHealthChecker(RepoHealthChecker repoHealthChecker) {
        this.repoHealthChecker = repoHealthChecker;
    }

    @Override
    @WebApiDescription(title="Get probe status", description="Returns 200 if valid")
    @WebApiParam(name="probeName", title="The probe's name")
    @WebApiNoAuth
    public Probe readById(String name, Parameters parameters) {
        ProbeType probeType = ProbeType.fromString(name);
        Probe probeResponse = null;
        switch (probeType.ordinal()) {
            case 0: {
                probeResponse = this.liveProbe;
                break;
            }
            case 1: {
                String message = this.doReadyCheck();
                probeResponse = new Probe(message);
                break;
            }
            case 2: {
                throw new InvalidArgumentException("Bad probe name");
            }
        }
        return probeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doReadyCheck() {
        Object object = this.lock;
        synchronized (object) {
            String message;
            long now = System.currentTimeMillis();
            if (this.checkResult == null || this.isAfterCheckPeriod(now)) {
                try {
                    this.performReadinessCheck();
                    this.checkResult = true;
                }
                catch (Exception e) {
                    this.checkResult = false;
                    logger.debug("Exception during readiness check", (Throwable)e);
                }
                finally {
                    this.setLastCheckTime(now);
                    message = this.getMessage(this.checkResult, "Tested");
                    logger.info(message);
                }
            } else {
                message = this.getMessage(this.checkResult, "No test");
                logger.debug(message);
            }
            if (this.checkResult.booleanValue()) {
                return message;
            }
            throw new ServiceUnavailableException(message);
        }
    }

    private String getMessage(boolean result, String message) {
        return "readyProbe: " + (result ? "Success" : "Failure") + " - " + message;
    }

    private void performReadinessCheck() {
        this.discovery.getRepositoryInfo();
        this.repoHealthChecker.checkDatabase();
        logger.debug("All checks complete");
    }

    private void setLastCheckTime(long time) {
        this.lastCheckTime = time;
        long nextCheckTime = this.lastCheckTime + 10000L;
        logger.trace("nextCheckTime: {} (+{} secs)", (Object)nextCheckTime, (Object)10L);
    }

    private boolean isAfterCheckPeriod(long currentTime) {
        return currentTime - this.lastCheckTime >= 10000L;
    }

    public static enum ProbeType {
        LIVE("-live-"),
        READY("-ready-"),
        UNKNOWN("");

        String value;

        private ProbeType(String strValue) {
            this.value = strValue;
        }

        public static ProbeType fromString(String text) {
            for (ProbeType p : ProbeType.values()) {
                if (!p.value.equalsIgnoreCase(text)) continue;
                return p;
            }
            return UNKNOWN;
        }

        public String getValue() {
            return this.value;
        }
    }
}

