/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import jakarta.servlet.http.HttpServletRequest;
import org.alfresco.opencmis.BaseUrlGenerator;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.opencmis.PathGenerator;

public abstract class AbstractBaseUrlGenerator
implements BaseUrlGenerator {
    private boolean overrideContext;
    private String contextOverride;
    private boolean overrideServletPath;
    private String servletPathOverride;
    private PathGenerator pathGenerator;

    public void setPathGenerator(PathGenerator pathGenerator) {
        this.pathGenerator = pathGenerator;
    }

    public void setOverrideContext(boolean overrideContext) {
        this.overrideContext = overrideContext;
    }

    private String fixup(String urlSegment) {
        StringBuilder sb = new StringBuilder();
        int beginIndex = 0;
        int endIndex = urlSegment.length();
        if (urlSegment != null) {
            if (!urlSegment.equals("") && !urlSegment.startsWith("/")) {
                sb.append("/");
            }
            if (urlSegment.endsWith("/")) {
                --endIndex;
            }
        }
        sb.append(urlSegment.substring(beginIndex, endIndex));
        return sb.toString();
    }

    public void setContextOverride(String contextOverride) {
        this.contextOverride = this.fixup(contextOverride);
    }

    public void setOverrideServletPath(boolean overrideServletPath) {
        this.overrideServletPath = overrideServletPath;
    }

    public void setServletPathOverride(String servletPathOverride) {
        this.servletPathOverride = this.fixup(servletPathOverride);
    }

    protected abstract String getServerPath(HttpServletRequest var1);

    @Override
    public String getContextPath(HttpServletRequest httpReq) {
        if (this.overrideContext) {
            return this.contextOverride;
        }
        return httpReq.getContextPath();
    }

    @Override
    public String getServletPath(HttpServletRequest req) {
        if (this.overrideServletPath) {
            return this.servletPathOverride;
        }
        return req.getServletPath();
    }

    @Override
    public String getRequestURI(HttpServletRequest req, String repositoryId, String operation, String id) {
        int length;
        String servletPath;
        StringBuilder url = new StringBuilder();
        String contextPath = this.getContextPath(req);
        if (contextPath != null && !contextPath.equals("")) {
            url.append(contextPath);
        }
        if ((servletPath = this.getServletPath(req)) != null && !servletPath.equals("")) {
            url.append(servletPath);
            url.append("/");
        }
        if (url.length() == 0 || url.charAt(0) != '/') {
            url.append("/");
        }
        if (repositoryId != null) {
            url.append(repositoryId == null ? "-default-" : repositoryId);
            url.append("/");
        }
        if (operation != null) {
            url.append(operation);
            url.append("/");
        }
        if (id != null) {
            url.append(id);
        }
        if ((length = url.length()) > 0 && url.charAt(length - 1) == '/') {
            url.deleteCharAt(length - 1);
        }
        return url.toString();
    }

    @Override
    public String getBaseUrl(HttpServletRequest req, String repositoryId, CMISDispatcherRegistry.Binding binding) {
        String servletPath;
        StringBuilder url = new StringBuilder();
        String serverPath = this.getServerPath(req);
        url.append(serverPath);
        String contextPath = this.getContextPath(req);
        if (contextPath != null && !contextPath.equals("")) {
            url.append(contextPath);
        }
        if ((servletPath = this.getServletPath(req)) != null && !servletPath.equals("")) {
            url.append(servletPath);
            url.append("/");
        }
        if (url.length() > 0 && url.charAt(url.length() - 1) != '/') {
            url.append("/");
        }
        this.pathGenerator.generatePath(req, url, repositoryId, binding);
        return url.toString();
    }
}

