/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.Arrays;
import org.alfresco.repo.web.util.JettyComponent;
import org.alfresco.rest.api.tests.EnterpriseJettyComponent;
import org.alfresco.rest.api.tests.EnterpriseTestFixture;
import org.alfresco.rest.api.tests.RepoService;

public class EnterprisePublicApiTestFixture
extends EnterpriseTestFixture {
    public static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/web-scripts-application-context-test.xml", "rest-api-test-context.xml", "testcmis-model-context.xml"};
    public static final String[] CLASS_LOCATIONS = new String[]{"classpath*:/publicapi/lucene/"};
    private static EnterprisePublicApiTestFixture instance;
    private String[] customConfigLocations;

    public static synchronized EnterprisePublicApiTestFixture getInstance(boolean createTestData, String ... customConfigLocations) {
        if (instance == null) {
            instance = new EnterprisePublicApiTestFixture(customConfigLocations);
            try {
                instance.setup(createTestData);
            }
            catch (Exception e) {
                String errorMessage = "Exception was thrown during setup EnterprisePublicApiTestFixture: " + String.valueOf(e.getClass()) + " - " + e.getMessage();
                throw new RuntimeException(errorMessage, e);
            }
        }
        return instance;
    }

    public static EnterprisePublicApiTestFixture getInstance(String ... customConfigLocations) {
        return EnterprisePublicApiTestFixture.getInstance(true, customConfigLocations);
    }

    public static EnterprisePublicApiTestFixture getInstance() {
        return EnterprisePublicApiTestFixture.getInstance(true, null);
    }

    public static EnterprisePublicApiTestFixture getInstance(boolean createTestData) {
        return EnterprisePublicApiTestFixture.getInstance(createTestData, null);
    }

    private EnterprisePublicApiTestFixture(String ... customConfigLocations) {
        super(CONFIG_LOCATIONS, CLASS_LOCATIONS, 8765, "/alfresco", "api", 4, false);
        this.customConfigLocations = customConfigLocations;
    }

    @Override
    protected JettyComponent makeJettyComponent() {
        String[] configLocations = this.mergeLocations(this.getConfigLocations(), this.customConfigLocations);
        EnterpriseJettyComponent jettyComponent = new EnterpriseJettyComponent(this.getPort(), this.getContextPath(), configLocations, this.getClassLocations());
        return jettyComponent;
    }

    @Override
    protected RepoService makeRepoService() throws Exception {
        return new RepoService(this.applicationContext);
    }

    private String[] mergeLocations(String[] ... locations) {
        String[] mergedLocations = new String[]{};
        for (String[] location : locations) {
            if (location == null || location.length == 0) continue;
            mergedLocations = Arrays.copyOf(mergedLocations, mergedLocations.length + location.length);
            System.arraycopy(location, 0, mergedLocations, mergedLocations.length - location.length, location.length);
        }
        return mergedLocations;
    }
}

