/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.core.ResourceInspectorUtil;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.jacksonextensions.ExecutionResult;

public class SerializerOfExecutionResult
extends StdSerializer<ExecutionResult> {
    protected SerializerOfExecutionResult() {
        super(ExecutionResult.class);
    }

    public void serialize(ExecutionResult value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        SerializationConfig config = provider.getConfig();
        Object rootObj = value.getRoot();
        if (rootObj == null) {
            provider.getDefaultNullValueSerializer().serialize(null, jgen, provider);
        } else {
            Class<?> cls = rootObj.getClass();
            HashMap<String, Object> toBeSerialized = new HashMap<String, Object>();
            BeanPropertiesFilter filter = value.getFilter();
            if (filter == null) {
                filter = BeanPropertiesFilter.ALLOW_ALL;
            }
            if (Map.class.isAssignableFrom(cls)) {
                Map rootAsaMap = (Map)rootObj;
                toBeSerialized.putAll(rootAsaMap);
            } else {
                JavaType classType = config.constructType(cls);
                BeanDescription beanDesc = provider.getConfig().introspect(classType);
                List props = beanDesc.findProperties();
                for (BeanPropertyDefinition beanProperty : props) {
                    Object propertyValue;
                    if (!beanProperty.couldSerialize() || !filter.isAllowed(beanProperty.getName()) || (propertyValue = ResourceInspectorUtil.invokeMethod(beanProperty.getGetter().getAnnotated(), rootObj)) == null) continue;
                    if (propertyValue instanceof String) {
                        if (((String)propertyValue).trim().length() <= 0) continue;
                        toBeSerialized.put(beanProperty.getName(), propertyValue);
                        continue;
                    }
                    toBeSerialized.put(beanProperty.getName(), propertyValue);
                }
            }
            for (Map.Entry<String, Object> embedded : value.getEmbedded().entrySet()) {
                if (filter != null && !filter.isAllowed(embedded.getKey())) continue;
                toBeSerialized.put(embedded.getKey(), embedded.getValue());
            }
            if (value.isAnEmbeddedEntity()) {
                jgen.writeObject(toBeSerialized);
            } else {
                jgen.writeStartObject();
                jgen.writeObjectField("entry", toBeSerialized);
                if (value.getRelated() != null && !value.getRelated().isEmpty()) {
                    jgen.writeObjectField("relations", value.getRelated());
                }
                jgen.writeEndObject();
            }
        }
    }
}

