/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.ContentPropertyName;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.mapper.rules.RestRuleSimpleConditionModelMapper;
import org.alfresco.rest.api.model.rules.SimpleCondition;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RestRuleSimpleConditionModelMapperTest {
    private static final boolean NULL_RESULT = true;
    private static final String PARAMETER_DEFAULT = "value";
    @Mock
    private NamespaceService namespaceServiceMock;
    @Mock
    private Nodes nodesMock;
    @InjectMocks
    private RestRuleSimpleConditionModelMapper objectUnderTest;

    @Before
    public void setUp() throws Exception {
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes("http://www.alfresco.org/model/content/1.0")).willReturn(List.of("cm"));
        BDDMockito.given((Object)this.namespaceServiceMock.getNamespaceURI("cm")).willReturn((Object)"http://www.alfresco.org/model/content/1.0");
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes("http://www.alfresco.org/model/audio/1.0")).willReturn(List.of("audio"));
        BDDMockito.given((Object)this.namespaceServiceMock.getNamespaceURI("audio")).willReturn((Object)"http://www.alfresco.org/model/audio/1.0");
    }

    @Test
    public void testToRestModel() {
        for (TestData testData : RestRuleSimpleConditionModelMapperTest.getTestData()) {
            ActionCondition actionCondition = RestRuleSimpleConditionModelMapperTest.createActionCondition(testData.conditionDefinitionName);
            SimpleCondition actualSimpleCondition = this.objectUnderTest.toRestModel(actionCondition);
            Assertions.assertThat((boolean)Objects.isNull(actualSimpleCondition)).isEqualTo(testData.isNullResult);
            if (testData.isNullResult) continue;
            Assertions.assertThat((String)actualSimpleCondition.getField()).isNotEmpty();
            Assertions.assertThat((String)actualSimpleCondition.getComparator()).isNotEmpty();
            Assertions.assertThat((String)actualSimpleCondition.getParameter()).isNotEmpty();
        }
    }

    @Test
    public void testToRestModelFromNullValue() {
        ActionCondition actionCondition = null;
        SimpleCondition actualSimpleCondition = this.objectUnderTest.toRestModel(actionCondition);
        Assertions.assertThat((Object)actualSimpleCondition).isNull();
    }

    @Test
    public void testToRestModelFromActionConditionWithoutDefinitionName() {
        ActionConditionImpl actionCondition = new ActionConditionImpl("fake-id", null, RestRuleSimpleConditionModelMapperTest.createParameterValues());
        SimpleCondition actualSimpleCondition = this.objectUnderTest.toRestModel((ActionCondition)actionCondition);
        Assertions.assertThat((Object)actualSimpleCondition).isNull();
    }

    @Test
    public void testToRestModelFromActionConditionWithoutParameterValues() {
        ActionConditionImpl actionCondition = new ActionConditionImpl("fake-id", "fake-def-name", null);
        SimpleCondition actualSimpleCondition = this.objectUnderTest.toRestModel((ActionCondition)actionCondition);
        Assertions.assertThat((Object)actualSimpleCondition).isNull();
    }

    @Test
    public void testToRestModelListOfEmptyActionConditions() {
        List actualSimpleConditions = this.objectUnderTest.toRestModels(Collections.emptyList());
        Assertions.assertThat((List)actualSimpleConditions).isEmpty();
    }

    @Test
    public void testToRestModelListOfNullActionConditions() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.objectUnderTest.toRestModels((Collection)null));
    }

    @Test
    public void testToRestModelListOfActionConditionsContainingNull() {
        ArrayList<Object> actionConditions = new ArrayList<Object>();
        actionConditions.add(null);
        List actualSimpleConditions = this.objectUnderTest.toRestModels(actionConditions);
        Assertions.assertThat((List)actualSimpleConditions).isEmpty();
    }

    @Test
    public void testToServiceModel_withSizeContentProperty() {
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition(ContentPropertyName.SIZE.toString().toLowerCase());
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, String> expectedParameterValues = new HashMap<String, String>();
        expectedParameterValues.put("content-property", ContentPropertyName.SIZE.toString());
        expectedParameterValues.put("property", (String)ContentModel.TYPE_CONTENT);
        expectedParameterValues.put("operation", ComparePropertyValueOperation.EQUALS.toString());
        expectedParameterValues.put(PARAMETER_DEFAULT, PARAMETER_DEFAULT);
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "compare-property-value", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_withoutContentProperty() {
        String field = "cm:" + ContentModel.PROP_DESCRIPTION.toPrefixString();
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition(field);
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, Object> expectedParameterValues = new HashMap<String, Object>();
        expectedParameterValues.put("property", ContentModel.PROP_DESCRIPTION);
        expectedParameterValues.put("operation", ComparePropertyValueOperation.EQUALS.toString());
        expectedParameterValues.put(PARAMETER_DEFAULT, PARAMETER_DEFAULT);
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "compare-property-value", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id", "parameterValues.property.prefix"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_compareMimetype() {
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("mimetype");
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, Object> expectedParameterValues = new HashMap<String, Object>();
        expectedParameterValues.put("property", ContentModel.TYPE_CONTENT);
        expectedParameterValues.put(PARAMETER_DEFAULT, PARAMETER_DEFAULT);
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "compare-mime-type", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_hasAspect() {
        QName audioAspect = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"audio");
        String field = "audio:audio";
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("aspect", "audio:audio");
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, QName> expectedParameterValues = new HashMap<String, QName>();
        expectedParameterValues.put("aspect", audioAspect);
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "has-aspect", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id", "parameterValues.aspect.prefix"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_hasTag() {
        String tag = "some tag";
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("tag", "some tag");
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, String> expectedParameterValues = new HashMap<String, String>();
        expectedParameterValues.put("tag", "some tag");
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "has-tag", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_inCategory() {
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("category");
        NodeRef defaultNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, PARAMETER_DEFAULT);
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(PARAMETER_DEFAULT)).willReturn((Object)defaultNodeRef);
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, Object> expectedParameterValues = new HashMap<String, Object>();
        expectedParameterValues.put("category-aspect", ContentModel.ASPECT_GEN_CLASSIFIABLE);
        expectedParameterValues.put("category-value", defaultNodeRef);
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "in-category", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_isSubType() {
        String field = "cm:" + ContentModel.TYPE_FOLDER.toPrefixString();
        SimpleCondition simpleCondition = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("type", field);
        ActionCondition actualActionCondition = this.objectUnderTest.toServiceModel(simpleCondition);
        HashMap<String, QName> expectedParameterValues = new HashMap<String, QName>();
        expectedParameterValues.put("type", ContentModel.TYPE_FOLDER);
        ActionConditionImpl expectedActionCondition = new ActionConditionImpl(null, "is-subtype", expectedParameterValues);
        ((ObjectAssert)Assertions.assertThat((Object)actualActionCondition).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id", "parameterValues.type.prefix"}).isEqualTo((Object)expectedActionCondition);
    }

    @Test
    public void testToServiceModel_nullOrBlankParameter() {
        SimpleCondition simpleConditionNullParam = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("type", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionNullParam)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Parameter in condition must not be blank");
        SimpleCondition simpleConditionEmptyParam = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("type", " ");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionEmptyParam)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Parameter in condition must not be blank");
    }

    @Test
    public void testToServiceModel_nullOrEmptyField() {
        SimpleCondition simpleConditionNullField = RestRuleSimpleConditionModelMapperTest.createSimpleCondition(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionNullField)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Field in condition must not be blank");
        SimpleCondition simpleConditionEmptyField = RestRuleSimpleConditionModelMapperTest.createSimpleCondition("");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionEmptyField)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Field in condition must not be blank");
    }

    @Test
    public void testToServiceModel_nullOrEmptyComparatorWhenRequired() {
        SimpleCondition simpleConditionNullComparator = SimpleCondition.builder().field("size").comparator(null).parameter("65000").create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionNullComparator)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Comparator in condition must not be blank");
        SimpleCondition simpleConditionEmptyComparator = SimpleCondition.builder().field("size").comparator(" ").parameter("65000").create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionEmptyComparator)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Comparator in condition must not be blank");
    }

    @Test
    public void testToServiceModel_invalidComparator() {
        String comparator = "greaterthan";
        SimpleCondition simpleConditionNullComparator = SimpleCondition.builder().field("size").comparator("greaterthan").parameter("65000").create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectUnderTest.toServiceModel(simpleConditionNullComparator)).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining(String.format("Comparator value for condition is invalid: %s", "greaterthan"));
    }

    private static ActionCondition createActionCondition(String actionDefinitionName) {
        return new ActionConditionImpl("fake-id", actionDefinitionName, RestRuleSimpleConditionModelMapperTest.createParameterValues());
    }

    private static Map<String, Serializable> createParameterValues() {
        QName audioAspect = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"audio");
        NodeRef defaultNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, PARAMETER_DEFAULT);
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
        parameterValues.put("content-property", (Serializable)((Object)"content-property"));
        parameterValues.put("property", (Serializable)ContentModel.TYPE_CONTENT);
        parameterValues.put("operation", (Serializable)((Object)"operation"));
        parameterValues.put(PARAMETER_DEFAULT, (Serializable)((Object)PARAMETER_DEFAULT));
        parameterValues.put("aspect", (Serializable)audioAspect);
        parameterValues.put("tag", (Serializable)((Object)"tag"));
        parameterValues.put("category-aspect", (Serializable)((Object)"category-aspect"));
        parameterValues.put("category-value", (Serializable)defaultNodeRef);
        parameterValues.put("type", (Serializable)ContentModel.TYPE_FOLDER);
        return parameterValues;
    }

    private static SimpleCondition createSimpleCondition(String field) {
        return RestRuleSimpleConditionModelMapperTest.createSimpleCondition(field, PARAMETER_DEFAULT);
    }

    private static SimpleCondition createSimpleCondition(String field, String parameter) {
        return SimpleCondition.builder().field(field).comparator(ComparePropertyValueOperation.EQUALS.toString().toLowerCase()).parameter(parameter).create();
    }

    private static List<TestData> getTestData() {
        return List.of(TestData.of("compare-property-value"), TestData.of("compare-mime-type"), TestData.of("has-aspect"), TestData.of("has-child", true), TestData.of("has-tag"), TestData.of("has-version-history", true), TestData.of("in-category"), TestData.of("is-subtype"), TestData.of("no-condition", true), TestData.of("fake-definition-name", true), TestData.of("", true), TestData.of(null, true));
    }

    private static class TestData {
        String conditionDefinitionName;
        boolean isNullResult;

        public TestData(String conditionDefinitionName, boolean isNullResult) {
            this.conditionDefinitionName = conditionDefinitionName;
            this.isNullResult = isNullResult;
        }

        public static TestData of(String conditionDefinitionName) {
            return new TestData(conditionDefinitionName, false);
        }

        public static TestData of(String conditionDefinitionName, boolean isNullResult) {
            return new TestData(conditionDefinitionName, isNullResult);
        }
    }
}

