/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeComments
extends EnterpriseTestApi {
    private RepoService.TestNetwork network1;
    private RepoService.TestNetwork network2;
    private List<RepoService.TestPerson> people = new ArrayList<RepoService.TestPerson>();
    private List<RepoService.TestSite> sites = new ArrayList<RepoService.TestSite>();
    private RepoService.TestPerson person11;
    private RepoService.TestPerson person12;
    private RepoService.TestPerson person13;
    private RepoService.TestPerson person14;
    private RepoService.TestPerson person21;
    private RepoService.TestPerson person22;
    private NodeRef nodeRef1;
    private NodeRef folderNodeRef1;
    private NodeRef nodeRef2;
    private NodeRef nodeRef3;
    private NodeRef nodeRef4;
    private NodeRef cmObjectNodeRef;
    private NodeRef customTypeObject;
    private NodeRef nodeRef5;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Iterator<RepoService.TestNetwork> accountsIt = this.getTestFixture().getNetworksIt();
        this.network1 = accountsIt.next();
        this.network2 = accountsIt.next();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestNodeComments.this.network1.createUser();
                TestNodeComments.this.people.add(person);
                person = TestNodeComments.this.network1.createUser();
                TestNodeComments.this.people.add(person);
                person = TestNodeComments.this.network1.createUser();
                TestNodeComments.this.people.add(person);
                person = TestNodeComments.this.network1.createUser();
                TestNodeComments.this.people.add(person);
                return null;
            }
        }, (String)this.network1.getId());
        this.person11 = this.people.get(0);
        this.person12 = this.people.get(1);
        this.person13 = this.people.get(2);
        this.person14 = this.people.get(3);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestNodeComments.this.network2.createUser();
                TestNodeComments.this.people.add(person);
                person = TestNodeComments.this.network2.createUser();
                TestNodeComments.this.people.add(person);
                return null;
            }
        }, (String)this.network2.getId());
        this.person21 = this.people.get(4);
        this.person22 = this.people.get(5);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestSite site = TestNodeComments.this.network1.createSite(SiteVisibility.PRIVATE);
                TestNodeComments.this.sites.add(site);
                site.updateMember(TestNodeComments.this.person13.getId(), SiteRole.SiteCollaborator);
                site.updateMember(TestNodeComments.this.person14.getId(), SiteRole.SiteCollaborator);
                return null;
            }
        }, (String)this.person11.getId(), (String)this.network1.getId());
        final RepoService.TestSite site1 = this.sites.get(0);
        final ArrayList nodes = new ArrayList();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef folderNodeRef;
                NodeRef nodeRef = TestNodeComments.this.repoService.createDocument(site1.getContainerNodeRef("documentLibrary"), "Test Doc", "Test Content");
                nodes.add(nodeRef);
                nodeRef = folderNodeRef = TestNodeComments.this.repoService.createFolder(site1.getContainerNodeRef("documentLibrary"), "Test Folder");
                nodes.add(nodeRef);
                nodeRef = TestNodeComments.this.repoService.createDocument(site1.getContainerNodeRef("documentLibrary"), "Test Doc 1", "Test Content 1");
                nodes.add(nodeRef);
                nodeRef = TestNodeComments.this.repoService.createDocument(site1.getContainerNodeRef("documentLibrary"), "Test Doc 2", "Test Content 2");
                nodes.add(nodeRef);
                nodeRef = TestNodeComments.this.repoService.createDocument(site1.getContainerNodeRef("documentLibrary"), "Test Doc 3", "Test Content 3");
                nodes.add(nodeRef);
                nodeRef = TestNodeComments.this.repoService.createCmObject(site1.getContainerNodeRef("documentLibrary"), "CM Object");
                nodes.add(nodeRef);
                nodeRef = TestNodeComments.this.repoService.createObjectOfCustomType(site1.getContainerNodeRef("documentLibrary"), "Custom type object", "{custom.model}sop");
                nodes.add(nodeRef);
                nodeRef = TestNodeComments.this.repoService.createDocument(folderNodeRef, "Test Doc 4", "Test Content 4 - in Test Folder");
                nodes.add(nodeRef);
                return null;
            }
        }, (String)this.person11.getId(), (String)this.network1.getId());
        this.nodeRef1 = (NodeRef)nodes.get(0);
        this.folderNodeRef1 = (NodeRef)nodes.get(1);
        this.nodeRef2 = (NodeRef)nodes.get(2);
        this.nodeRef3 = (NodeRef)nodes.get(3);
        this.nodeRef4 = (NodeRef)nodes.get(4);
        this.cmObjectNodeRef = (NodeRef)nodes.get(5);
        this.customTypeObject = (NodeRef)nodes.get(6);
        this.nodeRef5 = (NodeRef)nodes.get(7);
    }

    @Test
    public void testNodeComments() throws Exception {
        Comment update;
        Comment comment;
        PublicApiClient.Paging expectedPaging;
        Comment comment2;
        Comment comment32;
        int maxItems;
        Comment comment4;
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        PublicApiClient.Nodes nodesProxy = this.publicApiClient.nodes();
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        try {
            comment4 = new Comment("Test Comment 4", "Test Comment 4");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            commentsProxy.createNodeComment(GUID.generate(), comment4);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12.getId()));
            comment4 = new Comment("Test Comment 4", "Test Comment 4");
            commentsProxy.createNodeComment(this.nodeRef1.getId(), comment4);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        Comment[] multiByteComments = new Comment[]{new Comment("\u06a0\u06a1\u06a2", "\u06a0\u06a1\u06a2"), new Comment("\u67e5\u770b\u5168\u90e8", "\u67e5\u770b\u5168\u90e8")};
        HashMap<String, Comment> createdComments = new HashMap<String, Comment>();
        for (Comment comment5 : multiByteComments) {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            Comment ret = commentsProxy.createNodeComment(this.nodeRef2.getId(), comment5);
            createdComments.put(ret.getId(), ret);
        }
        commentsProxy.createNodeComment(this.customTypeObject.getId(), new Comment("Custom type node comment", "The Comment"));
        try {
            commentsProxy.createNodeComment(this.cmObjectNodeRef.getId(), new Comment("CM Object node comment", "The Comment"));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount = 0;
            maxItems = 2;
            PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
            commentsProxy.getNodeComments(this.cmObjectNodeRef.getId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount = 0;
        maxItems = 2;
        Object paging = this.getPaging(skipCount, maxItems);
        Object resp = commentsProxy.getNodeComments(this.nodeRef2.getId(), this.createParams((PublicApiClient.Paging)paging, null));
        List<Comment> retComments = ((PublicApiClient.ListResponse)resp).getList();
        Assert.assertEquals((long)2L, (long)retComments.size());
        for (Comment comment32 : retComments) {
            Comment[] commentId = comment32.getId();
            Comment expectedComment = (Comment)createdComments.get(commentId);
            expectedComment.expected(comment32);
        }
        Comment[] multiByteCommentUpdates = new Comment[]{new Comment("\u04c9\u04cb\u04d0\u04de", "\u04c9\u04cb\u04d0\u04de"), new Comment("\u4e00\u4e01\u4e02\u4e03", "\u4e00\u4e01\u4e02\u4e03")};
        HashMap<String, Comment> updatedComments = new HashMap<String, Comment>();
        for (Comment comment6 : multiByteCommentUpdates) {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            Comment ret = commentsProxy.createNodeComment(this.nodeRef2.getId(), comment6);
            updatedComments.put(ret.getId(), ret);
        }
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems);
        resp = commentsProxy.getNodeComments(this.nodeRef2.getId(), this.createParams((PublicApiClient.Paging)paging, null));
        retComments = ((PublicApiClient.ListResponse)resp).getList();
        Assert.assertEquals((long)2L, (long)retComments.size());
        for (Comment comment7 : retComments) {
            String commentId = comment7.getId();
            Comment expectedComment = (Comment)updatedComments.get(commentId);
            expectedComment.expected(comment7);
        }
        comment4 = new Comment("", "?*^&*(,");
        ArrayList<Comment> expectedComments = new ArrayList<Comment>(1);
        expectedComments.add(comment4);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        commentsProxy.createNodeComment(this.nodeRef3.getId(), comment4);
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedComments.size(), expectedComments.size());
        resp = commentsProxy.getNodeComments(this.nodeRef3.getId(), this.createParams((PublicApiClient.Paging)paging, null));
        this.checkList(expectedComments.subList(skipCount, skipCount + ((PublicApiClient.Paging)paging).getExpectedPaging().getCount()), ((PublicApiClient.Paging)paging).getExpectedPaging(), resp);
        try {
            comment4 = new Comment("", "");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            commentsProxy.createNodeComment(this.nodeRef2.getId(), comment4);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        DateFormat format = PublicApiDateFormat.getDateFormat();
        expectedComments = new ArrayList(10);
        ArrayList<Comment> comments = new ArrayList<Comment>(10);
        comments.add(new Comment("Test Comment 4", "Test Comment 4"));
        comments.add(new Comment("Test Comment 1", "Test Comment 1"));
        comments.add(new Comment("Test Comment 3", "Test Comment 3"));
        comments.add(new Comment("Test Comment 2", "Test Comment 2"));
        Date time = new Date();
        for (Comment comment5 : comments) {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            Comment resp2 = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment5);
            Assert.assertEquals((Object)comment5.getContent(), (Object)resp2.getContent());
            Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)resp2.getCreatedBy().getDisplayName()));
            Assert.assertEquals((Object)resp2.getCreatedBy().getDisplayName(), (Object)this.person11.getDisplayName());
            Assert.assertTrue((boolean)format.parse(resp2.getCreatedAt()).after(time));
            this.person11.expected(resp2.getCreatedBy());
            Assert.assertNotNull((Object)resp2.getId());
            expectedComments.add(resp2);
        }
        this.repoService.generateFeed();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        paging = this.getPaging(0, Integer.MAX_VALUE);
        PublicApiClient.ListResponse<Activity> activities = peopleProxy.getActivities(this.person11.getId(), this.createParams((PublicApiClient.Paging)paging, null));
        boolean found = false;
        for (Activity activity : activities.getList()) {
            String activityType = activity.getActivityType();
            if (!activityType.equals("org.alfresco.comments.comment-created")) continue;
            Map<String, Object> summary = activity.getSummary();
            Assert.assertNotNull(summary);
            String objectId = (String)summary.get("objectId");
            Assert.assertNotNull((Object)objectId);
            if (!this.nodeRef1.getId().equals(objectId)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        try {
            comment2 = (Comment)comments.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            Comment newComment = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment2);
            expectedComments.add(newComment);
            commentsProxy.createNodeComment(newComment.getId(), comment2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            comment2 = (Comment)comments.get(0);
            Tag tag = new Tag("taggification");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            Tag addedTag = nodesProxy.createNodeTag(this.nodeRef1.getId(), tag);
            commentsProxy.createNodeComment(addedTag.getId(), comment2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        time = new Date();
        Comment comment8 = (Comment)comments.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        resp = commentsProxy.createNodeComment(this.folderNodeRef1.getId(), comment8);
        Assert.assertEquals((Object)comment8.getContent(), (Object)((Comment)resp).getContent());
        Assert.assertTrue((boolean)format.parse(((Comment)resp).getCreatedAt()).after(time));
        this.person11.expected(((Comment)resp).getCreatedBy());
        Assert.assertNotNull((Object)((Comment)resp).getId());
        Collections.sort(expectedComments);
        int skipCount2 = 0;
        int maxItems2 = 2;
        PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2, expectedComments.size(), expectedComments.size());
        Comment[] resp3 = commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(paging2, null));
        this.checkList(expectedComments.subList(skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), resp3);
        skipCount2 = 2;
        maxItems2 = 10;
        paging2 = this.getPaging(skipCount2, maxItems2, expectedComments.size(), expectedComments.size());
        resp3 = commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(paging2, null));
        this.checkList(expectedComments.subList(skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), resp3);
        try {
            skipCount2 = 0;
            maxItems2 = 2;
            expectedPaging = this.getPaging(skipCount2, maxItems2, expectedComments.size(), expectedComments.size());
            commentsProxy.getNodeComments("invalid", this.createParams(expectedPaging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = 0;
            maxItems2 = 2;
            paging2 = this.getPaging(skipCount, maxItems2, expectedComments.size(), expectedComments.size());
            commentsProxy.getNodeComments(this.nodeRef1.getId() + ";pwc", this.createParams(paging2, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        skipCount = 0;
        maxItems2 = 2;
        paging2 = this.getPaging(skipCount, maxItems2, expectedComments.size(), expectedComments.size());
        resp3 = commentsProxy.getNodeComments(this.nodeRef1.getId() + ";3.0", this.createParams(paging2, null));
        this.checkList(expectedComments.subList(skipCount, skipCount + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), resp3);
        try {
            skipCount = 0;
            maxItems2 = 2;
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12.getId()));
            expectedPaging = this.getPaging(skipCount, maxItems2, expectedComments.size(), expectedComments.size());
            commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(expectedPaging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = 0;
            maxItems2 = 2;
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21.getId()));
            expectedPaging = this.getPaging(skipCount, maxItems2, expectedComments.size(), expectedComments.size());
            commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(expectedPaging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        skipCount = 0;
        maxItems2 = 2;
        expectedPaging = this.getPaging(skipCount, maxItems2, expectedComments.size(), expectedComments.size());
        resp3 = commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(expectedPaging, null));
        List<Comment> nodeComments = resp3.getList();
        Assert.assertTrue((nodeComments.size() > 0 ? 1 : 0) != 0);
        comment32 = nodeComments.get(0);
        try {
            commentsProxy.create("nodes", this.nodeRef1.getId(), "comments", comment32.getId(), null, "Unable to POST to a node comment");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            commentsProxy.update("nodes", this.nodeRef1.getId(), "comments", null, null, "Unable to PUT node comments");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            commentsProxy.getSingle("nodes", this.nodeRef1.getId(), "comments", comment32.getId(), "Unable to GET a node comment");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            commentsProxy.remove("nodes", this.nodeRef1.getId(), "comments", null, "Unable to DELETE node comments");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        Comment[] testComments = new Comment[]{new Comment("\u04c9\u04cb\u04d0\u04de", "\u04c9\u04cb\u04d0\u04de"), new Comment("\u4e00\u4e01\u4e02\u4e03", "\u4e00\u4e01\u4e02\u4e03")};
        ArrayList<Comment> mlComments = new ArrayList<Comment>();
        mlComments.add(new Comment("\u04c9\u04cb\u04d0\u04de", "\u04c9\u04cb\u04d0\u04de"));
        mlComments.add(new Comment("\u4e00\u4e01\u4e02\u4e03", "\u4e00\u4e01\u4e02\u4e03"));
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        HashMap<String, Comment> createdComments2 = new HashMap<String, Comment>();
        for (Comment comment9 : testComments) {
            Comment ret = commentsProxy.createNodeComment(this.nodeRef4.getId(), comment9);
            createdComments2.put(ret.getId(), ret);
        }
        int i = 0;
        ArrayList<Comment> updatedComments2 = new ArrayList<Comment>();
        for (Comment comment9 : createdComments2.values()) {
            Comment updateComment = (Comment)mlComments.get(i);
            Comment ret = commentsProxy.updateNodeComment(this.nodeRef4.getId(), comment9.getId(), updateComment);
            updatedComments2.add(ret);
            ++i;
        }
        Collections.sort(updatedComments2);
        int skipCount3 = 0;
        int maxItems3 = 2;
        PublicApiClient.Paging paging3 = this.getPaging(skipCount3, maxItems3, mlComments.size(), mlComments.size());
        PublicApiClient.ListResponse<Comment> resp4 = commentsProxy.getNodeComments(this.nodeRef4.getId(), this.createParams(paging3, null));
        this.checkList(updatedComments2, paging3.getExpectedPaging(), resp4);
        try {
            comment = (Comment)expectedComments.get(1);
            update = new Comment("Test Comment 4", "Test Comment 4");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            commentsProxy.updateNodeComment(GUID.generate(), comment.getId(), update);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            Comment update2 = new Comment("Test Comment 4", "Test Comment 4");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            commentsProxy.updateNodeComment(this.nodeRef1.getId(), GUID.generate(), update2);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12.getId()));
            comment = (Comment)expectedComments.get(1);
            update = new Comment("Test Comment 4", "Test Comment 4");
            commentsProxy.updateNodeComment(this.nodeRef1.getId(), comment.getId(), update);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person22.getId()));
            comment = (Comment)expectedComments.get(1);
            update = new Comment("Test Comment 4", "Test Comment 4");
            commentsProxy.updateNodeComment(this.nodeRef1.getId(), comment.getId(), update);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        time = new Date();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        comment = (Comment)expectedComments.get(1);
        Comment update3 = new Comment("Updated comment", "Updated comment");
        Comment resp2 = commentsProxy.updateNodeComment(this.nodeRef1.getId(), comment.getId(), update3);
        Thread.sleep(100L);
        Comment expected = new Comment(comment);
        expected.setTitle("Updated comment");
        expected.setEdited(true);
        expected.setContent("Updated comment");
        expected.setModifiedBy(this.repoService.getPerson(this.person11.getId()));
        expected.setModifiedAt(PublicApiDateFormat.getDateFormat().format(time));
        expected.expected(resp2);
        try {
            comment = (Comment)expectedComments.get(1);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            commentsProxy.removeNodeComment(GUID.generate(), comment.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            commentsProxy.removeNodeComment(this.nodeRef1.getId(), GUID.generate());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        Comment toDelete = (Comment)expectedComments.get(1);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        commentsProxy.removeNodeComment(this.nodeRef1.getId(), toDelete.getId());
        int skipCount4 = 0;
        int maxItems4 = Integer.MAX_VALUE;
        PublicApiClient.Paging expectedPaging2 = this.getPaging(skipCount4, maxItems4, expectedComments.size(), expectedComments.size());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        PublicApiClient.ListResponse<Comment> resp5 = commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(expectedPaging2, null));
        List<Comment> actualComments = resp5.getList();
        Assert.assertFalse((boolean)actualComments.contains(toDelete));
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            comment = new Comment();
            comment.setContent("my comment");
            Comment createdComment = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment);
            Comment updatedComment = new Comment();
            updatedComment.setContent(null);
            commentsProxy.updateNodeComment(this.nodeRef1.getId(), createdComment.getId(), updatedComment);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        this.testSkipCountHighValue(expectedComments, commentsProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeCommentsAndLocking() throws Exception {
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        try {
            Comment updatedComment;
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    RepoService.TestSite site = TestNodeComments.this.sites.get(0);
                    site.updateMember(TestNodeComments.this.person13.getId(), SiteRole.SiteManager);
                    site.updateMember(TestNodeComments.this.person14.getId(), SiteRole.SiteManager);
                    return null;
                }
            }, (String)this.person11.getId(), (String)this.network1.getId());
            Comment comment = new Comment();
            comment.setContent("my comment");
            Comment createdComment = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestNodeComments.this.repoService.lockNode(TestNodeComments.this.nodeRef1);
                    return null;
                }
            }, (String)this.person13.getId(), (String)this.network1.getId());
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14.getId()));
            int skipCount = 0;
            int maxItems = Integer.MAX_VALUE;
            PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
            commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(paging, null));
            try {
                comment = new Comment();
                comment.setContent("my other comment");
                createdComment = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment);
                Assert.fail((String)"");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            try {
                updatedComment = new Comment();
                updatedComment.setContent("my comment");
                commentsProxy.updateNodeComment(this.nodeRef1.getId(), createdComment.getId(), updatedComment);
                Assert.fail((String)"");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            try {
                commentsProxy.removeNodeComment(this.nodeRef1.getId(), createdComment.getId());
                Assert.fail((String)"");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            try {
                comment = new Comment();
                comment.setContent("my other comment");
                createdComment = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment);
                Assert.fail((String)"");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            try {
                updatedComment = new Comment();
                updatedComment.setContent("my comment");
                commentsProxy.updateNodeComment(this.nodeRef1.getId(), createdComment.getId(), updatedComment);
                Assert.fail((String)"");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            try {
                commentsProxy.removeNodeComment(this.nodeRef1.getId(), createdComment.getId());
                Assert.fail((String)"");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13.getId()));
            commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(paging, null));
            comment = new Comment();
            comment.setContent("my other comment");
            createdComment = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment);
            updatedComment = new Comment();
            updatedComment.setContent("my comment");
            commentsProxy.updateNodeComment(this.nodeRef1.getId(), createdComment.getId(), updatedComment);
            commentsProxy.removeNodeComment(this.nodeRef1.getId(), createdComment.getId());
        }
        catch (Throwable throwable) {
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestNodeComments.this.repoService.unlockNode(TestNodeComments.this.nodeRef1);
                    return null;
                }
            }, (String)this.person13.getId(), (String)this.network1.getId());
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    RepoService.TestSite site = TestNodeComments.this.sites.get(0);
                    site.updateMember(TestNodeComments.this.person13.getId(), SiteRole.SiteCollaborator);
                    site.updateMember(TestNodeComments.this.person14.getId(), SiteRole.SiteCollaborator);
                    return null;
                }
            }, (String)this.person11.getId(), (String)this.network1.getId());
            throw throwable;
        }
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new /* invalid duplicate definition of identical inner class */, (String)this.person13.getId(), (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new /* invalid duplicate definition of identical inner class */, (String)this.person11.getId(), (String)this.network1.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeCommentsAndLockingIncludingChildren() throws Exception {
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            Comment comment = new Comment();
            comment.setContent("my comment");
            Comment createdComment = commentsProxy.createNodeComment(this.nodeRef5.getId(), comment);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestNodeComments.this.repoService.lockNode(TestNodeComments.this.folderNodeRef1, LockType.WRITE_LOCK, 0, true);
                    return null;
                }
            }, (String)this.person11.getId(), (String)this.network1.getId());
        }
        catch (Throwable throwable) {
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestNodeComments.this.repoService.unlockNode(TestNodeComments.this.folderNodeRef1, true);
                    return null;
                }
            }, (String)this.network1.getId());
            throw throwable;
        }
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new /* invalid duplicate definition of identical inner class */, (String)this.network1.getId());
    }

    @Test
    public void test_MNT_16446() throws Exception {
        Comment update;
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13.getId()));
        Comment comment = new Comment("Test Comment 1", "Test Comment 1");
        Comment resp = commentsProxy.createNodeComment(this.nodeRef1.getId(), comment);
        String commentId = resp.getId();
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14.getId()));
            update = new Comment("Test Comment 4", "Test Comment 4");
            commentsProxy.updateNodeComment(this.nodeRef1.getId(), commentId, update);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13.getId()));
        update = new Comment("Updated comment", "Updated comment");
        commentsProxy.updateNodeComment(this.nodeRef1.getId(), commentId, update);
        commentsProxy.removeNodeComment(this.nodeRef1.getId(), commentId);
    }

    public void testSkipCountHighValue(List<Comment> expectedComments, PublicApiClient.Comments commentsProxy) throws PublicApiException {
        try {
            int skipCount = 10;
            int maxItems = 2;
            PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedComments.size(), expectedComments.size());
            commentsProxy.getNodeComments(this.nodeRef1.getId(), this.createParams(paging, null));
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }
}

