/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public abstract class AbstractMailActionExecuterTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson BRITISH_USER = null;
    public static AlfrescoPerson FRENCH_USER = null;
    public static AlfrescoPerson AUSTRALIAN_USER = null;
    public static AlfrescoPerson EXTERNAL_USER = null;
    private static String ALFRESCO_EE_USER = "plainUser";
    protected static TransactionService TRANSACTION_SERVICE;
    protected static ActionService ACTION_SERVICE;
    protected static MailActionExecuter ACTION_EXECUTER;
    protected static PreferenceService PREFERENCE_SERVICE;
    protected static PersonService PERSON_SERVICE;
    protected static AuthorityService AUTHORITY_SERVICE;
    protected static NodeService NODE_SERVICE;
    protected static PermissionService PERMISSION_SERVICE;
    protected static boolean WAS_IN_TEST_MODE;

    public static void setupTests(ApplicationContext appCtx) {
        TRANSACTION_SERVICE = (TransactionService)appCtx.getBean("TransactionService", TransactionService.class);
        ACTION_SERVICE = (ActionService)appCtx.getBean("ActionService", ActionService.class);
        ACTION_EXECUTER = (MailActionExecuter)((ApplicationContextFactory)appCtx.getBean("OutboundSMTP", ApplicationContextFactory.class)).getApplicationContext().getBean("mail", MailActionExecuter.class);
        PREFERENCE_SERVICE = (PreferenceService)appCtx.getBean("PreferenceService", PreferenceService.class);
        PERSON_SERVICE = (PersonService)appCtx.getBean("PersonService", PersonService.class);
        NODE_SERVICE = (NodeService)appCtx.getBean("NodeService", NodeService.class);
        AUTHORITY_SERVICE = (AuthorityService)appCtx.getBean("AuthorityService", AuthorityService.class);
        PERMISSION_SERVICE = (PermissionService)appCtx.getBean("PermissionService", PermissionService.class);
        WAS_IN_TEST_MODE = ACTION_EXECUTER.isTestMode();
        ACTION_EXECUTER.setTestMode(true);
        AuthenticationUtil.setRunAsUserSystem();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_USERNAME, ALFRESCO_EE_USER);
        properties.put(ContentModel.PROP_EMAIL, "testemail@testdomain.com");
        PERSON_SERVICE.createPerson(properties, null);
        String tenantId = AbstractMailActionExecuterTest.getUsersHomeTenant(FRENCH_USER.getUsername());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                HashMap<String, String> preferences = new HashMap<String, String>();
                preferences.put("locale", "fr");
                PREFERENCE_SERVICE.setPreferences(FRENCH_USER.getUsername(), preferences);
                preferences.clear();
                preferences.put("locale", "en_GB");
                PREFERENCE_SERVICE.setPreferences(BRITISH_USER.getUsername(), preferences);
                preferences.clear();
                preferences.put("locale", "en_AU");
                PREFERENCE_SERVICE.setPreferences(AUSTRALIAN_USER.getUsername(), preferences);
                return null;
            }
        }, (String)tenantId);
    }

    private static String getUsersHomeTenant(String userName) {
        boolean thisIsCloud = false;
        try {
            thisIsCloud = Class.forName("org.alfresco.module.org_alfresco_module_cloud.registration.RegistrationService") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        String result = "";
        if (thisIsCloud) {
            String[] elems = userName.split("@");
            result = elems[1];
        }
        return result;
    }

    public static void tearDownTests() {
        ACTION_EXECUTER.setTestMode(WAS_IN_TEST_MODE);
        PERSON_SERVICE.deletePerson(ALFRESCO_EE_USER);
    }

    @Test
    public void testUnknownRecipientUnknownSender() throws IOException, MessagingException {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
        mailAction.setParameterValue("to", (Serializable)((Object)"some.bodyelse@example.com"));
        mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
        mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
        mailAction.setParameterValue("template_model", this.getModel());
        ACTION_SERVICE.executeAction(mailAction, null);
        MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello Jan 1, 1970", (Object)((String)message.getContent()));
    }

    @Test
    public void testUnknownRecipientUnknownSender_ToMany() throws IOException, MessagingException {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
        mailAction.setParameterValue("to_many", (Serializable)((Object)"some.bodyelse@example.com"));
        mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
        mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
        mailAction.setParameterValue("template_model", this.getModel());
        ACTION_SERVICE.executeAction(mailAction, null);
        MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello Jan 1, 1970", (Object)((String)message.getContent()));
    }

    private Serializable getModel() {
        HashMap<String, Date> model = new HashMap<String, Date>();
        model.put("epoch", new Date(0L));
        return model;
    }

    @Test
    public void testFrenchRecipient() throws IOException, MessagingException {
        String from = "some.body@example.com";
        Serializable recipients = (Serializable)((Object)Arrays.asList(FRENCH_USER.getUsername()));
        String subject = "";
        String template = "alfresco/templates/mail/test.txt.ftl";
        MimeMessage message = this.sendMessage(from, recipients, subject, template);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Bonjour 1 janv. 1970", (Object)((String)message.getContent()));
    }

    @Test
    public void testHTMLDetection() throws IOException, MessagingException {
        String from = "some.body@example.com";
        Serializable recipients = (Serializable)((Object)Arrays.asList(FRENCH_USER.getUsername()));
        String subject = "";
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("to_many", recipients);
        String text = "This is plain text\nOnly\nBut it mentions HTML and <html>";
        MimeMessage message = this.sendMessage(from, subject, null, text, mailAction);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)text, (Object)((String)message.getContent()));
        Assert.assertEquals((Object)"text/plain", (Object)message.getDataHandler().getContentType().substring(0, 10));
        text = "<html><body>HTML emails are great</body></html>";
        message = this.sendMessage(from, subject, null, text, mailAction);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)text, (Object)((String)message.getContent()));
        Assert.assertEquals((Object)"text/html", (Object)message.getDataHandler().getContentType().substring(0, 9));
        text = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<body>More complex HTML</body></html>";
        message = this.sendMessage(from, subject, null, text, mailAction);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)text, (Object)((String)message.getContent()));
        Assert.assertEquals((Object)"text/html", (Object)message.getDataHandler().getContentType().substring(0, 9));
    }

    protected MimeMessage sendMessage(String from, Serializable recipients, String subject, String template) {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("to_many", recipients);
        return this.sendMessage(from, subject, template, mailAction);
    }

    protected MimeMessage sendMessage(String from, String subject, String template, Action mailAction) {
        return this.sendMessage(from, subject, template, null, mailAction);
    }

    protected MimeMessage sendMessage(String from, String subject, String template, String bodyText, final Action mailAction) {
        if (from != null) {
            mailAction.setParameterValue("from", (Serializable)((Object)from));
        }
        mailAction.setParameterValue("subject", (Serializable)((Object)subject));
        if (template != null) {
            mailAction.setParameterValue("template", (Serializable)((Object)template));
            mailAction.setParameterValue("template_model", this.getModel());
        } else {
            mailAction.setParameterValue("text", (Serializable)((Object)bodyText));
        }
        RetryingTransactionHelper txHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        return (MimeMessage)txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<MimeMessage>(){

            public MimeMessage execute() throws Throwable {
                ACTION_SERVICE.executeAction(mailAction, null);
                return ACTION_EXECUTER.retrieveLastTestMessage();
            }
        }, true);
    }

    protected MimeMessage sendMessage(String from, String to, String subject, String template) {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("to", (Serializable)((Object)to));
        return this.sendMessage(from, subject, template, mailAction);
    }

    @Test
    public void testSendMailActionForUserNameAsRecipient() throws IOException, MessagingException {
        String from = BRITISH_USER.getUsername();
        Serializable recipients = (Serializable)((Object)Arrays.asList(ALFRESCO_EE_USER));
        String subject = "Testing";
        String template = "alfresco/templates/mail/test.txt.ftl";
        MimeMessage message = this.sendMessage(from, recipients, subject, template);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello 1 Jan 1970", (Object)((String)message.getContent()));
    }

    @Test
    public void testUnknowRecipientAustralianSender() throws IOException, MessagingException {
        String from = AUSTRALIAN_USER.getUsername();
        String to = "some.body@example.com";
        String subject = "Testing";
        String template = "alfresco/templates/mail/test.txt.ftl";
        MimeMessage message = this.sendMessage(from, to, subject, template);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"G'Day 1 Jan. 1970", (Object)((String)message.getContent()));
    }

    @Test
    public void testSendingTestMessageWithNoCurrentUser() {
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            final Action mailAction = ACTION_SERVICE.createAction("mail");
            mailAction.setParameterValue("to", (Serializable)((Object)"some.body@eaxmple.com"));
            mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("text", (Serializable)((Object)"This is a test message."));
            TRANSACTION_SERVICE.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ACTION_EXECUTER.executeImpl(mailAction, null);
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.setRunAsUserSystem();
        }
    }

    @Test
    public void testPrepareEmailForDisabledUsers() throws MessagingException {
        String groupName = null;
        try {
            this.createUser("test_user1", null);
            NodeRef userNode = this.createUser("test_user2", null);
            groupName = AUTHORITY_SERVICE.createAuthority(AuthorityType.GROUP, "testgroup1");
            AUTHORITY_SERVICE.addAuthority(groupName, "test_user1");
            AUTHORITY_SERVICE.addAuthority(groupName, "test_user2");
            NODE_SERVICE.addAspect(userNode, ContentModel.ASPECT_PERSON_DISABLED, null);
            final Action mailAction = ACTION_SERVICE.createAction("mail");
            mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
            mailAction.setParameterValue("to_many", (Serializable)((Object)groupName));
            mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("text", (Serializable)((Object)"Testing"));
            RetryingTransactionHelper txHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
            MimeMessage mm = (MimeMessage)txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<MimeMessage>(){

                public MimeMessage execute() throws Throwable {
                    return ACTION_EXECUTER.prepareEmail(mailAction, null, null, null).getMimeMessage();
                }
            }, true);
            Address[] addresses = mm.getRecipients(Message.RecipientType.TO);
            Assert.assertEquals((long)1L, (long)addresses.length);
            Assert.assertEquals((Object)"test_user1@email.com", (Object)addresses[0].toString());
        }
        catch (Throwable throwable) {
            if (groupName != null) {
                AUTHORITY_SERVICE.deleteAuthority(groupName, true);
            }
            PERSON_SERVICE.deletePerson("test_user1");
            PERSON_SERVICE.deletePerson("test_user2");
            throw throwable;
        }
        if (groupName != null) {
            AUTHORITY_SERVICE.deleteAuthority(groupName, true);
        }
        PERSON_SERVICE.deletePerson("test_user1");
        PERSON_SERVICE.deletePerson("test_user2");
    }

    @Test
    public void testPrepareEmailSubjectParams() {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("to", (Serializable)((Object)"some.bodyelse@example.com"));
        mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
        mailAction.setParameterValue("subject", (Serializable)((Object)"Test Subject Params"));
        mailAction.setParameterValue("template_model", this.getModel());
        Pair recipient = new Pair((Object)"test", (Object)Locale.ENGLISH);
        mailAction.setParameterValue("subjectParams", (Serializable)new Object[]{"Test", "Subject", "Params", "Object", "Array"});
        Assert.assertNotNull((String)"We should support Object[] value for PARAM_SUBJECT_PARAMS", (Object)ACTION_EXECUTER.prepareEmail(mailAction, null, recipient, null));
        ArrayList<String> params = new ArrayList<String>();
        params.add("Test");
        params.add("Subject");
        params.add("Params");
        params.add("ArrayList");
        mailAction.setParameterValue("subjectParams", params);
        Assert.assertNotNull((String)"We should support List<Object> value for PARAM_SUBJECT_PARAMS", (Object)ACTION_EXECUTER.prepareEmail(mailAction, null, recipient, null));
        mailAction.setParameterValue("subjectParams", (Serializable)((Object)"Test Subject Params Single String"));
        Assert.assertNotNull((String)"We should support String value for PARAM_SUBJECT_PARAMS", (Object)ACTION_EXECUTER.prepareEmail(mailAction, null, recipient, null));
        mailAction.setParameterValue("subjectParams", null);
        Assert.assertNotNull((String)"We should support null value for PARAM_SUBJECT_PARAMS", (Object)ACTION_EXECUTER.prepareEmail(mailAction, null, recipient, null));
    }

    private NodeRef createUser(String userName, String email) {
        PropertyMap personProps = new PropertyMap();
        personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)userName);
        if (email != null) {
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)email);
        } else {
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(userName) + "@email.com"));
        }
        return PERSON_SERVICE.createPerson((Map)personProps);
    }

    @Test
    public void testUserWithNonExistingTenant() throws Exception {
        try {
            this.createUser("test_user_non_tenant@non_existing_tenant.com", "test_user_non_tenant@non_existing_tenant.com");
            final Action mailAction = ACTION_SERVICE.createAction("mail");
            mailAction.setParameterValue("to", (Serializable)((Object)"test_user_non_tenant@non_existing_tenant.com"));
            mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("text", (Serializable)((Object)"This is a test message."));
            AuthenticationUtil.setFullyAuthenticatedUser((String)BRITISH_USER.getUsername());
            TRANSACTION_SERVICE.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ACTION_EXECUTER.executeImpl(mailAction, null);
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.setRunAsUserSystem();
            PERSON_SERVICE.deletePerson("test_user_non_tenant@non_existing_tenant.com");
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    @Test
    public void testSendingToMultipleUsers() throws IOException, MessagingException {
        String[] recipientsArray = new String[]{"recipient1@email.com", "recipient2@email.com"};
        ArrayList<String> recipientsResult = new ArrayList<String>(Arrays.asList(recipientsArray));
        try {
            this.createUser("recipient1", null);
            this.createUser("recipient2", null);
            ArrayList<String> recipients = new ArrayList<String>(2);
            recipients.add("recipient1");
            recipients.add("recipient2");
            Action mailAction = ACTION_SERVICE.createAction("mail");
            mailAction.setParameterValue("from", (Serializable)((Object)"sender@example.com"));
            mailAction.setParameterValue("to_many", recipients);
            mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("template_model", this.getModel());
            ACTION_EXECUTER.resetTestSentCount();
            ACTION_SERVICE.executeAction(mailAction, null);
            MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((String)"One email should be sent", (long)1L, (long)ACTION_EXECUTER.getTestSentCount());
            Assert.assertEquals((String)"All recipients should receive single message", (long)2L, (long)message.getAllRecipients().length);
            Assert.assertTrue((String)"Both users should receive message", (boolean)recipientsResult.contains(((InternetAddress)message.getAllRecipients()[0]).getAddress()));
            Assert.assertTrue((String)"Both users should receive message", (boolean)recipientsResult.contains(((InternetAddress)message.getAllRecipients()[1]).getAddress()));
        }
        finally {
            PERSON_SERVICE.deletePerson("recipient1");
            PERSON_SERVICE.deletePerson("recipient2");
        }
    }

    @Test
    public void testSendingToCarbonCopy() throws IOException, MessagingException {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
        mailAction.setParameterValue("to", (Serializable)((Object)"some.bodyelse@example.com"));
        mailAction.setParameterValue("cc", (Serializable)((Object)"some.carbon@example.com"));
        mailAction.setParameterValue("bcc", (Serializable)((Object)"some.blindcarbon@example.com"));
        mailAction.setParameterValue("subject", (Serializable)((Object)"Testing CARBON COPY"));
        mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
        mailAction.setParameterValue("template_model", this.getModel());
        ACTION_SERVICE.executeAction(mailAction, null);
        MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
        Assert.assertNotNull((Object)message);
        Address[] all = message.getAllRecipients();
        Address[] ccs = message.getRecipients(Message.RecipientType.CC);
        Address[] bccs = message.getRecipients(Message.RecipientType.BCC);
        Assert.assertEquals((long)3L, (long)all.length);
        Assert.assertEquals((long)1L, (long)ccs.length);
        Assert.assertEquals((long)1L, (long)bccs.length);
        Assert.assertTrue((boolean)ccs[0].toString().contains("some.carbon"));
        Assert.assertTrue((boolean)bccs[0].toString().contains("some.blindcarbon"));
    }

    @Test
    public void testSendingToUserWithMailAlikeName() throws IOException, MessagingException {
        try {
            this.createUser("user1@namelookslikeemail", "user1@trueemail.com");
            Action mailAction = ACTION_SERVICE.createAction("mail");
            mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
            mailAction.setParameterValue("to_many", (Serializable)((Object)"user1@namelookslikeemail"));
            mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
            mailAction.setParameterValue("template_model", this.getModel());
            ACTION_SERVICE.executeAction(mailAction, null);
            MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)"Hello Jan 1, 1970", (Object)((String)message.getContent()));
            Assert.assertEquals((long)1L, (long)message.getAllRecipients().length);
            InternetAddress address = (InternetAddress)message.getAllRecipients()[0];
            Assert.assertEquals((Object)"user1@trueemail.com", (Object)address.getAddress());
        }
        finally {
            PERSON_SERVICE.deletePerson("user1@namelookslikeemail");
        }
    }

    @Test
    public void testMultipleIdenticalEmailsToUser() throws Exception {
        String[] users = new String[]{"user12464_1", "user12464_2", "user12464_3", "user12464_4@mnt12464mail.com", "user12464_5@mnt12464mail.com"};
        try {
            this.createUser("user12464_1", null);
            this.createUser("user12464_2", null);
            this.createUser("user12464_3", null);
            AUTHORITY_SERVICE.createAuthority(AuthorityType.GROUP, "mnt12464group1");
            AUTHORITY_SERVICE.createAuthority(AuthorityType.GROUP, "mnt12464group2");
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group1", "user12464_1");
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group1", "user12464_2");
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group2", "user12464_1");
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group2", "user12464_2");
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group2", "user12464_3");
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)"user12464_4@mnt12464mail.com");
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"user12464_4@mnt12464mail.com");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"user12464_4@mnt12464mail.com");
            PERSON_SERVICE.createPerson((Map)personProps);
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group1", "user12464_4@mnt12464mail.com");
            AUTHORITY_SERVICE.addAuthority("GROUP_mnt12464group2", "user12464_4@mnt12464mail.com");
            personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)"user12464_5@mnt12464mail.com");
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"user12464_5@mnt12464mail.com");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"user12464_5@mnt12464mail.com");
            PERSON_SERVICE.createPerson((Map)personProps);
            Action mailAction1 = ACTION_SERVICE.createAction("mail");
            mailAction1.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
            ArrayList<String> toMany1 = new ArrayList<String>();
            toMany1.add("user12464_1");
            toMany1.add("GROUP_mnt12464group1");
            toMany1.add("user12464_2");
            toMany1.add("GROUP_mnt12464group2");
            toMany1.add("user12464_3");
            toMany1.add("user12464_4@mnt12464mail.com");
            toMany1.add("user12464_5@mnt12464mail.com");
            mailAction1.setParameterValue("to_many", toMany1);
            mailAction1.setParameterValue("subject", (Serializable)((Object)"Testing MNT-12464"));
            mailAction1.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
            mailAction1.setParameterValue("template_model", this.getModel());
            ACTION_EXECUTER.resetTestSentCount();
            ACTION_SERVICE.executeAction(mailAction1, null);
            Assert.assertEquals((String)"Must be received one letter on each recipient", (long)users.length, (long)ACTION_EXECUTER.getTestSentCount());
            ACTION_EXECUTER.resetTestSentCount();
            this.everyoneSending();
            int before = ACTION_EXECUTER.getTestSentCount();
            NodeRef user6 = this.createUser("user12464_6", null);
            PERMISSION_SERVICE.setInheritParentPermissions(user6, false);
            PERMISSION_SERVICE.deletePermissions(user6);
            int after = (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

                public Integer doWork() throws Exception {
                    ACTION_EXECUTER.resetTestSentCount();
                    AbstractMailActionExecuterTest.this.everyoneSending();
                    return ACTION_EXECUTER.getTestSentCount();
                }
            }, (String)"user12464_1");
            Assert.assertEquals((String)"One additional user was created, quantity of recipients GROUP_EVERYONE must be +1 user", (long)1L, (long)(after - before));
        }
        finally {
            PERSON_SERVICE.deletePerson("user12464_1");
            PERSON_SERVICE.deletePerson("user12464_2");
            PERSON_SERVICE.deletePerson("user12464_3");
            PERSON_SERVICE.deletePerson("user12464_4@mnt12464mail.com");
            PERSON_SERVICE.deletePerson("user12464_5@mnt12464mail.com");
            PERSON_SERVICE.deletePerson("user12464_6");
            AUTHORITY_SERVICE.deleteAuthority("GROUP_mnt12464group1");
            AUTHORITY_SERVICE.deleteAuthority("GROUP_mnt12464group2");
        }
    }

    private void everyoneSending() {
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
        ArrayList<String> toMany = new ArrayList<String>();
        toMany.add(PERMISSION_SERVICE.getAllAuthorities());
        mailAction.setParameterValue("to_many", toMany);
        mailAction.setParameterValue("subject", (Serializable)((Object)"Testing MNT-12464"));
        mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
        mailAction.setParameterValue("template_model", this.getModel());
        ACTION_EXECUTER.resetTestSentCount();
        ACTION_SERVICE.executeAction(mailAction, null);
    }

    @Test
    public void testSendEmailByExternalUser() throws IOException, MessagingException {
        final Serializable recipients = (Serializable)((Object)Arrays.asList(BRITISH_USER.getUsername()));
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)EXTERNAL_USER.getUsername());
        MimeMessage message = null;
        try {
            String tenantId = AbstractMailActionExecuterTest.getUsersHomeTenant(BRITISH_USER.getUsername());
            message = (MimeMessage)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<MimeMessage>(){

                public MimeMessage doWork() throws Exception {
                    return AbstractMailActionExecuterTest.this.sendMessage(null, recipients, "", "alfresco/templates/mail/test.txt.ftl");
                }
            }, (String)tenantId);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)"Hello 1 Jan 1970", (Object)((String)message.getContent()));
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testGetToUsersWhenSendingToGroup() throws IOException, MessagingException {
        String groupName = null;
        try {
            this.createUser("test_user1", null);
            this.createUser("test_user2", null);
            groupName = AUTHORITY_SERVICE.createAuthority(AuthorityType.GROUP, "testgroup1");
            AUTHORITY_SERVICE.addAuthority(groupName, "test_user1");
            AUTHORITY_SERVICE.addAuthority(groupName, "test_user2");
            final Action mailAction = ACTION_SERVICE.createAction("mail");
            mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
            mailAction.setParameterValue("to_many", (Serializable)((Object)groupName));
            mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("text", (Serializable)((Object)"Testing"));
            mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/testSentTo.txt.ftl"));
            RetryingTransactionHelper txHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
            MimeMessage message = (MimeMessage)txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<MimeMessage>(){

                public MimeMessage execute() throws Throwable {
                    ACTION_EXECUTER.executeImpl(mailAction, null);
                    return ACTION_EXECUTER.retrieveLastTestMessage();
                }
            }, true);
            String recipients = "test_user1@email.com,test_user2@email.com";
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)("This email was sent to " + recipients), (Object)((String)message.getContent()));
        }
        catch (Throwable throwable) {
            if (groupName != null) {
                AUTHORITY_SERVICE.deleteAuthority(groupName, true);
            }
            PERSON_SERVICE.deletePerson("test_user1");
            PERSON_SERVICE.deletePerson("test_user2");
            throw throwable;
        }
        if (groupName != null) {
            AUTHORITY_SERVICE.deleteAuthority(groupName, true);
        }
        PERSON_SERVICE.deletePerson("test_user1");
        PERSON_SERVICE.deletePerson("test_user2");
    }

    @Test
    public void testSendingToArrayOfCarbonCopyAndBlindCarbonCopyUsers() throws MessagingException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] ccArray = new String[]{"cc_user1@example.com", "cc_user2@example.com"};
        String[] bccArray = new String[]{"bcc_user3@example.com", "bcc_user4@example.com", "bcc_user5@example.com"};
        params.put("from", "sender@email.com");
        params.put("to", "test@email.com");
        params.put("cc", ccArray);
        params.put("bcc", bccArray);
        params.put("text", "Mail body here");
        params.put("subject", "Subject text");
        Action mailAction = ACTION_SERVICE.createAction("mail", params);
        ACTION_EXECUTER.resetTestSentCount();
        ACTION_SERVICE.executeAction(mailAction, null);
        MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
        Assert.assertNotNull((Object)message);
        Address[] all = message.getAllRecipients();
        Address[] ccs = message.getRecipients(Message.RecipientType.CC);
        Address[] bccs = message.getRecipients(Message.RecipientType.BCC);
        Assert.assertEquals((long)6L, (long)all.length);
        Assert.assertEquals((long)2L, (long)ccs.length);
        Assert.assertEquals((long)3L, (long)bccs.length);
        Assert.assertTrue((ccs[0].toString().contains("cc_user1") && ccs[1].toString().contains("cc_user2") ? 1 : 0) != 0);
        Assert.assertTrue((bccs[0].toString().contains("bcc_user3") && bccs[1].toString().contains("bcc_user4") && bccs[2].toString().contains("bcc_user5") ? 1 : 0) != 0);
    }

    @Test
    public void testSendingToListOfCarbonCopyAndBlindCarbonCopyUsers() throws MessagingException {
        ArrayList<String> ccList = new ArrayList<String>();
        ccList.add("cc_user1@example.com");
        ccList.add("cc_user2@example.com");
        ArrayList<String> bccList = new ArrayList<String>();
        bccList.add("bcc_user3@example.com");
        bccList.add("bcc_user4@example.com");
        bccList.add("bcc_user5@example.com");
        Action mailAction = ACTION_SERVICE.createAction("mail");
        mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
        mailAction.setParameterValue("to", (Serializable)((Object)"some.bodyelse@example.com"));
        mailAction.setParameterValue("cc", (Serializable)ccList);
        mailAction.setParameterValue("bcc", (Serializable)bccList);
        mailAction.setParameterValue("subject", (Serializable)((Object)"Testing (BLIND) CARBON COPY"));
        mailAction.setParameterValue("text", (Serializable)((Object)"mail body here"));
        ACTION_EXECUTER.resetTestSentCount();
        ACTION_SERVICE.executeAction(mailAction, null);
        MimeMessage message = ACTION_EXECUTER.retrieveLastTestMessage();
        Assert.assertNotNull((Object)message);
        Address[] all = message.getAllRecipients();
        Address[] ccs = message.getRecipients(Message.RecipientType.CC);
        Address[] bccs = message.getRecipients(Message.RecipientType.BCC);
        Assert.assertEquals((long)6L, (long)all.length);
        Assert.assertEquals((long)2L, (long)ccs.length);
        Assert.assertEquals((long)3L, (long)bccs.length);
        Assert.assertTrue((ccs[0].toString().contains("cc_user1") && ccs[1].toString().contains("cc_user2") ? 1 : 0) != 0);
        Assert.assertTrue((bccs[0].toString().contains("bcc_user3") && bccs[1].toString().contains("bcc_user4") && bccs[2].toString().contains("bcc_user5") ? 1 : 0) != 0);
    }
}

