/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.TakeOwnershipActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={OwnJVMTestsCategory.class, NeverRunsTests.class})
public class TakeOwnershipActionExecuterTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static final String USER_ONE_NAME = "UserOne";
    public static final String USER_TWO_NAME = "UserTwo";
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserOne");
    public static TemporarySites TEMP_SITES = new TemporarySites(APP_CONTEXT_INIT);
    public static TemporaryNodes TEMP_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain STATIC_RULE_CHAIN = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1).around((TestRule)TEMP_NODES).around((TestRule)TEMP_SITES);
    @Rule
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(TEST_USER1);
    private static OwnableService OWNABLE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static TemporarySites.TestSiteAndMemberInfo SITE_INFO;
    private static NodeRef TEST_DOC;

    @BeforeClass
    public static void initStaticData() throws Exception {
        OWNABLE_SERVICE = (OwnableService)APP_CONTEXT_INIT.getApplicationContext().getBean("OwnableService", OwnableService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        String siteShortName = GUID.generate();
        SITE_INFO = TEMP_SITES.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, TEST_USER1.getUsername());
        TEST_DOC = TEMP_NODES.createNode(TakeOwnershipActionExecuterTest.SITE_INFO.doclib, "userOnesDoc", ContentModel.TYPE_CONTENT, TakeOwnershipActionExecuterTest.SITE_INFO.siteContributor);
    }

    @Test
    public void siteOwnerCanTakeOwnershipOfNodeViaAnAction() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((String)"Wrong owner at test start.", (Object)SITE_INFO.siteContributor, (Object)OWNABLE_SERVICE.getOwner(TEST_DOC));
                Assert.assertEquals((Object)TEST_USER1.getUsername(), (Object)AuthenticationUtil.getRunAsUser());
                TakeOwnershipActionExecuter executor = (TakeOwnershipActionExecuter)APP_CONTEXT_INIT.getApplicationContext().getBean("take-ownership", TakeOwnershipActionExecuter.class);
                String actionId = GUID.generate();
                ActionImpl action = new ActionImpl(null, actionId, "take-ownership", null);
                executor.execute((Action)action, TEST_DOC);
                Assert.assertEquals((String)"Wrong owner at test end.", (Object)TEST_USER1.getUsername(), (Object)OWNABLE_SERVICE.getOwner(TEST_DOC));
                return null;
            }
        });
    }
}

