/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.calendar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.calendar.CalendarServiceImpl;
import org.alfresco.repo.calendar.cannedqueries.CalendarEntity;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQuery;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQueryFactory;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQueryTestHook;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.calendar.CalendarService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class CalendarServiceImplTest {
    private static final String TEST_SITE_PREFIX = "CalendarSiteTest";
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static CalendarService CALENDAR_SERVICE;
    private static DictionaryService DICTIONARY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static NodeService PUBLIC_NODE_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static PermissionService PERMISSION_SERVICE;
    private static SiteService SITE_SERVICE;
    @Mock
    private static TaggingService TAGGING_SERVICE;
    private static GetCalendarEntriesCannedQueryFactory CALENDAR_CQ_FACTORY;
    private static final String TEST_USER;
    private static final String ADMIN_USER;
    private static SiteInfo CALENDAR_SITE;
    private static SiteInfo ALTERNATE_CALENDAR_SITE;
    private List<NodeRef> testNodesToTidy = new ArrayList<NodeRef>();
    private static List<NodeRef> CLASS_TEST_NODES_TO_TIDY;

    static {
        TEST_USER = String.valueOf(CalendarServiceImplTest.class.getSimpleName()) + "_testuser";
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        CLASS_TEST_NODES_TO_TIDY = new ArrayList<NodeRef>();
    }

    @BeforeClass
    public static void initTestsContext() throws Exception {
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)testContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        CALENDAR_SERVICE = (CalendarService)testContext.getBean("CalendarService");
        DICTIONARY_SERVICE = (DictionaryService)testContext.getBean("dictionaryService");
        NODE_SERVICE = (NodeService)testContext.getBean("nodeService");
        PUBLIC_NODE_SERVICE = (NodeService)testContext.getBean("NodeService");
        PERSON_SERVICE = (PersonService)testContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        PERMISSION_SERVICE = (PermissionService)testContext.getBean("permissionService");
        SITE_SERVICE = (SiteService)testContext.getBean("SiteService");
        NamedObjectRegistry calendarCannedQueryRegistry = (NamedObjectRegistry)testContext.getBean("calendarCannedQueryRegistry");
        CALENDAR_CQ_FACTORY = (GetCalendarEntriesCannedQueryFactory)calendarCannedQueryRegistry.getNamedObject("calendarGetCalendarEntriesCannedQueryFactory");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        CalendarServiceImplTest.createUser(TEST_USER);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        CalendarServiceImplTest.createTestSites();
    }

    @Before
    public void before() {
        ((CalendarServiceImpl)testContext.getBean("calendarService")).setTaggingService(TAGGING_SERVICE);
        Mockito.when((Object)TAGGING_SERVICE.isTagScope((NodeRef)Matchers.any(NodeRef.class))).thenReturn((Object)true);
    }

    @Test
    public void createNewEntry() throws Exception {
        PagingResults results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        CalendarEntry entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), "madeUp");
        Assert.assertEquals(null, (Object)entry);
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), "madeUp2");
        Assert.assertEquals(null, (Object)entry);
        entry = new CalendarEntryDTO("Title", "Description", "Location", new Date(1L), new Date(1234L));
        entry.setOutlook(true);
        entry.setOutlookUID("12345LookOut!");
        Assert.assertEquals(null, (Object)entry.getSystemName());
        Assert.assertEquals(null, (Object)entry.getNodeRef());
        try {
            CALENDAR_SERVICE.updateCalendarEntry(entry);
            Assert.fail((String)"Shouldn't be able to update a brand new entry");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        entry = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), entry);
        Assert.assertNotNull((Object)entry.getNodeRef());
        Assert.assertNotNull((Object)entry.getSystemName());
        NodeRef container = PUBLIC_NODE_SERVICE.getPrimaryParent(entry.getNodeRef()).getParentRef();
        NodeRef site = PUBLIC_NODE_SERVICE.getPrimaryParent(container).getParentRef();
        Assert.assertEquals((Object)CALENDAR_SITE.getNodeRef(), (Object)site);
        this.testNodesToTidy.add(entry.getNodeRef());
        Assert.assertEquals((Object)"Title", (Object)entry.getTitle());
        Assert.assertEquals((Object)"Description", (Object)entry.getDescription());
        Assert.assertEquals((Object)"Location", (Object)entry.getLocation());
        Assert.assertEquals((long)1L, (long)entry.getStart().getTime());
        Assert.assertEquals((long)1234L, (long)entry.getEnd().getTime());
        Assert.assertEquals(null, (Object)entry.getRecurrenceRule());
        Assert.assertEquals(null, (Object)entry.getLastRecurrence());
        Assert.assertEquals((Object)true, (Object)entry.isOutlook());
        Assert.assertEquals((Object)"12345LookOut!", (Object)entry.getOutlookUID());
        Assert.assertNotNull((Object)entry.getCreatedAt());
        Assert.assertNotNull((Object)entry.getModifiedAt());
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((Object)"Title", (Object)entry.getTitle());
        Assert.assertEquals((Object)"Description", (Object)entry.getDescription());
        Assert.assertEquals((Object)"Location", (Object)entry.getLocation());
        Assert.assertEquals((long)1L, (long)entry.getStart().getTime());
        Assert.assertEquals((long)1234L, (long)entry.getEnd().getTime());
        Assert.assertEquals(null, (Object)entry.getRecurrenceRule());
        Assert.assertEquals(null, (Object)entry.getLastRecurrence());
        Assert.assertEquals((Object)true, (Object)entry.isOutlook());
        Assert.assertEquals((Object)"12345LookOut!", (Object)entry.getOutlookUID());
        Assert.assertNotNull((Object)entry.getCreatedAt());
        Assert.assertNotNull((Object)entry.getModifiedAt());
    }

    @Test
    public void createUpdateDeleteEntry() throws Exception {
        CalendarEntryDTO entry = new CalendarEntryDTO("Title", "Description", "Location", new Date(1L), new Date(1234L));
        entry.setOutlook(true);
        entry.setOutlookUID("12345LookOut!");
        entry = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)entry);
        Assert.assertEquals((Object)"Title", (Object)entry.getTitle());
        Assert.assertEquals((Object)"Description", (Object)entry.getDescription());
        Assert.assertEquals((Object)"Location", (Object)entry.getLocation());
        Assert.assertEquals((long)1L, (long)entry.getStart().getTime());
        Assert.assertEquals((long)1234L, (long)entry.getEnd().getTime());
        Assert.assertEquals(null, (Object)entry.getRecurrenceRule());
        Assert.assertEquals(null, (Object)entry.getLastRecurrence());
        Assert.assertEquals((Object)true, (Object)entry.isOutlook());
        Assert.assertEquals((Object)"12345LookOut!", (Object)entry.getOutlookUID());
        entry.setTitle("New Title");
        entry.setStart(new Date(1234567L));
        entry.setEnd(new Date(1294567L));
        entry.setRecurrenceRule("1w");
        entry.setLastRecurrence(new Date(1234567L));
        entry.setOutlook(false);
        entry.setOutlookUID(null);
        CALENDAR_SERVICE.updateCalendarEntry((CalendarEntry)entry);
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((Object)"New Title", (Object)entry.getTitle());
        Assert.assertEquals((Object)"Description", (Object)entry.getDescription());
        Assert.assertEquals((Object)"Location", (Object)entry.getLocation());
        Assert.assertEquals((long)1234567L, (long)entry.getStart().getTime());
        Assert.assertEquals((long)1294567L, (long)entry.getEnd().getTime());
        Assert.assertEquals((Object)"1w", (Object)entry.getRecurrenceRule());
        Assert.assertEquals((long)1234567L, (long)entry.getLastRecurrence().getTime());
        Assert.assertEquals((Object)false, (Object)entry.isOutlook());
        Assert.assertEquals(null, (Object)entry.getOutlookUID());
        CALENDAR_SERVICE.deleteCalendarEntry((CalendarEntry)entry);
        Assert.assertEquals(null, (Object)CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName()));
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Assert.assertEquals((Object)false, (Object)CalendarEntryDTO.isAllDay((CalendarEntry)entry));
        entry.setStart(c.getTime());
        Assert.assertEquals((Object)false, (Object)CalendarEntryDTO.isAllDay((CalendarEntry)entry));
        entry.setEnd(c.getTime());
        Assert.assertEquals((Object)true, (Object)CalendarEntryDTO.isAllDay((CalendarEntry)entry));
    }

    @Test
    public void newContainerSetup() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (SITE_SERVICE.getSite("CalendarTestNewTestSite") != null) {
                    SITE_SERVICE.deleteSite("CalendarTestNewTestSite");
                }
                SITE_SERVICE.createSite(CalendarServiceImplTest.TEST_SITE_PREFIX, "CalendarTestNewTestSite", "Test", "Test", SiteVisibility.PUBLIC);
                Assert.assertFalse((boolean)SITE_SERVICE.hasContainer("CalendarTestNewTestSite", "calendar"));
                CalendarEntryDTO entry = new CalendarEntryDTO("Title", "Description", "Location", new Date(1L), new Date(1234L));
                CALENDAR_SERVICE.createCalendarEntry("CalendarTestNewTestSite", (CalendarEntry)entry);
                Assert.assertTrue((boolean)SITE_SERVICE.hasContainer("CalendarTestNewTestSite", "calendar"));
                NodeRef container = SITE_SERVICE.getContainer("CalendarTestNewTestSite", "calendar");
                Assert.assertTrue((boolean)TAGGING_SERVICE.isTagScope(container));
                SITE_SERVICE.deleteSite("CalendarTestNewTestSite");
                return null;
            }
        });
    }

    @Test
    public void tagging() throws Exception {
        CalendarEntryDTO entry = new CalendarEntryDTO("Title", "Description", "Location", new Date(1L), new Date(1234L));
        entry = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)entry);
        this.testNodesToTidy.add(entry.getNodeRef());
        Assert.assertEquals((long)0L, (long)entry.getTags().size());
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)0L, (long)entry.getTags().size());
        entry.getTags().add("calendar_tag_1");
        entry.getTags().add("calendar_tag_2");
        entry.getTags().add("calendar_tag_1");
        Assert.assertEquals((long)3L, (long)entry.getTags().size());
        CALENDAR_SERVICE.updateCalendarEntry((CalendarEntry)entry);
        Mockito.when((Object)TAGGING_SERVICE.getTags(entry.getNodeRef())).thenReturn(Arrays.asList("calendar_tag_1", "calendar_tag_2"));
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)2L, (long)entry.getTags().size());
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_1"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_2"));
        Assert.assertEquals((Object)false, (Object)entry.getTags().contains("calendar_tag_3"));
        entry.getTags().remove("calendar_tag_2");
        entry.getTags().add("calendar_tag_3");
        entry.getTags().add("calendar_tag_1");
        CALENDAR_SERVICE.updateCalendarEntry((CalendarEntry)entry);
        Assert.assertEquals((long)3L, (long)entry.getTags().size());
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_1"));
        Assert.assertEquals((Object)false, (Object)entry.getTags().contains("calendar_tag_2"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_3"));
        Mockito.when((Object)TAGGING_SERVICE.getTags(entry.getNodeRef())).thenReturn(Arrays.asList("calendar_tag_1", "calendar_tag_3"));
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)2L, (long)entry.getTags().size());
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_1"));
        Assert.assertEquals((Object)false, (Object)entry.getTags().contains("calendar_tag_2"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_3"));
        entry.getTags().clear();
        CALENDAR_SERVICE.updateCalendarEntry((CalendarEntry)entry);
        Mockito.when((Object)TAGGING_SERVICE.getTags(entry.getNodeRef())).thenReturn((Object)Collections.EMPTY_LIST);
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)0L, (long)entry.getTags().size());
        entry.getTags().add("calendar_tag_1");
        entry.getTags().add("calendar_tag_2");
        entry.getTags().add("calendar_tag_3");
        CALENDAR_SERVICE.updateCalendarEntry((CalendarEntry)entry);
        Mockito.when((Object)TAGGING_SERVICE.getTags(entry.getNodeRef())).thenReturn(Arrays.asList("calendar_tag_1", "calendar_tag_2", "calendar_tag_3"));
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)3L, (long)entry.getTags().size());
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_1"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_2"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_3"));
        CALENDAR_SERVICE.deleteCalendarEntry((CalendarEntry)entry);
        entry = new CalendarEntryDTO("Title", "Description", "Location", new Date(1L), new Date(1234L));
        entry.getTags().add("calendar_tag_1");
        entry.getTags().add("calendar_tag_1");
        entry.getTags().add("calendar_tag_2");
        entry = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)entry);
        this.testNodesToTidy.add(entry.getNodeRef());
        Mockito.when((Object)TAGGING_SERVICE.getTags(entry.getNodeRef())).thenReturn(Arrays.asList("calendar_tag_1", "calendar_tag_2"));
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)2L, (long)entry.getTags().size());
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_1"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_2"));
        Assert.assertEquals((Object)false, (Object)entry.getTags().contains("calendar_tag_3"));
        entry.getTags().remove("calendar_tag_2");
        entry.getTags().add("calendar_tag_3");
        entry.getTags().add("calendar_tag_1");
        CALENDAR_SERVICE.updateCalendarEntry((CalendarEntry)entry);
        Mockito.when((Object)TAGGING_SERVICE.getTags(entry.getNodeRef())).thenReturn(Arrays.asList("calendar_tag_1", "calendar_tag_3"));
        entry = CALENDAR_SERVICE.getCalendarEntry(CALENDAR_SITE.getShortName(), entry.getSystemName());
        Assert.assertEquals((long)2L, (long)entry.getTags().size());
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_1"));
        Assert.assertEquals((Object)false, (Object)entry.getTags().contains("calendar_tag_2"));
        Assert.assertEquals((Object)true, (Object)entry.getTags().contains("calendar_tag_3"));
        CALENDAR_SERVICE.deleteCalendarEntry((CalendarEntry)entry);
    }

    @Test
    public void calendarSingleSiteListing() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        PagingResults results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        CalendarEntry entryA = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleA", "Description", "Location", new Date(1302431400L), new Date(1302435000L)));
        CalendarEntry entryB = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleB", "Description", "Location", new Date(1302431400L), new Date(1302442200L)));
        CalendarEntry entryC = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleC", "Description", "Location", new Date(1302435000L), new Date(1302442200L)));
        this.testNodesToTidy.add(entryA.getNodeRef());
        this.testNodesToTidy.add(entryB.getNodeRef());
        this.testNodesToTidy.add(entryC.getNodeRef());
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        CalendarEntry entryD = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleD", "Description", "Location", new Date(1302417000L), new Date(1302420600L)));
        this.testNodesToTidy.add(entryD.getNodeRef());
        paging = new PagingRequest(3);
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        paging = new PagingRequest(3, 3);
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        paging = new PagingRequest(3);
        results = CALENDAR_SERVICE.listOutlookCalendarEntries(CALENDAR_SITE.getShortName(), null, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        String uidB = "THIS_is_A_fake_UID_123";
        String uidC = "THIS_is_A_fake_UID_4321";
        ((CalendarEntryDTO)entryB).setOutlook(true);
        ((CalendarEntryDTO)entryB).setOutlookUID(uidB);
        ((CalendarEntryDTO)entryC).setOutlook(true);
        ((CalendarEntryDTO)entryC).setOutlookUID(uidC);
        CALENDAR_SERVICE.updateCalendarEntry(entryB);
        CALENDAR_SERVICE.updateCalendarEntry(entryC);
        paging = new PagingRequest(3);
        results = CALENDAR_SERVICE.listOutlookCalendarEntries(CALENDAR_SITE.getShortName(), null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        paging = new PagingRequest(3);
        results = CALENDAR_SERVICE.listOutlookCalendarEntries(CALENDAR_SITE.getShortName(), uidB, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        paging = new PagingRequest(3);
        results = CALENDAR_SERVICE.listOutlookCalendarEntries(CALENDAR_SITE.getShortName(), uidC, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
    }

    @Test
    public void calendarListingPermissionsChecking() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        PagingResults results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        Assert.assertEquals((Object)true, (Object)SITE_SERVICE.isMember(CALENDAR_SITE.getShortName(), TEST_USER));
        Assert.assertEquals((Object)false, (Object)SITE_SERVICE.isMember(ALTERNATE_CALENDAR_SITE.getShortName(), TEST_USER));
        CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleA", "Description", "Location", new Date(1302431400L), new Date(1302435000L)));
        CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleB", "Description", "Location", new Date(1302431400L), new Date(1302442200L)));
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        CALENDAR_SERVICE.createCalendarEntry(ALTERNATE_CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("PrivateTitleA", "Description", "Location", new Date(1302431400L), new Date(1302435000L)));
        CALENDAR_SERVICE.createCalendarEntry(ALTERNATE_CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("PrivateTitleB", "Description", "Location", new Date(1302431400L), new Date(1302442200L)));
        NodeRef priv3 = CALENDAR_SERVICE.createCalendarEntry(ALTERNATE_CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("PrivateTitleC", "Description", "Location", new Date(1302431400L), new Date(1302442200L))).getNodeRef();
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.setMembership(ALTERNATE_CALENDAR_SITE.getShortName(), TEST_USER, "SiteCollaborator");
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        PERMISSION_SERVICE.setInheritParentPermissions(priv3, false);
        PERMISSION_SERVICE.clearPermission(priv3, TEST_USER);
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.removeMembership(ALTERNATE_CALENDAR_SITE.getShortName(), TEST_USER);
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        paging = new PagingRequest(10);
        results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        for (CalendarEntry entry : results.getPage()) {
            this.testNodesToTidy.add(entry.getNodeRef());
        }
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        for (CalendarEntry entry : results.getPage()) {
            this.testNodesToTidy.add(entry.getNodeRef());
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
    }

    @Test
    public void calendarMultiSiteListing() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        PagingResults results = CALENDAR_SERVICE.listCalendarEntries(CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(ALTERNATE_CALENDAR_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName(), "MadeUpNumber1", "MadeUpTwo", "MadeUp3"}, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        NodeRef c1 = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleA", "Description", "Location", new Date(1302431400L), new Date(1302442200L))).getNodeRef();
        NodeRef c2 = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleB", "Description", "Location", new Date(1302435000L), new Date(1302435000L))).getNodeRef();
        NodeRef c3 = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("TitleC", "Description", "Location", new Date(1302431400L), new Date(1302435000L))).getNodeRef();
        this.testNodesToTidy.add(c1);
        this.testNodesToTidy.add(c2);
        this.testNodesToTidy.add(c3);
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        NodeRef ca1 = CALENDAR_SERVICE.createCalendarEntry(ALTERNATE_CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("PrivateTitleA", "Description", "Location", new Date(1302131400L), new Date(1302135000L))).getNodeRef();
        NodeRef ca2 = CALENDAR_SERVICE.createCalendarEntry(ALTERNATE_CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("PrivateTitleB", "Description", "Location", new Date(1302731400L), new Date(1302472200L))).getNodeRef();
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        this.testNodesToTidy.add(ca1);
        this.testNodesToTidy.add(ca2);
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.setMembership(ALTERNATE_CALENDAR_SITE.getShortName(), TEST_USER, "SiteCollaborator");
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, paging);
        Assert.assertEquals((long)5L, (long)results.getPage().size());
        Assert.assertEquals((Object)"PrivateTitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(3)).getTitle());
        Assert.assertEquals((Object)"PrivateTitleB", (Object)((CalendarEntry)results.getPage().get(4)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1300031400L), null, paging);
        Assert.assertEquals((long)5L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1302435000L), null, paging);
        Assert.assertEquals((long)4L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        Assert.assertEquals((Object)"PrivateTitleB", (Object)((CalendarEntry)results.getPage().get(3)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1302441000L), null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"PrivateTitleB", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1400000000L), null, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, null, new Date(1300031400L), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, null, new Date(1302435000L), paging);
        Assert.assertEquals((long)4L, (long)results.getPage().size());
        Assert.assertEquals((Object)"PrivateTitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((CalendarEntry)results.getPage().get(3)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, null, new Date(1302432400L), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"PrivateTitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, null, new Date(1400000000L), paging);
        Assert.assertEquals((long)5L, (long)results.getPage().size());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1302431400L), new Date(1302432000L), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName(), ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1302131400L), new Date(1302432000L), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"PrivateTitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(2)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{CALENDAR_SITE.getShortName()}, new Date(1302131400L), new Date(1302432000L), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((CalendarEntry)results.getPage().get(1)).getTitle());
        results = CALENDAR_SERVICE.listCalendarEntries(new String[]{ALTERNATE_CALENDAR_SITE.getShortName()}, new Date(1302131400L), new Date(1302432000L), paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"PrivateTitleA", (Object)((CalendarEntry)results.getPage().get(0)).getTitle());
    }

    @Test
    public void testCannedQueryEntityResults() throws Exception {
        final PagingRequest paging = new PagingRequest(10);
        final NodeRef[] containers = new NodeRef[]{SITE_SERVICE.getContainer(CALENDAR_SITE.getShortName(), "calendar"), SITE_SERVICE.getContainer(ALTERNATE_CALENDAR_SITE.getShortName(), "calendar")};
        final Date from1 = new Date(1302431400L);
        final Date to1 = new Date(1302442200L);
        final ArrayList full = new ArrayList();
        final ArrayList filtered = new ArrayList();
        final GetCalendarEntriesCannedQueryTestHook hook = new GetCalendarEntriesCannedQueryTestHook(){

            public void notifyComplete(List<CalendarEntity> fullList, List<CalendarEntity> filteredList) {
                full.clear();
                filtered.clear();
                full.addAll(fullList);
                filtered.addAll(filteredList);
            }
        };
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, from1, to1, paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)full.size());
        Assert.assertEquals((long)0L, (long)filtered.size());
        CalendarEntry c1 = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("SiteNormal", "Description", "Location", new Date(1302431400L), new Date(1302442200L)));
        CalendarEntry c2 = CALENDAR_SERVICE.createCalendarEntry(CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("SiteRepeating", "Description", "Location", new Date(1302435000L), new Date(1302435000L)));
        CalendarEntry c3 = CALENDAR_SERVICE.createCalendarEntry(ALTERNATE_CALENDAR_SITE.getShortName(), (CalendarEntry)new CalendarEntryDTO("AltSiteNormal", "Description", "Location", new Date(1302431400L), new Date(1302435000L)));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, from1, to1, paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)3L, (long)filtered.size());
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Assert.assertEquals((Object)c3.getSystemName(), (Object)((CalendarEntity)filtered.get(0)).getName());
        Assert.assertEquals((Object)c3.getStart(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(0)).getFromDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c3.getEnd(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(0)).getToDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c3.getRecurrenceRule(), (Object)((CalendarEntity)filtered.get(0)).getRecurrenceRule());
        Assert.assertEquals(null, (Object)((CalendarEntity)filtered.get(0)).getRecurrenceLastMeeting());
        Assert.assertEquals((Object)c1.getSystemName(), (Object)((CalendarEntity)filtered.get(1)).getName());
        Assert.assertEquals((Object)c1.getStart(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(1)).getFromDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c1.getEnd(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(1)).getToDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c1.getRecurrenceRule(), (Object)((CalendarEntity)filtered.get(1)).getRecurrenceRule());
        Assert.assertEquals(null, (Object)((CalendarEntity)filtered.get(1)).getRecurrenceLastMeeting());
        Assert.assertEquals((Object)c2.getSystemName(), (Object)((CalendarEntity)filtered.get(2)).getName());
        Assert.assertEquals((Object)c2.getStart(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(2)).getFromDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c2.getEnd(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(2)).getToDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c2.getRecurrenceRule(), (Object)((CalendarEntity)filtered.get(2)).getRecurrenceRule());
        Assert.assertEquals(null, (Object)((CalendarEntity)filtered.get(2)).getRecurrenceLastMeeting());
        final Date from2 = new Date(1302431390L);
        final Date to2 = new Date(1302431410L);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, from2, to2, paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)2L, (long)filtered.size());
        Assert.assertEquals((Object)c3.getSystemName(), (Object)((CalendarEntity)filtered.get(0)).getName());
        Assert.assertEquals((Object)c1.getSystemName(), (Object)((CalendarEntity)filtered.get(1)).getName());
        c3.setRecurrenceRule("FREQ=WEEKLY;BYDAY=TH;INTERVAL=1");
        c3.setLastRecurrence(new Date(1303431400L));
        CALENDAR_SERVICE.updateCalendarEntry(c3);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, from2, to2, paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)2L, (long)filtered.size());
        Assert.assertEquals((Object)c3.getSystemName(), (Object)((CalendarEntity)filtered.get(0)).getName());
        Assert.assertEquals((Object)c3.getStart(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(0)).getFromDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c3.getEnd(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(0)).getToDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c3.getLastRecurrence(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(0)).getRecurrenceLastMeeting(), (TimeZone)utc));
        Assert.assertEquals((Object)c3.getRecurrenceRule(), (Object)((CalendarEntity)filtered.get(0)).getRecurrenceRule());
        Assert.assertEquals((Object)c1.getSystemName(), (Object)((CalendarEntity)filtered.get(1)).getName());
        Assert.assertEquals((Object)c1.getStart(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(1)).getFromDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c1.getEnd(), (Object)ISO8601DateFormat.parse((String)((CalendarEntity)filtered.get(1)).getToDate(), (TimeZone)utc));
        Assert.assertEquals((Object)c1.getRecurrenceRule(), (Object)((CalendarEntity)filtered.get(1)).getRecurrenceRule());
        Assert.assertEquals(null, (Object)((CalendarEntity)filtered.get(1)).getRecurrenceLastMeeting());
        final Calendar c20110718mon = Calendar.getInstance();
        final Calendar c20110719tue = Calendar.getInstance();
        final Calendar c20110720wed = Calendar.getInstance();
        final Calendar c20110722fri = Calendar.getInstance();
        c20110718mon.set(2011, 6, 18, 0, 0, 0);
        c20110719tue.set(2011, 6, 19, 0, 0, 0);
        c20110720wed.set(2011, 6, 20, 0, 0, 0);
        c20110722fri.set(2011, 6, 22, 0, 0, 0);
        c3.setStart(c20110719tue.getTime());
        c3.setEnd(c20110719tue.getTime());
        c3.setLastRecurrence(c20110722fri.getTime());
        CALENDAR_SERVICE.updateCalendarEntry(c3);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, c20110718mon.getTime(), c20110719tue.getTime(), paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertEquals((Object)c3.getSystemName(), (Object)((CalendarEntity)filtered.get(0)).getName());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, c20110718mon.getTime(), c20110720wed.getTime(), paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertEquals((Object)c3.getSystemName(), (Object)((CalendarEntity)filtered.get(0)).getName());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, c20110720wed.getTime(), c20110722fri.getTime(), paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertEquals((Object)c3.getSystemName(), (Object)((CalendarEntity)filtered.get(0)).getName());
        c3.setLastRecurrence(c20110720wed.getTime());
        CALENDAR_SERVICE.updateCalendarEntry(c3);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)CALENDAR_CQ_FACTORY.getCannedQuery(containers, c20110720wed.getTime(), c20110722fri.getTime(), paging);
                cq.setTestHook(hook);
                cq.execute();
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)full.size());
        Assert.assertEquals((long)0L, (long)filtered.size());
    }

    private static void createTestSites() throws Exception {
        final CalendarServiceImpl privateCalendarService = (CalendarServiceImpl)testContext.getBean("calendarService");
        CALENDAR_SITE = (SiteInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(CalendarServiceImplTest.TEST_SITE_PREFIX, String.valueOf(CalendarServiceImplTest.class.getSimpleName()) + "_testSite" + System.currentTimeMillis(), "test site title", "test site description", SiteVisibility.PUBLIC);
                privateCalendarService.getSiteCalendarContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        ALTERNATE_CALENDAR_SITE = (SiteInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(CalendarServiceImplTest.TEST_SITE_PREFIX, String.valueOf(CalendarServiceImplTest.class.getSimpleName()) + "_testAltSite" + System.currentTimeMillis(), "alternate site title", "alternate site description", SiteVisibility.PRIVATE);
                privateCalendarService.getSiteCalendarContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
    }

    @Before
    public void setAdminUser() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    @After
    public void deleteTestNodes() throws Exception {
        CalendarServiceImplTest.performDeletionOfNodes(this.testNodesToTidy);
    }

    @AfterClass
    public static void deleteClassTestNodesAndUsers() throws Exception {
        CalendarServiceImplTest.performDeletionOfNodes(CLASS_TEST_NODES_TO_TIDY);
        CalendarServiceImplTest.deleteUser(TEST_USER);
    }

    private static void performDeletionOfNodes(final List<NodeRef> nodesToDelete) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                for (NodeRef node : nodesToDelete) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    if (NODE_SERVICE.getType(node).equals((Object)SiteModel.TYPE_SITE)) {
                        SiteInfo siteInfo = SITE_SERVICE.getSite(node);
                        SITE_SERVICE.deleteSite(siteInfo.getShortName());
                        continue;
                    }
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                    PERSON_SERVICE.createPerson((Map)ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (PERSON_SERVICE.personExists(userName)) {
                    PERSON_SERVICE.deletePerson(userName);
                }
                return null;
            }
        });
    }
}

