/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rendition.RenditionPreventionRegistry;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinition2Impl;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2Impl;
import org.alfresco.repo.rendition2.RenditionService2Exception;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.RenditionService2PreventedException;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.repo.rendition2.TransformReplyProvider;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.util.PostTxnCallbackScheduler;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.transform.client.registry.TransformServiceRegistry;
import org.alfresco.transform.client.registry.TransformServiceRegistryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RenditionService2Test {
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private RenditionService2Impl renditionService2;
    private RenditionDefinitionRegistry2Impl renditionDefinitionRegistry2;
    @Mock
    private TransformClient transformClient;
    @Mock
    private TransactionService transactionService;
    @Mock
    private NodeService nodeService;
    @Mock
    private ContentService contentService;
    @Mock
    private RenditionPreventionRegistry renditionPreventionRegistry;
    @Mock
    private ContentData contentData;
    @Mock
    private PolicyComponent policyComponent;
    @Mock
    private BehaviourFilter behaviourFilter;
    @Mock
    private RuleService ruleService;
    @Mock
    private TransformServiceRegistryImpl transformServiceRegistry;
    @Mock
    private TransformReplyProvider transformReplyProvider;
    @Mock
    private AsynchronousExtractor asynchronousExtractor;
    private NodeRef nodeRef = new NodeRef("workspace://spacesStore/test-id");
    private NodeRef nodeRefMissing = new NodeRef("workspace://spacesStore/bad-test-id");
    private static final String TEST_RENDITION = "testRendition";
    private static final String JPEG = "image/jpeg";
    private String contentUrl = "test-content-url";
    private static final String CLIENT_DATA = "some_clientData";
    private static final String REPLY_QUEUE = "some_replyQueue";
    private static final String REQUEST_ID = "some_requestId";
    private static final TransformDefinition TEST_TRANSFORM = new TransformDefinition("image/jpeg", Collections.singletonMap("a", "A"), "some_clientData", "some_replyQueue", "some_requestId");
    private boolean failureCalled;

    @Before
    public void setup() throws Exception {
        this.renditionService2 = new RenditionService2Impl(){

            public void failure(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, int transformContentHashCode) {
                RenditionService2Test.this.failureCalled = true;
            }
        };
        this.renditionDefinitionRegistry2 = new RenditionDefinitionRegistry2Impl();
        this.renditionDefinitionRegistry2.setTransformServiceRegistry((TransformServiceRegistry)this.transformServiceRegistry);
        this.renditionDefinitionRegistry2.setRenditionConfigDir("");
        this.renditionDefinitionRegistry2.setTimeoutDefault("120000");
        this.renditionDefinitionRegistry2.setJsonObjectMapper(JSON_OBJECT_MAPPER);
        this.renditionDefinitionRegistry2.setCronExpression(null);
        Mockito.when((Object)this.nodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.nodeService.exists(this.nodeRefMissing)).thenReturn((Object)false);
        Mockito.when((Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_CONTENT)).thenReturn((Object)this.contentData);
        Mockito.when((Object)this.contentData.getContentUrl()).thenReturn((Object)this.contentUrl);
        ((TransformClient)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            NodeRef sourceNodeRef = (NodeRef)args[0];
            RenditionDefinition2 renditionDefinition = (RenditionDefinition2)args[1];
            int sourceContentHashCode = (Integer)args[3];
            if (!(renditionDefinition instanceof TransformDefinition)) {
                ++sourceContentHashCode;
            }
            this.renditionService2.consume(sourceNodeRef, null, renditionDefinition, sourceContentHashCode);
            return null;
        }).when((Object)this.transformClient)).transform((NodeRef)ArgumentMatchers.any(), (RenditionDefinition2)ArgumentMatchers.any(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyInt());
        this.renditionService2.setTransactionService(this.transactionService);
        this.renditionService2.setNodeService(this.nodeService);
        this.renditionService2.setContentService(this.contentService);
        this.renditionService2.setRenditionPreventionRegistry(this.renditionPreventionRegistry);
        this.renditionService2.setRenditionDefinitionRegistry2((RenditionDefinitionRegistry2)this.renditionDefinitionRegistry2);
        this.renditionService2.setTransformClient(this.transformClient);
        this.renditionService2.setPolicyComponent(this.policyComponent);
        this.renditionService2.setBehaviourFilter(this.behaviourFilter);
        this.renditionService2.setRuleService(this.ruleService);
        this.renditionService2.setTransactionService(this.transactionService);
        this.renditionService2.setRenditionRequestSheduler((PostTxnCallbackScheduler)new RenditionRequestSchedulerMock());
        this.renditionService2.setTransformReplyProvider(this.transformReplyProvider);
        this.renditionService2.setEnabled(true);
        this.renditionService2.setThumbnailsEnabled(true);
        this.renditionService2.setAsynchronousExtractor(this.asynchronousExtractor);
        this.renditionDefinitionRegistry2.setRenditionConfigDir("alfresco/renditions/test");
        this.renditionDefinitionRegistry2.afterPropertiesSet();
        this.renditionService2.afterPropertiesSet();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("width", "960");
        options.put("height", "1024");
        new RenditionDefinition2Impl(TEST_RENDITION, JPEG, options, true, this.renditionDefinitionRegistry2);
    }

    @Test(expected=RenditionService2Exception.class)
    public void disabledForRenditions() {
        this.renditionService2.setEnabled(false);
        this.renditionService2.render(this.nodeRef, TEST_RENDITION);
    }

    @Test(expected=RenditionService2Exception.class)
    public void disabledForTransforms() {
        this.renditionService2.setEnabled(false);
        this.renditionService2.transform(this.nodeRef, TEST_TRANSFORM);
    }

    @Test(expected=RenditionService2Exception.class)
    public void thumbnailsDisabledForRenditions() {
        this.renditionService2.setThumbnailsEnabled(false);
        this.renditionService2.render(this.nodeRef, TEST_RENDITION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nodeRefDoesNotExistForRenditions() {
        this.renditionService2.render(this.nodeRefMissing, TEST_RENDITION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nodeRefDoesNotExistForTransforms() {
        this.renditionService2.transform(this.nodeRefMissing, TEST_TRANSFORM);
    }

    @Test
    public void useLocalTransformForRenditions() {
        this.renditionService2.render(this.nodeRef, TEST_RENDITION);
        ((TransformClient)Mockito.verify((Object)this.transformClient, (VerificationMode)Mockito.times((int)1))).transform((NodeRef)ArgumentMatchers.any(), (RenditionDefinition2)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((TransformClient)Mockito.verify((Object)this.transformClient, (VerificationMode)Mockito.times((int)1))).transform((NodeRef)ArgumentMatchers.any(), (RenditionDefinition2)ArgumentMatchers.any(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyInt());
        ((TransformReplyProvider)Mockito.verify((Object)this.transformReplyProvider, (VerificationMode)Mockito.times((int)0))).produceTransformEvent((NodeRef)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), (TransformDefinition)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void useLocalTransformForTransforms() {
        this.renditionService2.transform(this.nodeRef, TEST_TRANSFORM);
        ((TransformClient)Mockito.verify((Object)this.transformClient, (VerificationMode)Mockito.times((int)1))).transform((NodeRef)ArgumentMatchers.any(), (RenditionDefinition2)ArgumentMatchers.any(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyInt());
        ((TransformReplyProvider)Mockito.verify((Object)this.transformReplyProvider, (VerificationMode)Mockito.times((int)1))).produceTransformEvent((NodeRef)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), (TransformDefinition)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void noTransformForRenditions() {
        ((TransformClient)Mockito.doThrow(UnsupportedOperationException.class).when((Object)this.transformClient)).checkSupported((NodeRef)ArgumentMatchers.any(), (RenditionDefinition2)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (String)ArgumentMatchers.any());
        this.renditionService2.render(this.nodeRef, TEST_RENDITION);
    }

    @Test
    public void noTransformForTransforms() {
        ((TransformClient)Mockito.doThrow(UnsupportedOperationException.class).when((Object)this.transformClient)).checkSupported((NodeRef)ArgumentMatchers.any(), (RenditionDefinition2)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (String)ArgumentMatchers.any());
        this.renditionService2.transform(this.nodeRef, TEST_TRANSFORM);
        TestCase.assertTrue((String)"failure() should be called with transform(...) if an unsupported transform rather than having UnsupportedOperationException thrown", (boolean)this.failureCalled);
    }

    @Test(expected=RenditionService2PreventedException.class)
    public void checkSourceNodeForRenditionPreventionClass() {
        Mockito.when((Object)this.renditionPreventionRegistry.isContentClassRegistered((QName)ArgumentMatchers.any())).thenReturn((Object)true);
        this.renditionService2.render(this.nodeRef, TEST_RENDITION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noDefinitionRenditions() {
        this.renditionService2.render(this.nodeRef, "doesNotExist");
    }

    @Test
    public void renditionDefinitionsExist() throws IOException {
        this.renditionDefinitionRegistry2.readConfig();
        Set renditionNames = this.renditionDefinitionRegistry2.getRenditionNames();
        String[] stringArray = new String[]{"medium", "doclib", "imgpreview", "avatar", "avatar32", "webpreview", "pdf"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            TestCase.assertTrue((String)("Expected rendition " + name), (boolean)renditionNames.contains(name));
            ++n2;
        }
    }

    @Test
    public void overriddenRendition() {
        RenditionDefinition2 doclib = this.renditionDefinitionRegistry2.getRenditionDefinition("doclib");
        String resizeWidth = (String)doclib.getTransformOptions().get("resizeWidth");
        Assert.assertEquals((String)"doclib has not been overridden", (Object)"180", (Object)resizeWidth);
    }

    private class RenditionRequestSchedulerMock
    extends PostTxnCallbackScheduler {
        private RenditionRequestSchedulerMock() {
        }

        public void scheduleRendition(RetryingTransactionHelper.RetryingTransactionCallback callback, String uniqueId) {
            try {
                callback.execute();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Assert.fail((String)("The rendition callback failed: " + throwable));
            }
        }
    }
}

