/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.lang.reflect.Field;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.client.config.ClientAppNotFoundException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.ResetPasswordServiceImpl;
import org.alfresco.repo.security.authentication.activiti.SendResetPasswordConfirmationEmailDelegate;
import org.alfresco.repo.security.authentication.activiti.SendResetPasswordEmailDelegate;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.TestHelper;
import org.alfresco.util.email.EmailUtil;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.extensions.surf.util.I18NUtil;

public class ResetPasswordServiceImplTest {
    @ClassRule
    public static final ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    @Rule
    public final RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getSystemUserName());
    private static final String DEFAULT_SENDER = "noreply@test-alfresco.test";
    private static ResetPasswordServiceImpl resetPasswordService;
    private static MutableAuthenticationService authenticationService;
    private static RetryingTransactionHelper transactionHelper;
    private static PersonService personService;
    private static Properties globalProperties;
    private static WorkflowService workflowService;
    private static TestPerson testPerson;
    private static EmailUtil emailUtil;

    @BeforeClass
    public static void initStaticData() throws Exception {
        resetPasswordService = (ResetPasswordServiceImpl)APP_CONTEXT_INIT.getApplicationContext().getBean("resetPasswordService", ResetPasswordServiceImpl.class);
        resetPasswordService.setSendEmailAsynchronously(false);
        resetPasswordService.setDefaultEmailSender(DEFAULT_SENDER);
        authenticationService = (MutableAuthenticationService)APP_CONTEXT_INIT.getApplicationContext().getBean("authenticationService", MutableAuthenticationService.class);
        transactionHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        personService = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("personService", PersonService.class);
        globalProperties = (Properties)APP_CONTEXT_INIT.getApplicationContext().getBean("global-properties", Properties.class);
        workflowService = (WorkflowService)APP_CONTEXT_INIT.getApplicationContext().getBean("WorkflowService", WorkflowService.class);
        emailUtil = new EmailUtil(APP_CONTEXT_INIT.getApplicationContext());
        emailUtil.reset();
        String userName = "jane.doe" + System.currentTimeMillis();
        testPerson = new TestPerson().setUserName(userName).setFirstName("Jane").setLastName("doe").setPassword("password").setEmail(String.valueOf(userName) + "@example.com");
        transactionHelper.doInTransaction(() -> {
            ResetPasswordServiceImplTest.createUser(testPerson);
            return null;
        });
    }

    @AfterClass
    public static void cleanUp() {
        resetPasswordService.setSendEmailAsynchronously(Boolean.valueOf(globalProperties.getProperty("system.reset-password.sendEmailAsynchronously")).booleanValue());
        resetPasswordService.setDefaultEmailSender((String)globalProperties.get("system.email.sender.default"));
        AuthenticationUtil.setRunAsUserSystem();
        transactionHelper.doInTransaction(() -> {
            personService.deletePerson(testPerson.userName);
            return null;
        });
        try {
            AuthenticationUtil.popAuthentication();
        }
        catch (EmptyStackException emptyStackException) {}
    }

    @After
    public void tearDown() throws Exception {
        emailUtil.reset();
    }

    @Test
    public void testResetPassword() throws Exception {
        ResetPasswordServiceImplTest.authenticateUser(testPerson.userName, testPerson.password);
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.setRunAsUserSystem();
        resetPasswordService.requestReset(testPerson.userName, "share");
        Assert.assertEquals((String)"A reset password email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
        MimeMessage msg = emailUtil.getLastEmail();
        Assert.assertNotNull((String)"There should be an email.", (Object)msg);
        Assert.assertEquals((String)"Should've been only one email recipient.", (long)1L, (long)msg.getAllRecipients().length);
        Assert.assertEquals((Object)testPerson.email, (Object)msg.getAllRecipients()[0].toString());
        Assert.assertEquals((Object)DEFAULT_SENDER, (Object)msg.getFrom()[0].toString());
        Assert.assertNotNull((String)"There should be a subject.", (Object)msg.getSubject());
        String emailSubjectKey = ResetPasswordServiceImplTest.getDeclaredField(SendResetPasswordEmailDelegate.class, "EMAIL_SUBJECT_KEY");
        Assert.assertNotNull((Object)emailSubjectKey);
        Assert.assertEquals((Object)msg.getSubject(), (Object)I18NUtil.getMessage((String)emailSubjectKey));
        String resetPasswordUrl = (String)emailUtil.getLastEmailTemplateModelValue("reset_password_url");
        Assert.assertNotNull((String)"Wrong email is sent.", (Object)resetPasswordUrl);
        Pair<String, String> pair = ResetPasswordServiceImplTest.getWorkflowIdAndKeyFromUrl(resetPasswordUrl);
        Assert.assertNotNull((String)"Workflow Id can't be null.", (Object)pair.getFirst());
        Assert.assertNotNull((String)"Workflow Key can't be null.", (Object)pair.getSecond());
        emailUtil.reset();
        ResetPasswordServiceImpl.ResetPasswordDetails passwordDetails = new ResetPasswordServiceImpl.ResetPasswordDetails().setUserId(testPerson.userName).setPassword("newPassword").setWorkflowId((String)pair.getFirst()).setWorkflowKey((String)pair.getSecond());
        resetPasswordService.initiateResetPassword(passwordDetails);
        Assert.assertEquals((String)"A reset password confirmation email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
        msg = emailUtil.getLastEmail();
        Assert.assertNotNull((String)"There should be an email.", (Object)msg);
        Assert.assertEquals((String)"Should've been only one email recipient.", (long)1L, (long)msg.getAllRecipients().length);
        Assert.assertEquals((Object)testPerson.email, (Object)msg.getAllRecipients()[0].toString());
        Assert.assertEquals((Object)DEFAULT_SENDER, (Object)msg.getFrom()[0].toString());
        Assert.assertNotNull((String)"There should be a subject.", (Object)msg.getSubject());
        emailSubjectKey = ResetPasswordServiceImplTest.getDeclaredField(SendResetPasswordConfirmationEmailDelegate.class, "EMAIL_SUBJECT_KEY");
        Assert.assertNotNull((Object)emailSubjectKey);
        Assert.assertEquals((Object)msg.getSubject(), (Object)I18NUtil.getMessage((String)emailSubjectKey));
        TestHelper.assertThrows(() -> ResetPasswordServiceImplTest.authenticateUser(testPerson.userName, testPerson.password), AuthenticationException.class, "As the user changed her password, the authentication should have failed.");
        ResetPasswordServiceImplTest.authenticateUser(testPerson.userName, "newPassword");
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.setRunAsUserSystem();
        emailUtil.reset();
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), ResetPasswordServiceImpl.InvalidResetPasswordWorkflowException.class, "The workflow instance is not active (it has already been used).");
        Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
    }

    @Test
    public void testRequestResetPasswordInvalid() throws Exception {
        TestHelper.assertThrows(() -> resetPasswordService.requestReset(testPerson.userName, null), IllegalArgumentException.class, "Client name is mandatory.");
        TestHelper.assertThrows(() -> resetPasswordService.requestReset(testPerson.userName, "TestClient" + System.currentTimeMillis()), ClientAppNotFoundException.class, "Client is not found.");
        Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
        TestHelper.assertThrows(() -> resetPasswordService.requestReset(null, "share"), IllegalArgumentException.class, "userId is mandatory.");
        Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
        TestHelper.assertThrows(() -> resetPasswordService.requestReset("NoUser" + System.currentTimeMillis(), "share"), ResetPasswordServiceImpl.ResetPasswordWorkflowInvalidUserException.class, "user does not exist.");
        Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
        this.enableUser(testPerson.userName, false);
        TestHelper.assertThrows(() -> resetPasswordService.requestReset(testPerson.userName, "share"), ResetPasswordServiceImpl.ResetPasswordWorkflowInvalidUserException.class, "user is disabled.");
        Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
        this.enableUser(testPerson.userName, true);
    }

    @Test
    public void testResetPasswordInvalid() throws Exception {
        resetPasswordService.requestReset(testPerson.userName, "share");
        Assert.assertEquals((String)"A reset password email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
        MimeMessage msg = emailUtil.getLastEmail();
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((String)"Should've been only one email recipient.", (long)1L, (long)msg.getAllRecipients().length);
        String resetPasswordUrl = (String)emailUtil.getLastEmailTemplateModelValue("reset_password_url");
        Assert.assertNotNull((String)"Wrong email is sent.", (Object)resetPasswordUrl);
        Pair<String, String> pair = ResetPasswordServiceImplTest.getWorkflowIdAndKeyFromUrl(resetPasswordUrl);
        Assert.assertNotNull((String)"Workflow Id can't be null.", (Object)pair.getFirst());
        Assert.assertNotNull((String)"Workflow Key can't be null.", (Object)pair.getSecond());
        emailUtil.reset();
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(null), IllegalArgumentException.class, "null parameter.");
        ResetPasswordServiceImpl.ResetPasswordDetails passwordDetails = new ResetPasswordServiceImpl.ResetPasswordDetails().setUserId(null).setPassword("newPassword").setWorkflowId((String)pair.getFirst()).setWorkflowKey((String)pair.getSecond());
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), IllegalArgumentException.class, "User id is mandatory.");
        passwordDetails.setUserId(testPerson.userName).setPassword(null);
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), IllegalArgumentException.class, "Password is mandatory.");
        passwordDetails.setPassword("");
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), IllegalArgumentException.class, "Invalid password value.");
        passwordDetails.setPassword("newPassword").setWorkflowId(null);
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), IllegalArgumentException.class, "Workflow id is mandatory.");
        passwordDetails.setWorkflowId((String)pair.getFirst()).setWorkflowKey(null);
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), IllegalArgumentException.class, "Workflow key is mandatory.");
        passwordDetails.setWorkflowId("activiti$" + System.currentTimeMillis()).setWorkflowKey((String)pair.getSecond());
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), ResetPasswordServiceImpl.ResetPasswordWorkflowNotFoundException.class, "The workflow instance with the invalid id should not have been found.");
        passwordDetails.setWorkflowId((String)pair.getFirst()).setWorkflowKey(GUID.generate());
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), ResetPasswordServiceImpl.InvalidResetPasswordWorkflowException.class, "The recovered key does not match the given workflow key.");
        passwordDetails.setUserId("marco.polo").setWorkflowId((String)pair.getFirst()).setWorkflowKey((String)pair.getSecond());
        TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), ResetPasswordServiceImpl.InvalidResetPasswordWorkflowException.class, "The given user id does not match the person's user id who requested the password reset.");
        Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
    }

    @Test
    public void testResetPasswordEndTimer() throws Exception {
        String defaultTimer = globalProperties.getProperty("system.reset-password.endTimer");
        try {
            resetPasswordService.setTimerEnd("PT1S");
            resetPasswordService.requestReset(testPerson.userName, "share");
            Assert.assertEquals((String)"A reset password email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
            String resetPasswordUrl = (String)emailUtil.getLastEmailTemplateModelValue("reset_password_url");
            Assert.assertNotNull((String)"Wrong email is sent.", (Object)resetPasswordUrl);
            Pair<String, String> pair = ResetPasswordServiceImplTest.getWorkflowIdAndKeyFromUrl(resetPasswordUrl);
            Assert.assertNotNull((String)"Workflow Id can't be null.", (Object)pair.getFirst());
            Assert.assertNotNull((String)"Workflow Key can't be null.", (Object)pair.getSecond());
            emailUtil.reset();
            ResetPasswordServiceImpl.ResetPasswordDetails passwordDetails = new ResetPasswordServiceImpl.ResetPasswordDetails().setUserId(testPerson.userName).setPassword("newPassword").setWorkflowId((String)pair.getFirst()).setWorkflowKey((String)pair.getSecond());
            boolean active = TestHelper.waitBeforeRetry(() -> this.isActive((String)pair.getFirst()), false, 10, 1000L);
            Assert.assertFalse((String)"The workflow should have been inactive.", (boolean)active);
            TestHelper.assertThrows(() -> resetPasswordService.initiateResetPassword(passwordDetails), ResetPasswordServiceImpl.InvalidResetPasswordWorkflowException.class, "The workflow instance is not active (expired).");
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
        }
        finally {
            resetPasswordService.setTimerEnd(defaultTimer);
        }
    }

    private boolean isActive(String workflowId) {
        WorkflowInstance workflowInstance = workflowService.getWorkflowById(workflowId);
        Assert.assertNotNull((Object)workflowInstance);
        return workflowInstance.isActive();
    }

    public static Pair<String, String> getWorkflowIdAndKeyFromUrl(String url) {
        Assert.assertNotNull((Object)url);
        String id = StringUtils.trimToNull((String)StringUtils.substringAfter((String)url, (String)"id="));
        String key = StringUtils.substringBetween((String)url, (String)"key=", (String)"&id=");
        Pair pair = new Pair((Object)id, (Object)key);
        return pair;
    }

    private static void createUser(TestPerson testPerson) {
        if (authenticationService.authenticationExists(testPerson.userName)) {
            return;
        }
        authenticationService.createAuthentication(testPerson.userName, testPerson.password.toCharArray());
        HashMap<QName, String> map = new HashMap<QName, String>(4);
        map.put(ContentModel.PROP_USERNAME, testPerson.userName);
        map.put(ContentModel.PROP_FIRSTNAME, testPerson.firstName);
        map.put(ContentModel.PROP_LASTNAME, testPerson.lastName);
        map.put(ContentModel.PROP_EMAIL, testPerson.email);
        personService.createPerson(map);
    }

    private void enableUser(String userName, boolean enable) {
        transactionHelper.doInTransaction(() -> {
            authenticationService.setAuthenticationEnabled(userName, enable);
            return null;
        });
    }

    private static void authenticateUser(String userName, String password) {
        authenticationService.authenticate(userName, password.toCharArray());
    }

    private static String getDeclaredField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (String)field.get(null);
    }

    private static class TestPerson {
        private String userName;
        private String firstName;
        private String lastName;
        private String password;
        private String email;

        private TestPerson() {
        }

        private TestPerson setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        private TestPerson setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        private TestPerson setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        private TestPerson setPassword(String password) {
            this.password = password;
            return this;
        }

        private TestPerson setEmail(String email) {
            this.email = email;
            return this;
        }
    }
}

