/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.UserTransaction;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TooBusyException;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.dao.ConcurrencyFailureException;

public class RetryingTransactionHelperTest
extends BaseSpringTest {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.transaction.RetryingTransactionHelperTest");
    private static final QName PROP_CHECK_VALUE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"check_value");
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private NodeService nodeService;
    private RetryingTransactionHelper txnHelper;
    private Dialect dialect;
    private NodeRef rootNodeRef;
    private NodeRef workingNodeRef;

    @Before
    public void setUp() throws Exception {
        this.dialect = (Dialect)this.applicationContext.getBean("dialect");
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "test-" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)GUID.generate()), ContentModel.TYPE_CMOBJECT).getChildRef();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {}
    }

    @Test
    public void testSetUp() throws Exception {
        RetryingTransactionHelperTest.assertNotNull((Object)this.rootNodeRef);
        RetryingTransactionHelperTest.assertNotNull((Object)this.workingNodeRef);
    }

    private Long getCheckValue() {
        Long checkValue = (Long)this.nodeService.getProperty(this.workingNodeRef, PROP_CHECK_VALUE);
        if (checkValue == null) {
            checkValue = new Long(0L);
            this.nodeService.setProperty(this.workingNodeRef, PROP_CHECK_VALUE, (Serializable)checkValue);
        }
        return checkValue;
    }

    private Long incrementCheckValue() {
        Long checkValue = this.getCheckValue();
        checkValue = new Long(checkValue + 1L);
        this.nodeService.setProperty(this.workingNodeRef, PROP_CHECK_VALUE, (Serializable)checkValue);
        return checkValue;
    }

    private Long blowUp() {
        NodeRef invalidNodeRef = new NodeRef(this.workingNodeRef.getStoreRef(), "BOGUS");
        this.nodeService.setProperty(invalidNodeRef, PROP_CHECK_VALUE, null);
        RetryingTransactionHelperTest.fail((String)"Expected to generate an InvalidNodeRefException");
        return null;
    }

    @Test
    public void testSuccessNoRetry() {
        long beforeValue = this.getCheckValue();
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return RetryingTransactionHelperTest.this.incrementCheckValue();
            }
        };
        long txnValue = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        long afterValue = this.getCheckValue();
        RetryingTransactionHelperTest.assertEquals((String)"The value must have increased", (long)(beforeValue + 1L), (long)afterValue);
        RetryingTransactionHelperTest.assertEquals((String)"The txn value must be the same as the value after", (long)afterValue, (long)txnValue);
    }

    @Test
    public void testUserTransactionStatus() {
        UserTransaction txnBefore = RetryingTransactionHelper.getActiveUserTransaction();
        RetryingTransactionHelperTest.assertNull((String)"Did not expect to get an active UserTransaction", (Object)txnBefore);
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackOuter = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                UserTransaction txnOuter = RetryingTransactionHelper.getActiveUserTransaction();
                RetryingTransactionHelperTest.assertNotNull((String)"Expected an active UserTransaction", (Object)txnOuter);
                RetryingTransactionHelperTest.assertEquals((String)"Should be read-write txn", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE, (Object)AlfrescoTransactionSupport.getTransactionReadState());
                RetryingTransactionHelperTest.assertEquals((String)"Expected state is active", (int)0, (int)txnOuter.getStatus());
                RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    public Long execute() throws Throwable {
                        UserTransaction txnInner = RetryingTransactionHelper.getActiveUserTransaction();
                        RetryingTransactionHelperTest.assertNotNull((String)"Expected an active UserTransaction", (Object)txnInner);
                        RetryingTransactionHelperTest.assertEquals((String)"Should be read-only txn", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY, (Object)AlfrescoTransactionSupport.getTransactionReadState());
                        RetryingTransactionHelperTest.assertEquals((String)"Expected state is active", (int)0, (int)txnInner.getStatus());
                        try {
                            txnInner.commit();
                            RetryingTransactionHelperTest.fail((String)"Should not be able to commit the UserTransaction.  It is for info only.");
                        }
                        catch (Throwable throwable) {}
                        txnInner.setRollbackOnly();
                        return null;
                    }
                };
                return (Long)RetryingTransactionHelperTest.this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callbackInner, true, true);
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callbackOuter);
        UserTransaction txnAfter = RetryingTransactionHelper.getActiveUserTransaction();
        RetryingTransactionHelperTest.assertNull((String)"Did not expect to get an active UserTransaction", (Object)txnAfter);
    }

    @Test
    public void testSuccessWithRetry() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){
            private int maxCalls = 3;
            private int callCount = 0;

            public Long execute() throws Throwable {
                ++this.callCount;
                Long checkValue = RetryingTransactionHelperTest.this.incrementCheckValue();
                if (this.callCount == this.maxCalls) {
                    return checkValue;
                }
                throw new ConcurrencyFailureException("Testing");
            }
        };
        long txnValue = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        RetryingTransactionHelperTest.assertEquals((String)"Only one increment expected", (long)1L, (long)txnValue);
    }

    @Test
    public void testNonRetryingFailure() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                RetryingTransactionHelperTest.this.incrementCheckValue();
                return RetryingTransactionHelperTest.this.blowUp();
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            RetryingTransactionHelperTest.fail((String)"Wrapper didn't generate an exception");
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
        }
        catch (Throwable e) {
            RetryingTransactionHelperTest.fail((String)("Incorrect exception from wrapper: " + e));
        }
        long checkValue = this.getCheckValue();
        RetryingTransactionHelperTest.assertEquals((String)"Check value should not have changed", (long)0L, (long)checkValue);
    }

    @Test
    public void testNonRetryingSilentRollback() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                RetryingTransactionHelperTest.this.incrementCheckValue();
                try {
                    return RetryingTransactionHelperTest.this.blowUp();
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    return null;
                }
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        long checkValue = this.getCheckValue();
        RetryingTransactionHelperTest.assertEquals((String)"Check value should not have changed", (long)0L, (long)checkValue);
    }

    @Test
    public void testNestedWithPropagation() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    public Long execute() throws Throwable {
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        return RetryingTransactionHelperTest.this.getCheckValue();
                    }
                };
                RetryingTransactionHelperTest.this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callbackInner, false, false);
                RetryingTransactionHelperTest.this.incrementCheckValue();
                RetryingTransactionHelperTest.this.incrementCheckValue();
                return RetryingTransactionHelperTest.this.getCheckValue();
            }
        };
        long checkValue = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        RetryingTransactionHelperTest.assertEquals((String)"Nesting requiresNew==false didn't work", (long)4L, (long)checkValue);
    }

    @Test
    public void testNestedWithoutPropagation() {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    public Long execute() throws Throwable {
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        RetryingTransactionHelperTest.this.incrementCheckValue();
                        return RetryingTransactionHelperTest.this.getCheckValue();
                    }
                };
                RetryingTransactionHelperTest.this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callbackInner, false, true);
                RetryingTransactionHelperTest.this.incrementCheckValue();
                RetryingTransactionHelperTest.this.incrementCheckValue();
                return RetryingTransactionHelperTest.this.getCheckValue();
            }
        };
        long checkValue = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        RetryingTransactionHelperTest.assertEquals((String)"Nesting requiresNew==true didn't work", (long)4L, (long)checkValue);
    }

    @Test
    public void testNestedWithoutPropagationConcurrentUntilFailureMySQL() throws InterruptedException {
        final RetryingTransactionHelper txnHelperForTest = this.transactionService.getRetryingTransactionHelper();
        txnHelperForTest.setMaxRetries(1);
        if (!(this.dialect instanceof MySQLInnoDBDialect)) {
            logger.warn((Object)("NOTE: Skipping testNestedWithoutPropogationConcurrentUntilFailureMySQLOnly for dialect: " + this.dialect));
        } else {
            RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                public Long execute() throws Throwable {
                    RetryingTransactionHelper.RetryingTransactionCallback<Long> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                        public Long execute() throws Throwable {
                            RetryingTransactionHelperTest.this.incrementCheckValue();
                            return RetryingTransactionHelperTest.this.getCheckValue();
                        }
                    };
                    RetryingTransactionHelperTest.this.incrementCheckValue();
                    txnHelperForTest.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callbackInner, false, true);
                    return RetryingTransactionHelperTest.this.getCheckValue();
                }
            };
            try {
                txnHelperForTest.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                RetryingTransactionHelperTest.fail((String)"Concurrent nested access not leading to failure");
            }
            catch (Throwable e) {
                Throwable validCause = ExceptionStackUtil.getCause((Throwable)e, (Class[])RetryingTransactionHelper.RETRY_EXCEPTIONS);
                RetryingTransactionHelperTest.assertNotNull((String)"Unexpected cause of the failure", (Object)validCause);
            }
        }
    }

    @Test
    public void testConcurrencyRetryingNoFailure() throws InterruptedException {
        Thread t1 = new Thread(new ConcurrentTransaction(5000L));
        t1.start();
        Thread.sleep(1000L);
        Thread t2 = new Thread(new ConcurrentTransaction(10L));
        t2.start();
        t1.join();
        t2.join();
    }

    @Test
    public void testZeroAndNegativeRetries() {
        final MutableInt callCount = new MutableInt(0);
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                callCount.setValue(callCount.intValue() + 1);
                throw new ConcurrentModificationException();
            }
        };
        callCount.setValue(0);
        this.txnHelper.setMaxRetries(0);
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        RetryingTransactionHelperTest.assertEquals((String)"Should have been called exactly once", (int)1, (int)callCount.intValue());
        callCount.setValue(0);
        this.txnHelper.setMaxRetries(-1);
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        RetryingTransactionHelperTest.assertEquals((String)"Should have been called exactly once", (int)1, (int)callCount.intValue());
    }

    @Test
    public void testTimeLimit() {
        RetryingTransactionHelper txnHelper = new RetryingTransactionHelper();
        txnHelper.setTransactionService(this.transactionService);
        txnHelper.setMaxExecutionMs(3000L);
        List<Throwable> caughtExceptions = Collections.synchronizedList(new LinkedList());
        this.runThreads(txnHelper, caughtExceptions, new Pair((Object)0, (Object)1000), new Pair((Object)0, (Object)5000), new Pair((Object)4000, (Object)1000));
        RetryingTransactionHelperTest.assertEquals((String)"Expected 1 exception", (int)1, (int)caughtExceptions.size());
        RetryingTransactionHelperTest.assertTrue((String)"Excpected TooBusyException", (boolean)(caughtExceptions.get(0) instanceof TooBusyException));
        caughtExceptions.clear();
        this.runThreads(txnHelper, caughtExceptions, new Pair((Object)0, (Object)1000), new Pair((Object)0, (Object)2000), new Pair((Object)0, (Object)1000), new Pair((Object)1000, (Object)1000), new Pair((Object)1000, (Object)2000), new Pair((Object)2000, (Object)1000));
        if (caughtExceptions.size() > 0) {
            throw new RuntimeException("Unexpected exception", caughtExceptions.get(0));
        }
    }

    @Test
    public void testALF_17631() {
        final MutableInt callCount = new MutableInt(0);
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                callCount.setValue(callCount.intValue() + 1);
                throw new InvalidNodeRefException(new NodeRef("test", "test", "test"));
            }
        };
        this.txnHelper.setMaxRetries(3);
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        RetryingTransactionHelperTest.assertEquals((String)"Should have been called exactly once", (int)1, (int)callCount.intValue());
        callCount.setValue(0);
        ArrayList<Class<InvalidNodeRefException>> extraExceptions = new ArrayList<Class<InvalidNodeRefException>>(1);
        extraExceptions.add(InvalidNodeRefException.class);
        this.txnHelper.setExtraExceptions(extraExceptions);
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        RetryingTransactionHelperTest.assertEquals((String)"Should have been called tree times", (int)3, (int)callCount.intValue());
    }

    @Test
    public void testForceWritable() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doNothingCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                return null;
            }
        };
        TransactionServiceImpl txnService = (TransactionServiceImpl)this.transactionService;
        txnService.setAllowWrite(false, QName.createQName((String)"{test}testForceWritable"));
        try {
            final RetryingTransactionHelper vetoedTxnHelper = txnService.getRetryingTransactionHelper();
            vetoedTxnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doNothingCallback, true, false);
            try {
                vetoedTxnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doNothingCallback, false, false);
                RetryingTransactionHelperTest.fail((String)"Failed to prevent read-write txn in vetoed txn helper.");
            }
            catch (RuntimeException runtimeException) {}
            RetryingTransactionHelper forcedTxnHelper = txnService.getRetryingTransactionHelper();
            forcedTxnHelper.setForceWritable(true);
            forcedTxnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>((RetryingTransactionHelper.RetryingTransactionCallback)doNothingCallback){
                private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$doNothingCallback;
                {
                    this.val$doNothingCallback = retryingTransactionCallback;
                }

                public Void execute() throws Throwable {
                    vetoedTxnHelper.doInTransaction(this.val$doNothingCallback, false, false);
                    return null;
                }
            }, false);
            try {
                forcedTxnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>((RetryingTransactionHelper.RetryingTransactionCallback)doNothingCallback){
                    private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$doNothingCallback;
                    {
                        this.val$doNothingCallback = retryingTransactionCallback;
                    }

                    public Void execute() throws Throwable {
                        vetoedTxnHelper.doInTransaction(this.val$doNothingCallback, false, true);
                        return null;
                    }
                }, false);
                RetryingTransactionHelperTest.fail((String)"Inner, non-propagating transactions should still fall foul of the write veto.");
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        finally {
            txnService.setAllowWrite(true, QName.createQName((String)"{test}testForceWritable"));
        }
    }

    @Test
    public void testStartNewTransaction() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        String txnId = AlfrescoTransactionSupport.getTransactionId();
        class CustomListenerAdapter
        extends TransactionListenerAdapter {
            private String newTxnId;

            CustomListenerAdapter() {
            }

            public void afterRollback() {
                this.newTxnId = (String)RetryingTransactionHelperTest.this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    public String execute() throws Throwable {
                        return AlfrescoTransactionSupport.getTransactionId();
                    }
                }, true, false);
            }
        }
        CustomListenerAdapter listener = new CustomListenerAdapter();
        AlfrescoTransactionSupport.bindListener((TransactionListener)listener);
        txn.rollback();
        RetryingTransactionHelperTest.assertFalse((String)"New transaction has not started", (boolean)txnId.equals(listener.newTxnId));
    }

    private void runThreads(RetryingTransactionHelper txnHelper, List<Throwable> caughtExceptions, Pair<Integer, Integer> ... startDurationPairs) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        long startTime = System.currentTimeMillis();
        long currentStart = 0L;
        Pair<Integer, Integer>[] pairArray = startDurationPairs;
        int n = startDurationPairs.length;
        int n2 = 0;
        while (n2 < n) {
            long now;
            Pair<Integer, Integer> pair = pairArray[n2];
            int start = (Integer)pair.getFirst();
            long then = startTime + (long)start;
            if (then > (now = System.currentTimeMillis())) {
                try {
                    Thread.sleep(then - now);
                }
                catch (InterruptedException interruptedException) {}
                currentStart = start;
            }
            CountDownLatch startLatch = new CountDownLatch(1);
            class Work
            implements Runnable {
                private final CountDownLatch startLatch;
                private final long endTime;
                private final /* synthetic */ RetryingTransactionHelper val$txnHelper;
                private final /* synthetic */ List val$caughtExceptions;

                public Work(CountDownLatch startLatch, long endTime, RetryingTransactionHelper retryingTransactionHelper, List list) {
                    this.val$txnHelper = retryingTransactionHelper;
                    this.val$caughtExceptions = list;
                    this.startLatch = startLatch;
                    this.endTime = endTime;
                }

                @Override
                public void run() {
                    block2: {
                        try {
                            this.val$txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                                public Void execute() throws Throwable {
                                    startLatch.countDown();
                                    long duration = endTime - System.currentTimeMillis();
                                    if (duration > 0L) {
                                        Thread.sleep(duration);
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (Throwable e) {
                            this.val$caughtExceptions.add(e);
                            if (this.startLatch.getCount() <= 0L) break block2;
                            this.startLatch.countDown();
                        }
                    }
                }
            }
            Work work = new Work(startLatch, startTime + currentStart + (long)((Integer)pair.getSecond()).intValue(), txnHelper, caughtExceptions);
            executorService.execute(work);
            try {
                startLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
            ++n2;
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    private class ConcurrentTransaction
    implements Runnable {
        private long wait;

        public ConcurrentTransaction(long wait) {
            this.wait = wait;
        }

        @Override
        public void run() {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            RetryingTransactionHelper txnHelperForTest = RetryingTransactionHelperTest.this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                public Long execute() throws Throwable {
                    RetryingTransactionHelperTest.this.incrementCheckValue();
                    System.out.println("Wait started: " + Thread.currentThread() + " (" + ConcurrentTransaction.this.wait + ")");
                    Thread.sleep(ConcurrentTransaction.this.wait);
                    System.out.println("Wait finished: " + Thread.currentThread() + " (" + ConcurrentTransaction.this.wait + ")");
                    return RetryingTransactionHelperTest.this.getCheckValue();
                }
            };
            try {
                System.out.println("Txn start: " + Thread.currentThread() + " (" + this.wait + ")");
                txnHelperForTest.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                System.out.println("Txn finish: " + Thread.currentThread() + " (" + this.wait + ")");
            }
            catch (Throwable e) {
                Throwable validCause = ExceptionStackUtil.getCause((Throwable)e, (Class[])RetryingTransactionHelper.RETRY_EXCEPTIONS);
                RetryingTransactionHelperTest.assertNotNull((String)"Unexpected cause of the failure", (Object)validCause);
            }
        }
    }
}

