/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.UsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class UserUsageTest
extends TestCase {
    private static Log logger = LogFactory.getLog(UserUsageTest.class);
    private ApplicationContext applicationContext;
    protected NodeService nodeService;
    protected FileFolderService fileFolderService;
    protected MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    protected NodeRef rootNodeRef;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    private UserTransaction testTX;
    private TransactionService transactionService;
    private ContentService contentService;
    private PersonService personService;
    private ContentUsageImpl contentUsageImpl;
    private UsageService usageService;
    private OwnableService ownableService;
    private RepoAdminService repoAdminService;
    private static final String TEST_RUN = String.valueOf(System.currentTimeMillis());
    private static final String TEST_USER = "userUsageTestUser-" + TEST_RUN;
    private static final String TEST_USER_2 = "userUsageTestUser2-" + TEST_RUN;
    protected NodeRef personNodeRef;
    protected NodeRef personNodeRef2;
    private static final QName customType = QName.createQName((String)"{my.new.model}sop");
    private List<NodeRef> nodesToDelete = new LinkedList<NodeRef>();

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        if (AlfrescoTransactionSupport.isActualTransactionActive()) {
            UserUsageTest.fail((String)"Test started with transaction in progress");
        }
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)this.applicationContext.getBean("authenticationDao");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.contentUsageImpl = (ContentUsageImpl)this.applicationContext.getBean("contentUsageImpl");
        this.usageService = (UsageService)this.applicationContext.getBean("usageService");
        this.ownableService = (OwnableService)this.applicationContext.getBean("ownableService");
        this.repoAdminService = (RepoAdminService)this.applicationContext.getBean("repoAdminService");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.createTestUsers();
        InputStream modelStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("tenant/exampleModel.xml");
        this.repoAdminService.deployModel(modelStream, "exampleModel.xml");
        this.testTX.commit();
        this.authenticationComponent.clearCurrentSecurityContext();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
    }

    private void createTestUsers() {
        if (this.personService.personExists(TEST_USER)) {
            this.personService.deletePerson(TEST_USER);
        }
        Map<QName, Serializable> props = this.createPersonProperties(TEST_USER);
        this.personNodeRef = this.personService.createPerson(props);
        if (this.authenticationDAO.userExists(TEST_USER)) {
            this.authenticationService.deleteAuthentication(TEST_USER);
        }
        this.authenticationService.createAuthentication(TEST_USER, TEST_USER.toCharArray());
        if (this.personService.personExists(TEST_USER_2)) {
            this.personService.deletePerson(TEST_USER_2);
        }
        props = this.createPersonProperties(TEST_USER_2);
        this.personNodeRef2 = this.personService.createPerson(props);
        if (this.authenticationDAO.userExists(TEST_USER_2)) {
            this.authenticationService.deleteAuthentication(TEST_USER_2);
        }
        this.authenticationService.createAuthentication(TEST_USER_2, TEST_USER_2.toCharArray());
    }

    protected void tearDown() throws Exception {
        boolean deltasDeleted = false;
        try {
            this.usageService.deleteDeltas(this.personNodeRef);
            this.usageService.deleteDeltas(this.personNodeRef2);
            deltasDeleted = true;
        }
        catch (Throwable throwable) {
            try {
                this.testTX.commit();
            }
            catch (Throwable e) {
                AuthenticationUtil.clearCurrentSecurityContext();
                try {
                    this.testTX.rollback();
                }
                catch (Throwable throwable2) {}
                if (deltasDeleted) {
                    throw new Exception("Failed to commit transaction after test", e);
                }
                logger.error((Object)"Transaction commit failed", e);
            }
            throw throwable;
        }
        try {
            this.testTX.commit();
        }
        catch (Throwable e) {
            AuthenticationUtil.clearCurrentSecurityContext();
            try {
                this.testTX.rollback();
            }
            catch (Throwable throwable) {}
            if (deltasDeleted) {
                throw new Exception("Failed to commit transaction after test", e);
            }
            logger.error((Object)"Transaction commit failed", e);
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (NodeRef nodeRef : UserUsageTest.this.nodesToDelete) {
                    UserUsageTest.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                    UserUsageTest.this.nodeService.deleteNode(nodeRef);
                }
                return null;
            }
        }, true, true);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        UserUsageTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    protected void runAsAdmin() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        UserUsageTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    public void testCreateUpdateDeleteInTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.addTextContent(folder, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.addTextContent(folder, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.updateTextContent(content1, "Few black taxis drive up major roads on quiet hazy nights");
        UserUsageTest.assertEquals((long)159L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.updateTextContent(content3, "Heavy boxes perform quick waltzes and jigs");
        UserUsageTest.assertEquals((long)143L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.updateTextContent(content2, "The five boxing wizards jump quickly");
        UserUsageTest.assertEquals((long)135L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content2);
        UserUsageTest.assertEquals((long)99L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content3);
        UserUsageTest.assertEquals((long)57L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder);
    }

    public void testCreateUpdateDeleteAcrossTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "tqbfjotld.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.addTextContent(folder, "afdpj.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.addTextContent(folder, "aqabfweatj.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.updateTextContent(content1, "Few black taxis drive up major roads on quiet hazy nights");
        UserUsageTest.assertEquals((long)159L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.updateTextContent(content3, "Heavy boxes perform quick waltzes and jigs");
        UserUsageTest.assertEquals((long)143L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.updateTextContent(content2, "The five boxing wizards jump quickly");
        UserUsageTest.assertEquals((long)135L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)135L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content2);
        UserUsageTest.assertEquals((long)99L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content3);
        UserUsageTest.assertEquals((long)57L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder);
    }

    public void testCreateDeleteRestoreInTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.addTextContent(folder, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.addTextContent(folder, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content2);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content3);
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.restore(content3);
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.restore(content1);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.restore(content2);
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder);
    }

    public void testCreateDeleteRestoreAcrossTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.addTextContent(folder, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.addTextContent(folder, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.delete(content2);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content3);
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.restore(content3);
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.restore(content1);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.restore(content2);
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder);
    }

    public void testCreateCopyDeleteInTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.copy(content1, folder, "Copy of text1.txt");
        UserUsageTest.assertEquals((long)86L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.copy(content1, folder, "Copy of Copy of text1.txt");
        UserUsageTest.assertEquals((long)129L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content2);
        UserUsageTest.assertEquals((long)86L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content3);
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder);
    }

    public void testCreateCopyDeleteAcrossTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.copy(content1, folder, "Copy of text1.txt");
        UserUsageTest.assertEquals((long)86L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.copy(content1, folder, "Copy of Copy of text1.txt");
        UserUsageTest.assertEquals((long)129L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content2);
        UserUsageTest.assertEquals((long)86L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content3);
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder);
    }

    public void testCreateCopyDeleteFolderWithContentInTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        this.addTextContent(folder1, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.addTextContent(folder1, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.addTextContent(folder1, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef folder2 = this.copy(folder1, folder1, "Copy of testFolder");
        UserUsageTest.assertEquals((long)290L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder2);
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.delete(folder1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
    }

    public void testCreateCopyDeleteFolderWithContentAcrossTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        this.addTextContent(folder1, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.addTextContent(folder1, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.addTextContent(folder1, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        NodeRef folder2 = this.copy(folder1, folder1, "Copy of testFolder");
        UserUsageTest.assertEquals((long)290L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.delete(folder2);
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.delete(folder1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
    }

    public void testCreateTakeOwnershipInTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.addTextContent(folder, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.addTextContent(folder, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        String ADMIN = AuthenticationUtil.getAdminUserName();
        this.runAs(ADMIN);
        long before = this.contentUsageImpl.getUserUsage(ADMIN);
        this.takeOwnership(content1);
        UserUsageTest.assertEquals((long)102L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 43L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.takeOwnership(content2);
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 87L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.runAs(TEST_USER);
        this.takeOwnership(content1);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 44L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.takeOwnership(content3);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 44L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.delete(folder);
    }

    public void testCreateTakeOwnershipAcrossTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef content1 = this.addTextContent(folder, "text1.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content2 = this.addTextContent(folder, "text2.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content3 = this.addTextContent(folder, "text3.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)145L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        this.testTX.commit();
        String ADMIN = AuthenticationUtil.getAdminUserName();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(ADMIN);
        long before = this.contentUsageImpl.getUserUsage(ADMIN);
        this.takeOwnership(content1);
        UserUsageTest.assertEquals((long)102L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 43L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.takeOwnership(content2);
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 87L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.takeOwnership(content1);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 44L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.takeOwnership(content3);
        UserUsageTest.assertEquals((long)101L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)(before + 44L), (long)this.contentUsageImpl.getUserUsage(ADMIN));
        this.delete(folder);
    }

    public void testCreateDeleteRestoreTwoUsersAcrossTx() throws Exception {
        if (!this.contentUsageImpl.getEnabled()) {
            return;
        }
        this.runAs(TEST_USER);
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        NodeRef content1 = this.addTextContent(folder, "tqbfjotld.txt", "The quick brown fox jumps over the lazy dog");
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((String)TEST_USER, (String)this.ownableService.getOwner(content1));
        NodeRef content2 = this.addTextContent(folder, "afdpj.txt", "Amazingly few discotheques provide jukeboxes", true);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((String)TEST_USER, (String)this.ownableService.getOwner(content2));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER_2);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        NodeRef content3 = this.addTextContent(folder, "aqabfweatj.txt", "All questions asked by five watch experts amazed the judge");
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        UserUsageTest.assertEquals((String)TEST_USER_2, (String)this.ownableService.getOwner(content3));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER_2);
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.delete(content2);
        UserUsageTest.assertEquals((long)43L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.delete(content1);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.delete(content3);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER_2);
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.restore(content2);
        UserUsageTest.assertEquals((String)TEST_USER_2, (String)this.ownableService.getOwner(content2));
        UserUsageTest.assertEquals((long)0L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)44L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAs(TEST_USER);
        this.restore(content3);
        UserUsageTest.assertEquals((String)TEST_USER, (String)this.ownableService.getOwner(content3));
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)44L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runAsAdmin();
        this.restore(content1);
        UserUsageTest.assertEquals((String)TEST_USER_2, (String)this.ownableService.getOwner(content1));
        UserUsageTest.assertEquals((long)58L, (long)this.contentUsageImpl.getUserUsage(TEST_USER));
        UserUsageTest.assertEquals((long)87L, (long)this.contentUsageImpl.getUserUsage(TEST_USER_2));
        this.delete(folder);
    }

    private NodeRef addTextContent(NodeRef folderRef, String name, String textData) {
        return this.addTextContent(folderRef, name, textData, false);
    }

    private NodeRef addTextContent(NodeRef folderRef, String name, String textData, boolean custom) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(folderRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), custom ? customType : ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        this.nodesToDelete.add(content);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        return content;
    }

    private void updateTextContent(NodeRef contentRef, String textData) {
        ContentWriter writer = this.contentService.getWriter(contentRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
    }

    private void delete(NodeRef folderOrContentRef) {
        this.nodeService.deleteNode(folderOrContentRef);
    }

    private void restore(NodeRef origfolderOrContentRef) {
        NodeRef archiveRootNode = this.nodeService.getStoreArchiveNode(this.rootNodeRef.getStoreRef());
        NodeRef archiveNodeRef = new NodeRef(archiveRootNode.getStoreRef(), origfolderOrContentRef.getId());
        this.nodeService.restoreNode(archiveNodeRef, null, null, null);
    }

    private NodeRef copy(NodeRef sourceFolderOrContentRef, NodeRef targetFolderRef, String newName) throws FileNotFoundException {
        return this.fileFolderService.copy(sourceFolderOrContentRef, targetFolderRef, newName).getNodeRef();
    }

    private void takeOwnership(NodeRef nodeRef) {
        this.ownableService.takeOwnership(nodeRef);
    }

    @After
    public void after() throws Exception {
        AuthenticationUtil.popAuthentication();
    }
}

