/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.email.EmailService;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public abstract class EmailServer
extends AbstractLifecycleBean {
    private static final String ERR_SENDER_BLOCKED = "email.server.err.sender_blocked";
    private static final String ERR_FROM_SYNTAX_INCORRECT = "email.server.err.from_syntax";
    private boolean enabled = false;
    private String domain = null;
    private int port = 25;
    private int maxConnections = 3;
    private Set<String> blockedSenders = new HashSet<String>(23);
    private Set<String> allowedSenders = new HashSet<String>(23);
    private boolean hideTLS = false;
    private boolean enableTLS = true;
    private boolean requireTLS = false;
    private boolean authenticate = false;
    private EmailService emailService;
    private AuthenticationComponent authenticationComponent;
    private String unknownUser;
    private static volatile Boolean stop = false;

    protected EmailServer() {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    protected int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setBlockedSenders(String blockedSenders) {
        StringTokenizer tokenizer = new StringTokenizer(blockedSenders, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String sender = tokenizer.nextToken().trim();
            this.blockedSenders.add(sender);
        }
    }

    public void setBlockedSendersList(List<String> blockedSenders) {
        this.blockedSenders.addAll(blockedSenders);
    }

    public void setAllowedSenders(String allowedSenders) {
        StringTokenizer tokenizer = new StringTokenizer(allowedSenders, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String sender = tokenizer.nextToken().trim();
            if (sender.length() == 0) continue;
            this.allowedSenders.add(sender);
        }
    }

    public void setAllowedSendersList(List<String> allowedSenders) {
        this.allowedSenders.addAll(allowedSenders);
    }

    protected EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setUnknownUser(String unknownUser) {
        this.unknownUser = unknownUser;
    }

    protected boolean isNullReversePatAllowed() {
        return this.isAuthenticate() || this.unknownUser != null && !this.unknownUser.isEmpty();
    }

    protected void filterSender(String sender) {
        if (sender == null) {
            if (this.isNullReversePatAllowed()) {
                return;
            }
            throw new EmailMessageException(ERR_FROM_SYNTAX_INCORRECT, new Object[0]);
        }
        for (String blockedSender : this.blockedSenders) {
            if (!sender.matches(blockedSender)) continue;
            throw new EmailMessageException(ERR_SENDER_BLOCKED, sender);
        }
        if (!this.allowedSenders.isEmpty()) {
            boolean matched = false;
            for (String allowedSender : this.allowedSenders) {
                if (!sender.matches(allowedSender)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                throw new EmailMessageException(ERR_SENDER_BLOCKED, sender);
            }
        }
    }

    public abstract void startup();

    public abstract void shutdown();

    protected void onBootstrap(ApplicationEvent event) {
        if (!this.enabled) {
            return;
        }
        PropertyCheck.mandatory((Object)((Object)this), (String)"domain", (Object)this.domain);
        if (this.port <= 0 || this.port > 65535) {
            throw new AlfrescoRuntimeException("Property 'port' is incorrect");
        }
        PropertyCheck.mandatory((Object)((Object)this), (String)"emailService", (Object)this.emailService);
        this.startup();
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.enabled) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            EmailServer.usage();
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(args);){
                if (!context.containsBean("emailServer")) {
                    EmailServer.usage();
                    return;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        stop = true;
                        Boolean bl = stop;
                        synchronized (bl) {
                            stop.notifyAll();
                        }
                    }
                });
                System.out.println("Use Ctrl-C to shutdown EmailServer");
                while (!stop.booleanValue()) {
                    Boolean bl = stop;
                    synchronized (bl) {
                        stop.wait();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BeansException e) {
            System.err.println("Error creating context: " + (Object)((Object)e));
            EmailServer.usage();
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void usage() {
        System.err.println("Use: EmailServer configLocation1, configLocation2, ...");
        System.err.println("\t configLocation - spring xml configs with EmailServer related beans (emailServer, emailServerConfiguration, emailService)");
    }

    protected boolean authenticateUserNamePassword(String userName, char[] password) {
        try {
            this.getAuthenticationComponent().authenticate(userName, password);
            return true;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
    }

    public void setHideTLS(boolean hideTLS) {
        this.hideTLS = hideTLS;
    }

    public boolean isHideTLS() {
        return this.hideTLS;
    }

    public void setEnableTLS(boolean enableTLS) {
        this.enableTLS = enableTLS;
    }

    public boolean isEnableTLS() {
        return this.enableTLS;
    }

    public void setRequireTLS(boolean requireTLS) {
        this.requireTLS = requireTLS;
    }

    public boolean isRequireTLS() {
        return this.requireTLS;
    }

    public void setAuthenticate(boolean enableAuthentication) {
        this.authenticate = enableAuthentication;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public AuthenticationComponent getAuthenticationComponent() {
        return this.authenticationComponent;
    }
}

