/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.util.List;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentSearchContext;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DotDotContentSearchContext
extends ContentSearchContext {
    private static final Log logger = LogFactory.getLog(DotDotContentSearchContext.class);
    private FileInfo m_dotInfo;
    private FileInfo m_dotDotInfo;

    protected DotDotContentSearchContext(CifsHelper cifsHelper, List<NodeRef> results, String searchStr, String relPath, boolean lockedFilesAsOffline) {
        super(cifsHelper, results, searchStr, relPath, lockedFilesAsOffline);
        super.setSearchString(searchStr);
    }

    public boolean hasDotFiles() {
        return this.m_dotInfo != null && this.m_dotDotInfo != null;
    }

    public boolean getDotInfo(FileInfo finfo) {
        if (this.m_dotInfo != null) {
            finfo.copyFrom(this.m_dotInfo);
            return true;
        }
        return false;
    }

    public boolean getDotDotInfo(FileInfo finfo) {
        if (this.m_dotDotInfo != null) {
            finfo.copyFrom(this.m_dotDotInfo);
            return true;
        }
        return false;
    }

    protected void setDotInfo(FileInfo finfo) {
        this.m_dotInfo = finfo;
        if (this.m_dotInfo != null) {
            this.m_dotInfo.setFileName(".");
        }
    }

    protected void setDotDotInfo(FileInfo finfo) {
        this.m_dotDotInfo = finfo;
        if (this.m_dotDotInfo != null) {
            this.m_dotDotInfo.setFileName("..");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("[DotDotContextSearch searchStr=");
        sb.append(this.getSearchString());
        sb.append(", resultCount=");
        sb.append(this.getResultsSize());
        if (this.m_dotInfo != null) {
            sb.append(",Dot");
        }
        if (this.m_dotDotInfo != null) {
            sb.append(",DotDot");
        }
        sb.append("]");
        return sb.toString();
    }
}

