/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.doclink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.doclink.GetDoclinkNodesCannedQuery;
import org.alfresco.repo.doclink.GetDoclinkNodesCannedQueryParams;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DeleteLinksStatusReport;
import org.alfresco.service.cmr.repository.DocumentLinkService;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DocumentLinkServiceImpl
implements DocumentLinkService,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static Log logger = LogFactory.getLog(DocumentLinkServiceImpl.class);
    protected static final String CANNED_QUERY_GET_DOC_LINKS = "getDoclinkNodesCannedQueryFactory";
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private CheckOutCheckInService checkOutCheckInService;
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private PermissionService permissionService;
    private CannedQueryDAO cannedQueryDAO;
    private QNameDAO qnameDAO;
    private static final String LINK_NODE_EXTENSION = ".url";
    private static final String LINK_TO_LABEL = "doclink_service.link_to_label";
    private boolean isNodePendingDelete = false;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"checkOutCheckInService", (Object)this.checkOutCheckInService);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"cannedQueryDAO", (Object)this.cannedQueryDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ApplicationModel.ASPECT_LINKED, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ApplicationModel.TYPE_FILELINK, (Behaviour)new JavaBehaviour(this, "beforeDeleteLinkNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ApplicationModel.TYPE_FOLDERLINK, (Behaviour)new JavaBehaviour(this, "beforeDeleteLinkNode"));
    }

    @Override
    public NodeRef createDocumentLink(final NodeRef source, NodeRef destination) {
        ChildAssociationRef childRef;
        block9: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating document link. source: " + source + ", destination: " + destination));
            }
            PropertyCheck.mandatory((Object)this, (String)"source", (Object)source);
            PropertyCheck.mandatory((Object)this, (String)"destination", (Object)destination);
            if (!this.nodeService.exists(source)) {
                throw new IllegalArgumentException("Source NodeRef '" + source + "' does not exist");
            }
            if (!this.nodeService.exists(destination)) {
                throw new IllegalArgumentException("Destination NodeRef '" + destination + "' does not exist");
            }
            if (!this.dictionaryService.isSubClass(this.nodeService.getType(destination), ContentModel.TYPE_FOLDER)) {
                throw new IllegalArgumentException("Destination node NodeRef '" + source + "' must be of type " + ContentModel.TYPE_FOLDER);
            }
            String sourceName = (String)((Object)this.nodeService.getProperty(source, ContentModel.PROP_NAME));
            String newName = String.valueOf(sourceName) + LINK_NODE_EXTENSION;
            newName = I18NUtil.getMessage((String)LINK_TO_LABEL, (Object[])new Object[]{newName});
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, newName);
            props.put(ContentModel.PROP_LINK_DESTINATION, (String)source);
            props.put(ContentModel.PROP_TITLE, newName);
            props.put(ContentModel.PROP_DESCRIPTION, newName);
            QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)newName));
            childRef = null;
            QName sourceType = this.nodeService.getType(source);
            if (this.checkOutCheckInService.isWorkingCopy(source) || this.nodeService.hasAspect(source, ContentModel.ASPECT_LOCKABLE)) {
                throw new IllegalArgumentException("Cannot perform operation since the node (id:" + source.getId() + ") is locked.");
            }
            try {
                if (this.dictionaryService.isSubClass(sourceType, ContentModel.TYPE_CONTENT)) {
                    childRef = this.nodeService.createNode(destination, ContentModel.ASSOC_CONTAINS, assocQName, ApplicationModel.TYPE_FILELINK, props);
                    break block9;
                }
                if (!this.dictionaryService.isSubClass(sourceType, SiteModel.TYPE_SITE) && this.dictionaryService.isSubClass(this.nodeService.getType(source), ContentModel.TYPE_FOLDER)) {
                    props.put(ApplicationModel.PROP_ICON, "space-icon-link");
                    childRef = this.nodeService.createNode(destination, ContentModel.ASSOC_CONTAINS, assocQName, ApplicationModel.TYPE_FOLDERLINK, props);
                    break block9;
                }
                throw new IllegalArgumentException("Unsupported source node type : " + this.nodeService.getType(source));
            }
            catch (DuplicateChildNodeNameException ex) {
                throw new IllegalArgumentException("A file with the name '" + newName + "' already exists in the destination folder", ex);
            }
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Void doWork() throws Exception {
                DocumentLinkServiceImpl.this.behaviourFilter.disableBehaviour(source, ContentModel.ASPECT_AUDITABLE);
                try {
                    DocumentLinkServiceImpl.this.nodeService.addAspect(source, ApplicationModel.ASPECT_LINKED, null);
                }
                finally {
                    DocumentLinkServiceImpl.this.behaviourFilter.enableBehaviour(source, ContentModel.ASPECT_AUDITABLE);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return childRef.getChildRef();
    }

    @Override
    public NodeRef getLinkDestination(NodeRef linkNodeRef) {
        PropertyCheck.mandatory((Object)this, (String)"linkNodeRef", (Object)linkNodeRef);
        if (!this.nodeService.exists(linkNodeRef)) {
            throw new IllegalArgumentException("The provided node does not exist");
        }
        if (!this.nodeService.getType(linkNodeRef).equals((Object)ApplicationModel.TYPE_FILELINK) && !this.nodeService.getType(linkNodeRef).equals((Object)ApplicationModel.TYPE_FOLDERLINK)) {
            throw new IllegalArgumentException("The provided node is not a document link");
        }
        return (NodeRef)this.nodeService.getProperty(linkNodeRef, ContentModel.PROP_LINK_DESTINATION);
    }

    @Override
    public List<Long> getNodeLinksIds(NodeRef nodeRef) {
        PropertyCheck.mandatory((Object)this, (String)"nodeRef", (Object)nodeRef);
        PagingRequest pagingRequest = new PagingRequest(0, 100000);
        ArrayList<Long> nodeLinks = new ArrayList<Long>();
        Pair<Long, QName> nameQName = this.qnameDAO.getQName(ContentModel.PROP_LINK_DESTINATION);
        if (nameQName != null) {
            GetDoclinkNodesCannedQueryParams parameterBean = new GetDoclinkNodesCannedQueryParams(nodeRef.toString(), (Long)nameQName.getFirst(), pagingRequest.getMaxItems());
            CannedQueryParameters params = new CannedQueryParameters((Object)parameterBean, null, null, pagingRequest.getRequestTotalCountMax(), pagingRequest.getQueryExecutionId());
            GetDoclinkNodesCannedQuery query = new GetDoclinkNodesCannedQuery(this.cannedQueryDAO, params);
            CannedQueryResults results = query.execute();
            for (Long nodeId : results.getPage()) {
                nodeLinks.add(nodeId);
            }
        }
        return nodeLinks;
    }

    @Override
    public DeleteLinksStatusReport deleteLinksToDocument(NodeRef document) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting links of a document. document: " + document));
        }
        PropertyCheck.mandatory((Object)this, (String)"document", (Object)document);
        DeleteLinksStatusReport report = new DeleteLinksStatusReport();
        List<Long> linkNodeIds = this.getNodeLinksIds(document);
        report.addTotalLinksFoundCount(linkNodeIds.size());
        for (final Long linkId : linkNodeIds) {
            NodeRef linkNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef nodeRef = DocumentLinkServiceImpl.this.nodeService.getNodeRef(linkId);
                    DocumentLinkServiceImpl.this.isNodePendingDelete = DocumentLinkServiceImpl.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_PENDING_DELETE);
                    return nodeRef;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (this.isNodePendingDelete) continue;
            if (this.permissionService.hasPermission(linkNodeRef, "DeleteNode") == AccessStatus.DENIED) {
                report.addErrorDetail(linkNodeRef, (Throwable)((Object)new AccessDeniedException("User '" + AuthenticationUtil.getFullyAuthenticatedUser() + "' doesn't have permission to create discussion on node '" + linkNodeRef + "'")));
                continue;
            }
            this.nodeService.deleteNode(linkNodeRef);
            report.incrementDeletedLinksCount();
        }
        if (report.getTotalLinksFoundCount() == report.getDeletedLinksCount()) {
            this.behaviourFilter.disableBehaviour(document, ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.disableBehaviour(document, ContentModel.ASPECT_LOCKABLE);
            try {
                this.nodeService.removeAspect(document, ApplicationModel.ASPECT_LINKED);
            }
            finally {
                this.behaviourFilter.enableBehaviour(document, ContentModel.ASPECT_AUDITABLE);
                this.behaviourFilter.enableBehaviour(document, ContentModel.ASPECT_LOCKABLE);
            }
        }
        return report;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        try {
            this.deleteLinksToDocument(nodeRef);
        }
        finally {
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
    }

    public void beforeDeleteLinkNode(NodeRef linkNodeRef) {
        final NodeRef nodeRef = this.getLinkDestination(linkNodeRef);
        List<Long> nodeRefLinks = this.getNodeLinksIds(nodeRef);
        long linkNodeId = (Long)this.nodeService.getProperty(linkNodeRef, ContentModel.PROP_NODE_DBID);
        if (nodeRefLinks.size() == 1 && nodeRefLinks.contains(linkNodeId)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Void doWork() throws Exception {
                    DocumentLinkServiceImpl.this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                    DocumentLinkServiceImpl.this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_LOCKABLE);
                    try {
                        DocumentLinkServiceImpl.this.nodeService.removeAspect(nodeRef, ApplicationModel.ASPECT_LINKED);
                    }
                    finally {
                        DocumentLinkServiceImpl.this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                        DocumentLinkServiceImpl.this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_LOCKABLE);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setCannedQueryDAO(CannedQueryDAO cannedQueryDAO) {
        this.cannedQueryDAO = cannedQueryDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }
}

