/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.forms.processor.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterRegistry<ItemType, PersistType> {
    private static final Log logger = LogFactory.getLog(FilterRegistry.class);
    protected List<Filter<ItemType, PersistType>> filters = new ArrayList<Filter<ItemType, PersistType>>(4);

    public void addFilter(Filter<ItemType, PersistType> filter) {
        if (filter.isActive()) {
            this.filters.add(filter);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered filter: " + filter + " in registry: " + this));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Ignored registration of filter " + filter + " as it was marked as inactive"));
        }
    }

    public List<Filter<ItemType, PersistType>> getFilters() {
        ArrayList<Filter<ItemType, PersistType>> activeFilters = new ArrayList<Filter<ItemType, PersistType>>(4);
        for (Filter<ItemType, PersistType> filter : this.filters) {
            if (!filter.isActive()) continue;
            activeFilters.add(filter);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning active filters: " + activeFilters));
        }
        return activeFilters;
    }
}

