/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;

public abstract class AbstractCategoryServiceImpl
implements CategoryService {
    protected NodeService nodeService;
    protected NodeService publicNodeService;
    protected TenantService tenantService;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected DictionaryService dictionaryService;
    protected IndexerAndSearcher indexerAndSearcher;
    protected int queryFetchSize = 5000;
    HashMap<String, String> prefixLookup = new HashMap();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPublicNodeService(NodeService publicNodeService) {
        this.publicNodeService = publicNodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    @Override
    public Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth) {
        return this.getChildren(categoryRef, mode, depth, false, null, this.queryFetchSize);
    }

    public Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth, String filter) {
        return this.getChildren(categoryRef, mode, depth, false, filter, this.queryFetchSize);
    }

    private Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth, boolean sortByName, String filter, int fetchSize) {
        if (categoryRef == null) {
            return Collections.emptyList();
        }
        categoryRef = this.tenantService.getBaseName(categoryRef);
        try (ResultSet resultSet = null;){
            StringBuilder luceneQuery = new StringBuilder(64);
            switch (mode) {
                case ALL: {
                    luceneQuery.append("PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("*").append("\" ");
                    break;
                }
                case MEMBERS: {
                    luceneQuery.append("PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("member").append("\" ");
                    break;
                }
                case SUB_CATEGORIES: {
                    luceneQuery.append("+PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("*").append("\" ");
                    luceneQuery.append("+TYPE:\"" + ContentModel.TYPE_CATEGORY.toString() + "\"");
                }
            }
            if (filter != null) {
                luceneQuery.append(" +@cm\\:name:\"*" + filter + "*\"");
            }
            SearchService searcher = this.indexerAndSearcher.getSearcher(categoryRef.getStoreRef(), true);
            SearchParameters searchParameters = new SearchParameters();
            resultSet = searcher.query(categoryRef.getStoreRef(), "lucene", luceneQuery.toString(), null);
            searchParameters.setLanguage("lucene");
            if (sortByName) {
                searchParameters.addSort("@" + ContentModel.PROP_NAME, true);
            }
            searchParameters.setQuery(luceneQuery.toString());
            searchParameters.setLimit(-1);
            searchParameters.setMaxItems(fetchSize);
            searchParameters.setLimitBy(LimitBy.FINAL_SIZE);
            searchParameters.addStore(categoryRef.getStoreRef());
            resultSet = searcher.query(searchParameters);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
    }

    private String buildXPath(Path path) {
        StringBuilder pathBuffer = new StringBuilder(64);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + path);
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            if (cae.getRef().getParentRef() == null) continue;
            pathBuffer.append("/");
            pathBuffer.append(this.getPrefix(cae.getRef().getQName().getNamespaceURI()));
            pathBuffer.append(ISO9075.encode((String)cae.getRef().getQName().getLocalName()));
        }
        return pathBuffer.toString();
    }

    private String getPrefix(String uri) {
        String prefix = this.prefixLookup.get(uri);
        if (prefix == null) {
            Collection prefixes = this.namespacePrefixResolver.getPrefixes(uri);
            Iterator iterator = prefixes.iterator();
            if (iterator.hasNext()) {
                String first;
                prefix = first = (String)iterator.next();
            }
            this.prefixLookup.put(uri, prefix);
        }
        if (prefix == null) {
            return "";
        }
        return String.valueOf(prefix) + ":";
    }

    private Collection<ChildAssociationRef> resultSetToChildAssocCollection(ResultSet resultSet) {
        LinkedList<ChildAssociationRef> collection = new LinkedList<ChildAssociationRef>();
        if (resultSet != null) {
            for (ResultSetRow row : resultSet) {
                try {
                    ChildAssociationRef car = this.nodeService.getPrimaryParent(row.getNodeRef());
                    collection.add(car);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {}
            }
        }
        return collection;
    }

    @Override
    public Collection<ChildAssociationRef> getCategories(StoreRef storeRef, QName aspectQName, CategoryService.Depth depth) {
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectQName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, depth));
        }
        return assocs;
    }

    protected Set<NodeRef> getClassificationNodes(StoreRef storeRef, QName qname) {
        try (ResultSet resultSet = null;){
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH:\"/" + this.getPrefix(qname.getNamespaceURI()) + ISO9075.encode((String)qname.getLocalName()) + "\"", null);
            HashSet<NodeRef> nodeRefs = new HashSet<NodeRef>(resultSet.length());
            for (ResultSetRow row : resultSet) {
                nodeRefs.add(row.getNodeRef());
            }
            HashSet<NodeRef> hashSet = nodeRefs;
            return hashSet;
        }
    }

    @Override
    public Collection<ChildAssociationRef> getClassifications(StoreRef storeRef) {
        try (ResultSet resultSet = null;){
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH:\"//cm:categoryRoot/*\"", null);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
    }

    @Override
    public Collection<QName> getClassificationAspects() {
        return this.dictionaryService.getSubAspects(ContentModel.ASPECT_CLASSIFIABLE, true);
    }

    @Override
    public NodeRef createClassification(StoreRef storeRef, QName typeName, String attributeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PagingResults<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, PagingRequest pagingRequest, boolean sortByName) {
        return this.getRootCategories(storeRef, aspectName, pagingRequest, sortByName, null);
    }

    @Override
    public PagingResults<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, PagingRequest pagingRequest, boolean sortByName, String filter) {
        final LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        int skipCount = pagingRequest.getSkipCount();
        int maxItems = pagingRequest.getMaxItems();
        int size = maxItems == Integer.MAX_VALUE ? Integer.MAX_VALUE : skipCount + maxItems;
        int count = 0;
        boolean moreItems = false;
        block0: for (NodeRef nodeRef : nodeRefs) {
            Collection<ChildAssociationRef> children = this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE, sortByName, filter, skipCount + maxItems + 1);
            for (ChildAssociationRef child : children) {
                if (++count <= skipCount) continue;
                if (count > size) {
                    moreItems = true;
                    break block0;
                }
                assocs.add(child);
            }
        }
        final boolean hasMoreItems = moreItems;
        return new PagingResults<ChildAssociationRef>(){

            public List<ChildAssociationRef> getPage() {
                return assocs;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return new Pair(null, null);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName) {
        return this.getRootCategories(storeRef, aspectName, null);
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, String filter) {
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE, false, filter, this.queryFetchSize));
        }
        return assocs;
    }

    @Override
    public ChildAssociationRef getCategory(NodeRef parent, QName aspectName, String name) {
        String validLocalName;
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        List assocs = this.nodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_SUBCATEGORIES, (QNamePattern)QName.createQName((String)uri, (String)(validLocalName = QName.createValidLocalName((String)name))), false);
        if (assocs.isEmpty()) {
            return null;
        }
        return (ChildAssociationRef)assocs.iterator().next();
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, String name, boolean create) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        for (NodeRef nodeRef : nodeRefs) {
            ChildAssociationRef category = this.getCategory(nodeRef, aspectName, name);
            if (category == null) continue;
            assocs.add(category);
        }
        if (create && assocs.isEmpty()) {
            assocs.add(this.createCategoryInternal(nodeRefs.iterator().next(), name));
        }
        return assocs;
    }

    @Override
    public NodeRef createCategory(NodeRef parent, String name) {
        return this.createCategoryInternal(parent, name).getChildRef();
    }

    private ChildAssociationRef createCategoryInternal(NodeRef parent, String name) {
        if (!this.nodeService.exists(parent)) {
            throw new AlfrescoRuntimeException("Missing category?");
        }
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        String validLocalName = QName.createValidLocalName((String)name);
        ChildAssociationRef newCategory = this.publicNodeService.createNode(parent, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)uri, (String)validLocalName), ContentModel.TYPE_CATEGORY);
        this.publicNodeService.setProperty(newCategory.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)name));
        return newCategory;
    }

    @Override
    public NodeRef createRootCategory(StoreRef storeRef, QName aspectName, String name) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException("Missing classification: " + aspectName);
        }
        NodeRef parent = nodeRefs.iterator().next();
        return this.createCategory(parent, name);
    }

    @Override
    public void deleteCategory(NodeRef nodeRef) {
        this.publicNodeService.deleteNode(nodeRef);
    }

    @Override
    public void deleteClassification(StoreRef storeRef, QName aspectName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract List<Pair<NodeRef, Integer>> getTopCategories(StoreRef var1, QName var2, int var3);
}

