/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.alfresco.repo.search.QueryParserException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class AbstractSolrQueryHTTPClient {
    private static final Log LOGGER = LogFactory.getLog(AbstractSolrQueryHTTPClient.class);
    public static final int DEFAULT_SAVEPOST_BUFFER = 4096;
    public static final String HIGHLIGHT_PARAMS_HIGHLIGHT = "hl";
    public static final String HIGHLIGHT_PARAMS_FIELDS = "hl.fl";
    public static final String HIGHLIGHT_PARAMS_SNIPPETS = "hl.snippets";
    public static final String HIGHLIGHT_PARAMS_FRAGSIZE = "hl.fragsize";
    public static final String HIGHLIGHT_PARAMS_INCREMENT = "hl.increment";
    public static final String HIGHLIGHT_PARAMS_MAX_CHARS = "hl.maxAnalyzedChars";
    public static final String HIGHLIGHT_PARAMS_FORMATTER = "hl.formatter";
    public static final String HIGHLIGHT_PARAMS_FRAGMENTER = "hl.fragmenter";
    public static final String HIGHLIGHT_PARAMS_FIELD_MATCH = "hl.requireFieldMatch";
    public static final String HIGHLIGHT_PARAMS_ALTERNATE_FIELD = "hl.alternateField";
    public static final String HIGHLIGHT_PARAMS_ALTERNATE_FIELD_LENGTH = "hl.maxAlternateFieldLength";
    public static final String HIGHLIGHT_PARAMS_USE_PHRASE_HIGHLIGHTER = "hl.usePhraseHighlighter";
    public static final String HIGHLIGHT_PARAMS_HIGHLIGHT_MULTI_TERM = "hl.highlightMultiTerm";
    public static final String HIGHLIGHT_PARAMS_MERGE_CONTIGUOUS_FRAGMENTS = "hl.mergeContiguous";
    public static final String HIGHLIGHT_PARAMS_SIMPLE = "simple";
    public static final String HIGHLIGHT_PARAMS_SIMPLE_PRE = "hl.simple.pre";
    public static final String HIGHLIGHT_PARAMS_SIMPLE_POST = "hl.simple.post";
    public static final String HIGHLIGHT_PARAMS_REGEX = "regex";
    public static final String HIGHLIGHT_PARAMS_SLOP = "hl.regex.slop";
    public static final String HIGHLIGHT_PARAMS_PATTERN = "hl.regex.pattern";
    public static final String HIGHLIGHT_PARAMS_MAX_RE_CHARS = "hl.regex.maxAnalyzedChars";
    private static final List<String> STATUS_CODE_501_EXCEPTIONS = List.of("java.lang.UnsupportedOperationException");

    protected JSONObject postQuery(HttpClient httpClient, String url, JSONObject body) throws IOException, JSONException {
        PostMethod post = this.createNewPostMethod(url);
        if (body.toString().length() > 4096) {
            post.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        }
        StringRequestEntity requestEntity = new StringRequestEntity(body.toString(), "application/json", "UTF-8");
        post.setRequestEntity((RequestEntity)requestEntity);
        try {
            JSONObject json;
            Header locationHeader;
            httpClient.executeMethod((HttpMethod)post);
            if ((post.getStatusCode() == 301 || post.getStatusCode() == 302) && (locationHeader = post.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                post.setURI(new URI(redirectLocation, true));
                httpClient.executeMethod((HttpMethod)post);
            }
            String responseBodyStr = post.getResponseBodyAsString();
            if (post.getStatusCode() != 200) {
                String traceException;
                String trace = null;
                try {
                    trace = new JSONObject(responseBodyStr).getJSONObject("error").getString("trace");
                }
                catch (JSONException jSONException) {
                    LOGGER.warn((Object)("Node 'error.trace' is not present in Search Services error response: " + responseBodyStr));
                    LOGGER.warn((Object)"A generic error message will be provided. Check SOLR log file in order to find the root cause for this issue");
                }
                int httpStatusCode = post.getStatusCode();
                String message = "Solr request failed with " + httpStatusCode + " " + url;
                if (trace != null && STATUS_CODE_501_EXCEPTIONS.contains(traceException = trace.substring(0, trace.indexOf(":")).trim())) {
                    httpStatusCode = 501;
                }
                throw new QueryParserException(message, httpStatusCode);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream(), post.getResponseCharSet()));
            JSONObject jSONObject = json = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
        finally {
            post.releaseConnection();
        }
    }

    protected PostMethod createNewPostMethod(String url) {
        return new PostMethod(url);
    }
}

