/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryParser;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.admin.patch.OptionalPatchApplicationCheckBootstrapBean;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;

public class DbCmisQueryLanguage
extends AbstractLuceneQueryLanguage {
    QueryEngine queryEngine;
    private CMISDictionaryService cmisDictionaryService;
    OptionalPatchApplicationCheckBootstrapBean metadataIndexCheck1;
    OptionalPatchApplicationCheckBootstrapBean metadataIndexCheck2;

    public void setMetadataIndexCheck1(OptionalPatchApplicationCheckBootstrapBean metadataIndexCheck1) {
        this.metadataIndexCheck1 = metadataIndexCheck1;
    }

    public void setMetadataIndexCheck2(OptionalPatchApplicationCheckBootstrapBean metadataIndexCheck2) {
        this.metadataIndexCheck2 = metadataIndexCheck2;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public DbCmisQueryLanguage() {
        this.setName("db-cmis");
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters) {
        if (this.metadataIndexCheck1.getPatchApplied()) {
            return this.executeQueryImpl(searchParameters);
        }
        throw new QueryModelException("The patch to add the indexes to support in-transactional metadata queries has not been applied");
    }

    private ResultSet executeQueryImpl(SearchParameters searchParameters) {
        CMISQueryOptions options = CMISQueryOptions.create((SearchParameters)searchParameters);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        CapabilityJoin joinSupport = CapabilityJoin.INNERANDOUTER;
        BaseTypeId[] validScopes = CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService(this.cmisDictionaryService);
        functionContext.setValidScopes(validScopes);
        CMISQueryParser parser = new CMISQueryParser(options, this.cmisDictionaryService, joinSupport);
        Query queryModelQuery = parser.parse(this.queryEngine.getQueryModelFactory(), (FunctionEvaluationContext)functionContext);
        QueryEngineResults results = this.queryEngine.executeQuery(queryModelQuery, (QueryOptions)options, (FunctionEvaluationContext)functionContext);
        ResultSet resultSet = (ResultSet)results.getResults().values().iterator().next();
        return resultSet;
    }
}

